/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.collection.LimitedPool;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.http.api.HttpRequest;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class HttpRequestPool
extends LimitedPoolResource<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestPool.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final Session.ResourceKey<LimitedPoolResource<HttpRequest>> KEY = new LimitedPoolResource.Key<HttpRequest>();

    public HttpRequestPool(Scenario scenario, Session session) {
        super(scenario.maxRequests(), HttpRequest.class, () -> new HttpRequest(session));
    }

    public static LimitedPool<HttpRequest> get(Session session) {
        return session.getResource(KEY);
    }

    @Override
    public void onSessionReset(Session session) {
        if (!this.isFull()) {
            for (HttpRequest request : (HttpRequest[])this.originalObjects) {
                if (request.isCompleted()) continue;
                log.warn((Object)"#{} Session completed with requests in-flight!", new Object[]{session.uniqueId()});
                break;
            }
            this.cancelRequests();
        }
        super.onSessionReset(session);
    }

    private void cancelRequests() {
        for (HttpRequest request : (HttpRequest[])this.originalObjects) {
            if (request.isCompleted()) continue;
            if (!request.isValid()) {
                request.statistics().addInvalid(request.startTimestampMillis());
            }
            if (trace) {
                log.trace((Object)"Canceling request on {}", new Object[]{request.connection()});
            }
            request.setCompleting();
            if (request.connection() != null) {
                request.connection().close();
            }
            if (request.isCompleted()) continue;
            log.trace((Object)"#{} Connection close did not complete the request.", new Object[]{request.session != null ? request.session.uniqueId() : 0});
            request.setCompleted();
            request.release();
        }
    }
}

