/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Sequence;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.api.PluginRunData;
import io.hyperfoil.http.HttpCacheImpl;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpPluginConfig;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.hyperfoil.http.connection.HttpDestinationTableImpl;
import io.hyperfoil.http.connection.PrivateConnectionPool;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.net.ssl.SSLException;

public class HttpRunData
implements PluginRunData {
    private final HttpPluginConfig plugin;
    private final HttpDestinationTableImpl[] destinations;
    private final Map<String, HttpClientPool> clientPools = new HashMap<String, HttpClientPool>();
    private final boolean hasPrivatePools;

    public HttpRunData(Benchmark benchmark, EventLoop[] executors, int agentId) {
        this.plugin = benchmark.plugin(HttpPluginConfig.class);
        this.hasPrivatePools = this.plugin.http().values().stream().anyMatch(Http::privatePools);
        Map[] connectionPools = new Map[executors.length];
        this.destinations = new HttpDestinationTableImpl[executors.length];
        for (Map.Entry<String, Http> http : this.plugin.http().entrySet()) {
            try {
                HttpClientPoolImpl httpClientPool = new HttpClientPoolImpl(http.getValue(), executors, benchmark, agentId);
                this.clientPools.put(http.getKey(), httpClientPool);
                if (http.getValue().isDefault()) {
                    this.clientPools.put(null, httpClientPool);
                }
                for (int executorId = 0; executorId < executors.length; ++executorId) {
                    HttpConnectionPool httpConnectionPool = httpClientPool.connectionPool((EventExecutor)executors[executorId]);
                    HashMap<String, HttpConnectionPool> pools = connectionPools[executorId];
                    if (pools == null) {
                        connectionPools[executorId] = pools = new HashMap<String, HttpConnectionPool>();
                    }
                    pools.put(http.getKey(), httpConnectionPool);
                    if (!http.getValue().isDefault()) continue;
                    pools.put(null, httpConnectionPool);
                }
            }
            catch (SSLException e) {
                throw new IllegalStateException("Failed creating connection pool to " + http.getValue().host() + ":" + http.getValue().port(), e);
            }
        }
        for (int executorId = 0; executorId < connectionPools.length; ++executorId) {
            Map pools = connectionPools[executorId];
            this.destinations[executorId] = new HttpDestinationTableImpl(pools);
        }
    }

    public static void initForTesting(Session session) {
        HttpRunData.initForTesting(session, Clock.systemDefaultZone());
    }

    public static void initForTesting(Session session, Clock clock) {
        Scenario dummyScenario = new Scenario(new Sequence[0], new Sequence[0], null, null, 16, 16);
        session.declareSingletonResource(HttpDestinationTable.KEY, new HttpDestinationTableImpl(Collections.emptyMap()));
        session.declareSingletonResource(HttpCache.KEY, new HttpCacheImpl(clock));
        session.declareSingletonResource(HttpRequestPool.KEY, new HttpRequestPool(dummyScenario, session));
    }

    @Override
    public void initSession(Session session, int executorId, Scenario scenario, Clock clock) {
        HttpDestinationTableImpl destinations = this.destinations[executorId];
        if (this.hasPrivatePools) {
            destinations = new HttpDestinationTableImpl(destinations, pool -> pool.clientPool().config().privatePools() ? new PrivateConnectionPool((HttpConnectionPool)pool) : pool);
        }
        session.declareSingletonResource(HttpDestinationTable.KEY, destinations);
        session.declareSingletonResource(HttpCache.KEY, new HttpCacheImpl(clock));
        session.declareSingletonResource(HttpRequestPool.KEY, new HttpRequestPool(scenario, session));
    }

    @Override
    public void openConnections(Consumer<Future<Void>> promiseCollector) {
        for (Map.Entry<String, HttpClientPool> entry : this.clientPools.entrySet()) {
            if (entry.getKey() == null) continue;
            Promise promise = Promise.promise();
            promiseCollector.accept((Future<Void>)promise.future());
            entry.getValue().start((Handler<AsyncResult<Void>>)promise);
        }
    }

    @Override
    public void listConnections(Consumer<String> connectionCollector) {
        for (HttpDestinationTableImpl destinations : this.destinations) {
            for (Map.Entry<String, HttpConnectionPool> entry : destinations.iterable()) {
                if (entry.getKey() == null) continue;
                HttpConnectionPool pool = entry.getValue();
                Collection<? extends HttpConnection> connections = pool.connections();
                HashMap<String, AtomicInteger> byType = new HashMap<String, AtomicInteger>();
                int available = 0;
                int inFlight = 0;
                for (HttpConnection httpConnection : connections) {
                    if (httpConnection.isAvailable()) {
                        ++available;
                    }
                    inFlight += httpConnection.inFlight();
                    byType.computeIfAbsent(httpConnection.getClass().getSimpleName() + (httpConnection.isSecure() ? "(SSL)" : ""), k -> new AtomicInteger()).incrementAndGet();
                }
                connectionCollector.accept(String.format("%s: %d/%d available, %d in-flight requests, %d waiting sessions (estimate), types: %s", entry.getKey(), available, connections.size(), inFlight, pool.waitingSessions(), byType));
            }
        }
    }

    @Override
    public void shutdown() {
        for (HttpClientPool pool : this.clientPools.values()) {
            pool.shutdown();
        }
    }
}

