/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.core.util.Util;
import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final CharSequence[] MONTHS = new CharSequence[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final byte[] BYTES_80 = "80".getBytes(StandardCharsets.UTF_8);
    private static final byte[] BYTES_443 = "443".getBytes(StandardCharsets.UTF_8);
    public static final String HTTP_PREFIX = "http://";
    public static final String HTTPS_PREFIX = "https://";

    private HttpUtil() {
    }

    public static int indexOf(CharSequence seq, int begin, char c) {
        int length = seq.length();
        for (int i = begin; i < length; ++i) {
            if (seq.charAt(i) != c) continue;
            return i;
        }
        return length;
    }

    public static int lastIndexOf(CharSequence seq, int end, char c) {
        for (int i = end - 1; i >= 0; --i) {
            if (seq.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    static long parseDate(CharSequence seq) {
        return HttpUtil.parseDate(seq, 0, seq.length());
    }

    public static long parseDate(CharSequence seq, int begin, int end) {
        int year;
        int i;
        for (i = begin; i < end && seq.charAt(i) != ','; ++i) {
        }
        ++i;
        while (i < end && seq.charAt(i) == ' ') {
            ++i;
        }
        if (i + 2 >= end) {
            log.warn("Cannot parse date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        int dayOfMonth = HttpUtil.twoDigits(seq, i);
        if (dayOfMonth < 1 || dayOfMonth > 31) {
            log.warn("Cannot parse date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        if ((i += 3) + 3 >= end) {
            log.warn("Cannot parse date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        int month = -1;
        for (int m = 0; m < MONTHS.length; ++m) {
            if (Character.toLowerCase(seq.charAt(i)) != MONTHS[m].charAt(0) || Character.toLowerCase(seq.charAt(i + 1)) != MONTHS[m].charAt(1) || Character.toLowerCase(seq.charAt(i + 2)) != MONTHS[m].charAt(2)) continue;
            month = m;
            break;
        }
        if (month < 0) {
            log.warn("Cannot parse month in date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        int nextSpace = HttpUtil.indexOf(seq, i += 4, ' ');
        if (nextSpace - i == 4) {
            year = (int)Util.parseLong(seq, i, nextSpace);
            if (year < 1600 || year >= 3000) {
                log.warn("Cannot parse year in date {}", (Object)seq.subSequence(begin, end));
                return 0L;
            }
        } else if (nextSpace - i == 2) {
            year = HttpUtil.twoDigits(seq, i);
            if (year < 0 || year > 100) {
                log.warn("Cannot parse year in date {}", (Object)seq.subSequence(begin, end));
                return 0L;
            }
            year = year < 70 ? (year += 2000) : (year += 1900);
        } else {
            log.warn("Cannot parse year in date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        for (i = nextSpace + 1; i < end && seq.charAt(i) == ' '; ++i) {
        }
        if (i + 8 >= end || seq.charAt(i + 2) != ':' || seq.charAt(i + 5) != ':') {
            log.warn("Cannot parse time in date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        int hour = HttpUtil.twoDigits(seq, i);
        int minute = HttpUtil.twoDigits(seq, i + 3);
        int second = HttpUtil.twoDigits(seq, i + 6);
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
            log.warn("Cannot parse time in date {}", (Object)seq.subSequence(begin, end));
            return 0L;
        }
        i += 8;
        while (i < end && seq.charAt(i) == ' ') {
            ++i;
        }
        TimeZone timeZone = UTC;
        if (i < end) {
            timeZone = end - i >= 3 && AsciiString.regionMatches((CharSequence)seq, (boolean)false, (int)i, (CharSequence)"GMT", (int)0, (int)3) ? GMT : (end - i >= 3 && AsciiString.regionMatches((CharSequence)seq, (boolean)false, (int)i, (CharSequence)"UTC", (int)0, (int)3) ? UTC : TimeZone.getTimeZone(seq.subSequence(i, end).toString()));
        }
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.set(year, month, dayOfMonth, hour, minute, second);
        return calendar.getTimeInMillis();
    }

    private static int twoDigits(CharSequence seq, int i) {
        return 10 * (seq.charAt(i) - 48) + (seq.charAt(i + 1) - 48);
    }

    public static CharSequence formatDate(long timestamp) {
        Calendar calendar = Calendar.getInstance(GMT);
        calendar.setTimeInMillis(timestamp);
        byte[] bytes = new byte[29];
        switch (calendar.get(7)) {
            case 1: {
                bytes[0] = 83;
                bytes[1] = 117;
                bytes[2] = 110;
                break;
            }
            case 2: {
                bytes[0] = 77;
                bytes[1] = 111;
                bytes[2] = 110;
                break;
            }
            case 3: {
                bytes[0] = 84;
                bytes[1] = 117;
                bytes[2] = 101;
                break;
            }
            case 4: {
                bytes[0] = 87;
                bytes[1] = 101;
                bytes[2] = 100;
                break;
            }
            case 5: {
                bytes[0] = 84;
                bytes[1] = 104;
                bytes[2] = 117;
                break;
            }
            case 6: {
                bytes[0] = 70;
                bytes[1] = 114;
                bytes[2] = 105;
                break;
            }
            case 7: {
                bytes[0] = 83;
                bytes[1] = 97;
                bytes[2] = 116;
            }
        }
        bytes[3] = 44;
        bytes[4] = 32;
        int dayOfMonth = calendar.get(5);
        bytes[5] = (byte)(48 + dayOfMonth / 10);
        bytes[6] = (byte)(48 + dayOfMonth % 10);
        bytes[7] = 45;
        CharSequence month = MONTHS[calendar.get(2)];
        bytes[8] = (byte)month.charAt(0);
        bytes[9] = (byte)month.charAt(1);
        bytes[10] = (byte)month.charAt(2);
        bytes[11] = 45;
        int year = calendar.get(1);
        bytes[12] = (byte)(48 + year / 1000);
        bytes[13] = (byte)(48 + year / 100 % 10);
        bytes[14] = (byte)(48 + year / 10 % 10);
        bytes[15] = (byte)(48 + year % 10);
        bytes[16] = 32;
        int hour = calendar.get(11);
        bytes[17] = (byte)(48 + hour / 10);
        bytes[18] = (byte)(48 + hour % 10);
        bytes[19] = 58;
        int minute = calendar.get(12);
        bytes[20] = (byte)(48 + minute / 10);
        bytes[21] = (byte)(48 + minute % 10);
        bytes[22] = 58;
        int second = calendar.get(13);
        bytes[23] = (byte)(48 + second / 10);
        bytes[24] = (byte)(48 + second % 10);
        bytes[25] = 32;
        bytes[26] = 71;
        bytes[27] = 77;
        bytes[28] = 84;
        return new AsciiString(bytes, false);
    }

    public static boolean authorityMatch(CharSequence path, CharSequence authority, boolean isHttp) {
        return isHttp ? HttpUtil.authorityMatchHttp(path, authority) : HttpUtil.authorityMatchHttps(path, authority);
    }

    public static boolean authorityMatchHttp(CharSequence path, CharSequence authority) {
        return HttpUtil.authorityMatch(path, authority, "80", HTTP_PREFIX.length());
    }

    public static boolean authorityMatchHttps(CharSequence path, CharSequence authority) {
        return HttpUtil.authorityMatch(path, authority, "443", HTTPS_PREFIX.length());
    }

    public static boolean authorityMatch(CharSequence path, CharSequence authority, String defaultPort, int prefixLength) {
        int colonIndex = HttpUtil.indexOf(authority, 0, ':');
        if (!AsciiString.regionMatches((CharSequence)path, (boolean)true, (int)prefixLength, (CharSequence)authority, (int)0, (int)colonIndex)) {
            return false;
        }
        if (path.charAt(prefixLength + colonIndex) == ':') {
            int portLength;
            int portOffset;
            CharSequence port;
            if (authority.length() == colonIndex) {
                port = defaultPort;
                portOffset = 0;
                portLength = defaultPort.length();
            } else {
                port = authority;
                portOffset = colonIndex + 1;
                portLength = authority.length() - colonIndex - 1;
            }
            return AsciiString.regionMatches((CharSequence)path, (boolean)false, (int)(prefixLength + colonIndex), (CharSequence)port, (int)portOffset, (int)portLength);
        }
        return colonIndex == authority.length() || colonIndex == authority.length() - defaultPort.length() - 1 && AsciiString.regionMatches((CharSequence)authority, (boolean)false, (int)(authority.length() - defaultPort.length()), (CharSequence)defaultPort, (int)0, (int)defaultPort.length());
    }

    public static boolean authorityMatch(ByteBuf pathData, int pathOffset, int pathLength, byte[] authority, boolean isHttp) {
        return isHttp ? HttpUtil.authorityMatchHttp(pathData, pathOffset, pathLength, authority) : HttpUtil.authorityMatchHttps(pathData, pathOffset, pathLength, authority);
    }

    public static boolean authorityMatchHttp(ByteBuf pathData, int pathOffset, int pathLength, byte[] authority) {
        return HttpUtil.authorityMatch(pathData, pathOffset, pathLength, authority, BYTES_80, HTTP_PREFIX.length());
    }

    public static boolean authorityMatchHttps(ByteBuf pathData, int pathOffset, int pathLength, byte[] authority) {
        return HttpUtil.authorityMatch(pathData, pathOffset, pathLength, authority, BYTES_443, HTTPS_PREFIX.length());
    }

    public static boolean authorityMatch(ByteBuf pathData, int pathOffset, int pathLength, byte[] authority, byte[] defaultPort, int prefixLength) {
        int colonIndex = HttpUtil.indexOf(authority, (byte)58);
        if (!HttpUtil.regionMatches(pathData, pathOffset + prefixLength, pathLength - prefixLength, authority, 0, colonIndex)) {
            return false;
        }
        if (pathData.getByte(prefixLength + colonIndex) == 58) {
            int portLength;
            int portOffset;
            byte[] port;
            if (authority.length == colonIndex) {
                port = defaultPort;
                portOffset = 0;
                portLength = defaultPort.length;
            } else {
                port = authority;
                portOffset = colonIndex + 1;
                portLength = authority.length - colonIndex - 1;
            }
            return HttpUtil.regionMatches(pathData, pathOffset + prefixLength + colonIndex, pathLength - prefixLength - colonIndex, port, portOffset, portLength);
        }
        return colonIndex == authority.length || colonIndex == authority.length - defaultPort.length - 1 && Arrays.equals(authority, authority.length - defaultPort.length, authority.length, defaultPort, 0, defaultPort.length);
    }

    private static boolean regionMatches(ByteBuf data, int offset, int dataLength, byte[] bytes, int bs, int length) {
        if (dataLength < length) {
            return false;
        }
        assert (bytes.length >= bs + length);
        for (int i = 0; i < length; ++i) {
            if (data.getByte(offset + i) == bytes[bs + i]) continue;
            return false;
        }
        return true;
    }

    static int indexOf(byte[] bytes, byte b) {
        for (int i = 0; i <= bytes.length; ++i) {
            if (bytes[i] != b) continue;
            return i;
        }
        return bytes.length;
    }

    public static int indexOf(ByteBuf data, int offset, int length, char c) {
        for (int i = 0; i <= length; ++i) {
            if (data.getByte(offset + i) != c) continue;
            return i;
        }
        return length;
    }
}

