/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http;

import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UserAgentAppender
implements SerializableBiConsumer<Session, HttpRequestWriter>,
ResourceUtilizer,
Session.ResourceKey<SessionId> {
    private static final String HOSTNAME;

    @Override
    public void accept(Session session, HttpRequestWriter httpRequestWriter) {
        httpRequestWriter.putHeader((CharSequence)HttpHeaderNames.USER_AGENT, (CharSequence)session.getResource(this).id);
    }

    @Override
    public void reserve(Session session) {
        SessionId sessionId = new SessionId(new AsciiString((CharSequence)("#" + session.uniqueId() + "@" + HOSTNAME)));
        session.declareResource(this, () -> sessionId);
    }

    static {
        String hostname;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostname = "unknown";
        }
        HOSTNAME = hostname;
    }

    public static final class SessionId
    implements Session.Resource {
        public final AsciiString id;

        public SessionId(AsciiString id) {
            this.id = id;
        }
    }
}

