/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.api;

import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.api.CacheControl;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class HttpRequest
extends Request {
    public static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    public HttpResponseHandlers handlers;
    public HttpMethod method;
    public String authority;
    public String path;
    public CacheControl cacheControl = new CacheControl();

    public HttpRequest(Session session) {
        super(session);
    }

    public void start(HttpResponseHandlers handlers, SequenceInstance sequence, Statistics statistics) {
        this.handlers = handlers;
        this.start(sequence, statistics);
    }

    @Override
    public HttpConnection connection() {
        return (HttpConnection)super.connection();
    }

    @Override
    public void setCompleted() {
        super.setCompleted();
        this.handlers = null;
        this.method = null;
        this.authority = null;
        this.path = null;
        this.cacheControl.reset();
    }

    public HttpResponseHandlers handlers() {
        return this.handlers;
    }

    @Override
    protected void handleThrowable(Throwable throwable) {
        this.enter();
        try {
            this.handlers.handleThrowable(this, throwable);
        }
        finally {
            this.exit();
        }
        this.session.proceed();
    }

    public String toString() {
        return "(" + this.status() + ") " + this.method + " " + this.authority + this.path;
    }

    @Override
    public void release() {
        if (this.status() != Request.Status.IDLE) {
            HttpRequestPool.get(this.session).release(this);
            this.setIdle();
        }
    }

    public void handleCached() {
        this.statistics().addCacheHit(this.startTimestampMillis());
        this.enter();
        try {
            this.handlers.handleEnd(this, false);
        }
        catch (SessionStopException sessionStopException) {
        }
        finally {
            this.exit();
            this.release();
        }
        this.session.proceed();
    }

    public void cancel(Throwable cause) {
        if (this.isRunning()) {
            this.enter();
            try {
                this.handlers.handleThrowable(this, cause);
            }
            catch (SessionStopException sessionStopException) {
            }
            catch (Exception e) {
                log.error((Object)"{} {} threw an exception when cancelling", (Throwable)e, new Object[]{this.session.uniqueId(), this});
            }
            finally {
                this.exit();
                this.release();
            }
            this.session.proceed();
        }
    }
}

