/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.http.api.HttpVersion;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class HttpBuilder
implements Rewritable<HttpBuilder> {
    private final HttpPluginBuilder parent;
    private Http http;
    private Protocol protocol;
    private String host;
    private int port = -1;
    private List<String> addresses = new ArrayList<String>();
    private boolean allowHttp1x = true;
    private boolean allowHttp2 = true;
    private int sharedConnections = 1;
    private int maxHttp2Streams = 100;
    private int pipeliningLimit = 1;
    private boolean directHttp2 = false;
    private long requestTimeout = 30000L;
    private boolean rawBytesHandlers = true;
    private KeyManagerBuilder keyManager = new KeyManagerBuilder();
    private TrustManagerBuilder trustManager = new TrustManagerBuilder();
    private boolean privatePools = false;

    public static HttpBuilder forTesting() {
        return new HttpBuilder(null);
    }

    HttpBuilder(HttpPluginBuilder parent) {
        this.parent = parent;
    }

    String authority() {
        if (this.host == null) {
            return null;
        }
        if (this.protocol != null) {
            return this.host + ":" + this.protocol.portOrDefault(this.port);
        }
        return this.host + ":" + Protocol.fromPort(this.port).portOrDefault(this.port);
    }

    public HttpBuilder protocol(Protocol protocol) {
        if (this.protocol != null) {
            throw new BenchmarkDefinitionException("Duplicate 'protocol'");
        }
        this.protocol = protocol;
        return this;
    }

    public String host() {
        return this.host;
    }

    public HttpBuilder host(String host) {
        URL result;
        if (this.host != null) {
            throw new BenchmarkDefinitionException("Duplicate 'host'. Are you missing '-'s?");
        }
        Object spec = host;
        if (!((String)spec).contains("://")) {
            spec = "http://" + (String)spec;
        }
        try {
            result = new URL((String)spec);
        }
        catch (MalformedURLException e) {
            throw new BenchmarkDefinitionException("Failed to parse host:port", e);
        }
        URL url = result;
        this.protocol = this.protocol == null ? Protocol.fromScheme(url.getProtocol()) : this.protocol;
        this.host = url.getHost();
        this.port = url.getPort();
        if (url.getFile() != null && !url.getFile().isEmpty()) {
            throw new BenchmarkDefinitionException("Host must not contain any path: " + host);
        }
        return this;
    }

    public HttpBuilder port(int port) {
        if (this.port > 0) {
            throw new BenchmarkDefinitionException("Duplicate 'port'");
        }
        this.port = port;
        return this;
    }

    public HttpBuilder allowHttp1x(boolean allowHttp1x) {
        this.allowHttp1x = allowHttp1x;
        return this;
    }

    public HttpBuilder allowHttp2(boolean allowHttp2) {
        this.allowHttp2 = allowHttp2;
        return this;
    }

    public HttpPluginBuilder endHttp() {
        return this.parent;
    }

    public HttpBuilder sharedConnections(int sharedConnections) {
        this.sharedConnections = sharedConnections;
        return this;
    }

    public HttpBuilder maxHttp2Streams(int maxStreams) {
        this.maxHttp2Streams = maxStreams;
        return this;
    }

    public HttpBuilder pipeliningLimit(int limit) {
        this.pipeliningLimit = limit;
        return this;
    }

    public HttpBuilder directHttp2(boolean directHttp2) {
        this.directHttp2 = directHttp2;
        return this;
    }

    public HttpBuilder requestTimeout(long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public HttpBuilder requestTimeout(String requestTimeout) {
        this.requestTimeout = "none".equals(requestTimeout) ? -1L : Util.parseToMillis(requestTimeout);
        return this;
    }

    public long requestTimeout() {
        return this.requestTimeout;
    }

    public HttpBuilder addAddress(String address) {
        this.addresses.add(address);
        return this;
    }

    public HttpBuilder rawBytesHandlers(boolean rawBytesHandlers) {
        this.rawBytesHandlers = rawBytesHandlers;
        return this;
    }

    public KeyManagerBuilder keyManager() {
        return this.keyManager;
    }

    public TrustManagerBuilder trustManager() {
        return this.trustManager;
    }

    public HttpBuilder privatePools(boolean privatePools) {
        this.privatePools = privatePools;
        return this;
    }

    public void prepareBuild() {
    }

    public Http build(boolean isDefault) {
        if (this.http != null) {
            if (isDefault != this.http.isDefault()) {
                throw new IllegalArgumentException("Already built as isDefault=" + this.http.isDefault());
            }
            return this.http;
        }
        ArrayList<HttpVersion> httpVersions = new ArrayList<HttpVersion>();
        if (this.allowHttp2) {
            httpVersions.add(HttpVersion.HTTP_2_0);
        }
        if (this.allowHttp1x) {
            httpVersions.add(HttpVersion.HTTP_1_1);
            httpVersions.add(HttpVersion.HTTP_1_0);
        }
        if (this.directHttp2) {
            throw new UnsupportedOperationException("Direct HTTP/2 not implemented");
        }
        Protocol protocol = this.protocol != null ? this.protocol : Protocol.fromPort(this.port);
        this.http = new Http(isDefault, protocol, this.host, protocol.portOrDefault(this.port), this.addresses.toArray(new String[0]), httpVersions.toArray(new HttpVersion[0]), this.maxHttp2Streams, this.pipeliningLimit, this.sharedConnections, this.directHttp2, this.requestTimeout, this.rawBytesHandlers, this.keyManager.build(), this.trustManager.build(), this.privatePools);
        return this.http;
    }

    @Override
    public void readFrom(HttpBuilder other) {
        this.protocol = other.protocol;
        this.host = other.host;
        this.port = other.port;
        this.addresses = new ArrayList<String>(this.addresses);
        this.allowHttp1x = other.allowHttp1x;
        this.allowHttp2 = other.allowHttp2;
        this.sharedConnections = other.sharedConnections;
        this.maxHttp2Streams = other.maxHttp2Streams;
        this.pipeliningLimit = other.pipeliningLimit;
        this.directHttp2 = other.directHttp2;
        this.requestTimeout = other.requestTimeout;
        this.rawBytesHandlers = other.rawBytesHandlers;
        this.keyManager.readFrom(other.keyManager);
        this.trustManager.readFrom(other.trustManager);
    }

    private static byte[] readBytes(String filename) throws IOException {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            if (stream != null) {
                byte[] byArray = Util.toByteArray(stream);
                return byArray;
            }
        }
        return Files.readAllBytes(Paths.get(filename, new String[0]));
    }

    public class TrustManagerBuilder
    implements Rewritable<TrustManagerBuilder> {
        private String storeType = "JKS";
        private byte[] storeBytes;
        private String password;
        private byte[] certBytes;

        public TrustManagerBuilder storeType(String type) {
            this.storeType = type;
            return this;
        }

        public TrustManagerBuilder storeFile(String filename) {
            try {
                this.storeBytes = HttpBuilder.readBytes(filename);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read keystore file " + filename, e);
            }
            return this;
        }

        public TrustManagerBuilder storeBytes(byte[] storeBytes) {
            this.storeBytes = storeBytes;
            return this;
        }

        public TrustManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public TrustManagerBuilder certFile(String certFile) {
            try {
                this.certBytes = HttpBuilder.readBytes(certFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read certificate file " + certFile, e);
            }
            return this;
        }

        public TrustManagerBuilder certBytes(byte[] certBytes) {
            this.certBytes = certBytes;
            return this;
        }

        public HttpBuilder end() {
            return HttpBuilder.this;
        }

        public Http.TrustManager build() {
            return new Http.TrustManager(this.storeType, this.storeBytes, this.password, this.certBytes);
        }

        @Override
        public void readFrom(TrustManagerBuilder other) {
            this.storeType = other.storeType;
            this.storeBytes = other.storeBytes;
            this.password = other.password;
            this.certBytes = other.certBytes;
        }
    }

    public class KeyManagerBuilder
    implements Rewritable<KeyManagerBuilder> {
        private String storeType = "JKS";
        private byte[] storeBytes;
        private String password;
        private String alias;
        private byte[] certBytes;
        private byte[] keyBytes;

        public KeyManagerBuilder storeType(String type) {
            this.storeType = type;
            return this;
        }

        public KeyManagerBuilder storeFile(String filename) {
            try {
                this.storeBytes = HttpBuilder.readBytes(filename);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read key store file " + filename, e);
            }
            return this;
        }

        public KeyManagerBuilder storeBytes(byte[] storeBytes) {
            this.storeBytes = storeBytes;
            return this;
        }

        public KeyManagerBuilder password(String password) {
            this.password = password;
            return this;
        }

        public KeyManagerBuilder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public KeyManagerBuilder certFile(String certFile) {
            try {
                this.certBytes = HttpBuilder.readBytes(certFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read certificate file " + certFile, e);
            }
            return this;
        }

        public KeyManagerBuilder certBytes(byte[] certBytes) {
            this.certBytes = certBytes;
            return this;
        }

        public KeyManagerBuilder keyFile(String keyFile) {
            try {
                this.keyBytes = HttpBuilder.readBytes(keyFile);
            }
            catch (IOException e) {
                throw new BenchmarkDefinitionException("Cannot read private key file " + keyFile, e);
            }
            return this;
        }

        public KeyManagerBuilder keyBytes(byte[] keyBytes) {
            this.keyBytes = keyBytes;
            return this;
        }

        public HttpBuilder end() {
            return HttpBuilder.this;
        }

        public Http.KeyManager build() {
            return new Http.KeyManager(this.storeType, this.storeBytes, this.password, this.alias, this.certBytes, this.keyBytes);
        }

        @Override
        public void readFrom(KeyManagerBuilder other) {
            this.storeType = other.storeType;
            this.storeBytes = other.storeBytes;
            this.password = other.password;
            this.alias = other.alias;
            this.certBytes = other.certBytes;
            this.keyBytes = other.keyBytes;
        }
    }
}

