/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.config;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.PluginBuilder;
import io.hyperfoil.api.config.PluginConfig;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HttpPluginBuilder
extends PluginBuilder<HttpErgonomics> {
    private HttpBuilder defaultHttp;
    private List<HttpBuilder> httpList = new ArrayList<HttpBuilder>();
    private HttpErgonomics ergonomics = new HttpErgonomics(this);

    public HttpPluginBuilder(BenchmarkBuilder parent) {
        super(parent);
    }

    public static Collection<HttpBuilder> httpForTesting(BenchmarkBuilder benchmarkBuilder) {
        HttpPluginBuilder builder = benchmarkBuilder.plugin(HttpPluginBuilder.class);
        if (builder.defaultHttp == null) {
            return Collections.unmodifiableList(builder.httpList);
        }
        if (builder.httpList.isEmpty()) {
            return Collections.singletonList(builder.defaultHttp);
        }
        ArrayList<HttpBuilder> list = new ArrayList<HttpBuilder>(builder.httpList);
        list.add(builder.defaultHttp);
        return list;
    }

    public HttpBuilder http() {
        if (this.defaultHttp == null) {
            this.defaultHttp = new HttpBuilder(this);
        }
        return this.defaultHttp;
    }

    public HttpBuilder http(String host) {
        HttpBuilder builder = new HttpBuilder(this).host(host);
        this.httpList.add(builder);
        return builder;
    }

    @Override
    public HttpErgonomics ergonomics() {
        return this.ergonomics;
    }

    @Override
    public void prepareBuild() {
        if (this.defaultHttp == null) {
            if (this.httpList.isEmpty()) {
                throw new BenchmarkDefinitionException("No default HTTP target set!");
            }
            if (this.httpList.size() == 1) {
                this.defaultHttp = this.httpList.iterator().next();
            }
        } else {
            if (this.httpList.stream().anyMatch(http -> http.authority().equals(this.defaultHttp.authority()))) {
                throw new BenchmarkDefinitionException("Ambiguous HTTP definition for " + this.defaultHttp.authority() + ": defined both as default and non-default");
            }
            this.httpList.add(this.defaultHttp);
        }
        HashSet<String> authorities = new HashSet<String>();
        for (HttpBuilder http2 : this.httpList) {
            if (authorities.add(http2.authority())) continue;
            throw new BenchmarkDefinitionException("Duplicit HTTP definition for " + http2.authority());
        }
        this.httpList.forEach(HttpBuilder::prepareBuild);
    }

    @Override
    public void addTags(Map<String, Object> tags) {
        if (this.defaultHttp != null) {
            Http defaultHttp = this.defaultHttp.build(true);
            tags.put("url", defaultHttp.protocol().scheme + "://" + defaultHttp.host() + ":" + defaultHttp.port());
            tags.put("protocol", defaultHttp.protocol().scheme);
        }
    }

    @Override
    public PluginConfig build() {
        Map<String, Http> httpMap = this.httpList.stream().collect(Collectors.toMap(HttpBuilder::authority, http -> http.build(http == this.defaultHttp)));
        return new HttpPluginConfig(httpMap);
    }

    public boolean validateAuthority(String authority) {
        return authority == null && this.defaultHttp != null || this.httpList.stream().anyMatch(http -> http.authority().equals(authority));
    }

    public HttpBuilder decoupledHttp() {
        return new HttpBuilder(this);
    }

    public void addHttp(HttpBuilder builder) {
        if (builder.authority() == null) {
            throw new BenchmarkDefinitionException("Missing hostname!");
        }
        this.httpList.add(builder);
    }
}

