/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.connection.Http2Connection;
import io.hyperfoil.http.connection.Http2RawResponseHandler;
import io.hyperfoil.http.connection.RawRequestHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.internal.StringUtil;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.util.function.BiConsumer;

class CustomHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomHttp2ConnectionHandler.class);
    private final BiConsumer<HttpConnection, Throwable> activationHandler;
    private final HttpClientPool clientPool;
    private final boolean isUpgrade;
    private Http2Connection connection;

    CustomHttp2ConnectionHandler(HttpClientPool clientPool, BiConsumer<HttpConnection, Throwable> activationHandler, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean isUpgrade) {
        super(decoder, encoder, initialSettings);
        this.clientPool = clientPool;
        this.activationHandler = activationHandler;
        this.isUpgrade = isUpgrade;
    }

    private static String generateName(Class<? extends ChannelHandler> handlerType) {
        return StringUtil.simpleClassName(handlerType) + "#0";
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        if (ctx.channel().isActive() && !this.isUpgrade) {
            this.checkActivated(ctx);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
            this.checkActivated(ctx);
        } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
            this.activationHandler.accept(null, new IOException("H2C upgrade was rejected by server."));
        }
        super.userEventTriggered(ctx, evt);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.checkActivated(ctx);
    }

    private void checkActivated(ChannelHandlerContext ctx) {
        if (this.connection == null) {
            this.connection = new Http2Connection(ctx, this.connection(), this.encoder(), this.decoder(), this.clientPool);
            this.connection.incrementConnectionWindowSize(1073610753);
            if (this.clientPool.config().rawBytesHandlers()) {
                String customeHandlerName = CustomHttp2ConnectionHandler.generateName(CustomHttp2ConnectionHandler.class);
                ctx.pipeline().addBefore(customeHandlerName, null, (ChannelHandler)new Http2RawResponseHandler(this.connection));
                ctx.pipeline().addBefore(customeHandlerName, null, (ChannelHandler)new RawRequestHandler(this.connection));
            }
            this.activationHandler.accept(this.connection, null);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (cause != SessionStopException.INSTANCE) {
            log.warn((Object)"Exception in {}", cause, new Object[]{this});
        }
        try {
            if (Http2CodecUtil.getEmbeddedHttp2Exception((Throwable)cause) != null) {
                this.onError(ctx, false, cause);
            } else {
                if (this.connection != null) {
                    this.connection.cancelRequests(cause);
                }
                ctx.close();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Handling exception resulted in another exception", t);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.connection.cancelRequests(Connection.CLOSED_EXCEPTION);
    }
}

