/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.HttpVersion;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.AppendableCharSequence;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

class Http2Connection
extends Http2EventAdapter
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http2Connection.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ChannelHandlerContext context;
    private final io.netty.handler.codec.http2.Http2Connection connection;
    private final Http2ConnectionEncoder encoder;
    private final IntObjectMap<HttpRequest> streams = new IntObjectHashMap();
    private final long clientMaxStreams;
    private final boolean secure;
    private HttpConnectionPool pool;
    private int numStreams;
    private long maxStreams;
    private HttpConnection.Status status = HttpConnection.Status.OPEN;
    private HttpRequest dispatchedRequest;

    Http2Connection(ChannelHandlerContext context, io.netty.handler.codec.http2.Http2Connection connection, Http2ConnectionEncoder encoder, Http2ConnectionDecoder decoder, HttpClientPool clientPool) {
        this.context = context;
        this.connection = connection;
        this.encoder = encoder;
        this.clientMaxStreams = this.maxStreams = (long)clientPool.config().maxHttp2Streams();
        this.secure = clientPool.isSecure();
        EventAdapter listener = new EventAdapter();
        connection.addListener((Http2Connection.Listener)listener);
        decoder.frameListener((Http2FrameListener)listener);
    }

    @Override
    public ChannelHandlerContext context() {
        return this.context;
    }

    @Override
    public boolean isAvailable() {
        return (long)this.numStreams < this.maxStreams;
    }

    @Override
    public int inFlight() {
        return this.numStreams;
    }

    public void incrementConnectionWindowSize(int increment) {
        try {
            Http2Stream stream = this.connection.connectionStream();
            ((Http2LocalFlowController)this.connection.local().flowController()).incrementWindowSize(stream, increment);
        }
        catch (Http2Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void close() {
        if (this.status == HttpConnection.Status.OPEN) {
            this.status = HttpConnection.Status.CLOSING;
            this.cancelRequests(Connection.SELF_CLOSED_EXCEPTION);
        }
        this.context.close();
    }

    @Override
    public String host() {
        return this.pool.clientPool().host();
    }

    @Override
    public void onTimeout(Request request) {
        for (IntObjectMap.PrimitiveEntry entry : this.streams.entries()) {
            if (entry.value() != request) continue;
            this.connection.stream(entry.key()).close();
            break;
        }
    }

    @Override
    public void attach(HttpConnectionPool pool) {
        this.pool = pool;
    }

    @Override
    public void request(HttpRequest request, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator) {
        ByteBuf buf;
        ++this.numStreams;
        HttpClientPool httpClientPool = this.pool.clientPool();
        ByteBuf byteBuf = buf = bodyGenerator != null ? bodyGenerator.apply(request.session, this) : null;
        if (request.path.contains(" ")) {
            int length = request.path.length();
            AppendableCharSequence temp = new AppendableCharSequence(length);
            boolean beforeQuestion = true;
            for (int i = 0; i < length; ++i) {
                if (request.path.charAt(i) == ' ') {
                    if (beforeQuestion) {
                        temp.append('%');
                        temp.append('2');
                        temp.append('0');
                        continue;
                    }
                    temp.append('+');
                    continue;
                }
                if (request.path.charAt(i) == '?') {
                    beforeQuestion = false;
                }
                temp.append(request.path.charAt(i));
            }
            request.path = temp.toString();
        }
        Http2Headers headers = new DefaultHttp2Headers().method((CharSequence)request.method.name()).scheme((CharSequence)httpClientPool.scheme()).path((CharSequence)request.path).authority((CharSequence)httpClientPool.authority());
        if (injectHostHeader && !this.pool.clientPool().config().protocol().secure()) {
            headers.add((Object)HttpHeaderNames.HOST, (Object)httpClientPool.authority());
        }
        if (buf != null && buf.readableBytes() > 0) {
            headers.add((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(buf.readableBytes()));
        }
        HttpRequestWriterImpl writer = new HttpRequestWriterImpl(request, headers);
        if (headerAppenders != null) {
            for (BiConsumer<Session, HttpRequestWriter> headerAppender : headerAppenders) {
                headerAppender.accept(request.session, writer);
            }
        }
        if (HttpCache.get(request.session).isCached(request, writer)) {
            if (trace) {
                log.trace((Object)"#{} Request is completed from cache", new Object[]{request.session.uniqueId()});
            }
            --this.numStreams;
            request.handleCached();
            this.tryReleaseToPool();
            return;
        }
        assert (this.context.executor().inEventLoop());
        int id = this.nextStreamId();
        this.streams.put(id, (Object)request);
        this.dispatchedRequest = request;
        ChannelPromise writePromise = this.context.newPromise();
        this.encoder.writeHeaders(this.context, id, headers, 0, buf == null, writePromise);
        if (buf != null) {
            writePromise = this.context.newPromise();
            this.encoder.writeData(this.context, id, buf, 0, true, writePromise);
        }
        writePromise.addListener((GenericFutureListener)request);
        this.context.flush();
        this.dispatchedRequest = null;
    }

    @Override
    public HttpRequest dispatchedRequest() {
        return this.dispatchedRequest;
    }

    @Override
    public HttpRequest peekRequest(int streamId) {
        return (HttpRequest)this.streams.get(streamId);
    }

    @Override
    public void removeRequest(int streamId, HttpRequest request) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClosed() {
        this.status = HttpConnection.Status.CLOSED;
    }

    @Override
    public boolean isClosed() {
        return this.status == HttpConnection.Status.CLOSED;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2_0;
    }

    private int nextStreamId() {
        return this.connection.local().incrementAndGetNextStreamId();
    }

    public String toString() {
        return "Http2Connection{" + this.context.channel().localAddress() + " -> " + this.context.channel().remoteAddress() + ", streams=" + this.streams + "}";
    }

    void cancelRequests(Throwable cause) {
        for (IntObjectMap.PrimitiveEntry entry : this.streams.entries()) {
            HttpRequest request = (HttpRequest)entry.value();
            request.cancel(cause);
        }
        this.streams.clear();
    }

    private void tryReleaseToPool() {
        HttpConnectionPool pool = this.pool;
        if (pool != null) {
            if ((long)this.numStreams == this.maxStreams - 1L) {
                pool.release(this);
                this.pool = null;
            }
            pool.pulse();
        }
    }

    private class HttpRequestWriterImpl
    implements HttpRequestWriter {
        private final HttpRequest request;
        private final Http2Headers headers;

        HttpRequestWriterImpl(HttpRequest request, Http2Headers headers) {
            this.request = request;
            this.headers = headers;
        }

        @Override
        public HttpConnection connection() {
            return Http2Connection.this;
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public void putHeader(CharSequence header, CharSequence value) {
            this.headers.add((Object)header, (Object)value);
            HttpCache.get(this.request.session).requestHeader(this.request, header, value);
        }
    }

    private class EventAdapter
    extends Http2EventAdapter {
        private EventAdapter() {
        }

        public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
            if (settings.maxConcurrentStreams() != null) {
                Http2Connection.this.maxStreams = Math.min(Http2Connection.this.clientMaxStreams, settings.maxConcurrentStreams());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) {
            HttpRequest request = (HttpRequest)Http2Connection.this.streams.get(streamId);
            if (request != null && !request.isCompleted()) {
                HttpResponseHandlers handlers = request.handlers();
                int code = -1;
                try {
                    code = Integer.parseInt(headers.status().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                request.enter();
                try {
                    handlers.handleStatus(request, code, "");
                    for (Map.Entry header : headers) {
                        handlers.handleHeader(request, (CharSequence)header.getKey(), (CharSequence)header.getValue());
                    }
                    if (endStream) {
                        handlers.handleBodyPart(request, Unpooled.EMPTY_BUFFER, 0, 0, true);
                    }
                }
                finally {
                    request.exit();
                }
                request.session.proceed();
            }
            if (endStream) {
                this.endStream(streamId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
            int ack = super.onDataRead(ctx, streamId, data, padding, endOfStream);
            HttpRequest request = (HttpRequest)Http2Connection.this.streams.get(streamId);
            if (request != null && !request.isCompleted()) {
                HttpResponseHandlers handlers = request.handlers();
                request.enter();
                try {
                    handlers.handleBodyPart(request, data, data.readerIndex(), data.readableBytes(), endOfStream);
                }
                finally {
                    request.exit();
                }
                request.session.proceed();
            }
            if (endOfStream) {
                this.endStream(streamId);
            }
            return ack;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) {
            HttpRequest request = (HttpRequest)Http2Connection.this.streams.remove(streamId);
            if (request != null) {
                --Http2Connection.this.numStreams;
                HttpResponseHandlers handlers = request.handlers();
                if (!request.isCompleted()) {
                    request.enter();
                    try {
                        handlers.handleThrowable(request, new IOException("HTTP2 stream was reset"));
                    }
                    finally {
                        request.exit();
                    }
                    request.session.proceed();
                }
                request.release();
                Http2Connection.this.tryReleaseToPool();
            }
        }

        private void endStream(int streamId) {
            HttpRequest request = (HttpRequest)Http2Connection.this.streams.remove(streamId);
            if (request != null) {
                --Http2Connection.this.numStreams;
                if (!request.isCompleted()) {
                    request.enter();
                    try {
                        request.handlers().handleEnd(request, true);
                        if (trace) {
                            log.trace((Object)"Completed response on {}", new Object[]{this});
                        }
                    }
                    finally {
                        request.exit();
                    }
                    request.session.proceed();
                }
                request.release();
                Http2Connection.this.tryReleaseToPool();
            }
        }
    }
}

