/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.connection.BaseResponseHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class Http2RawResponseHandler
extends BaseResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(Http2RawResponseHandler.class);
    private int streamId = -1;
    private byte[] frameHeader = new byte[9];
    private int frameHeaderIndex = 0;

    Http2RawResponseHandler(HttpConnection connection) {
        super(connection);
    }

    @Override
    protected boolean isRequestStream(int streamId) {
        return (streamId & 1) == 1 && streamId >= 3;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            if (this.responseBytes <= 0) {
                if (this.frameHeaderIndex > 0) {
                    int maxBytes = Math.min(9 - this.frameHeaderIndex, buf.readableBytes());
                    buf.readBytes(this.frameHeader, this.frameHeaderIndex, maxBytes);
                    this.frameHeaderIndex += maxBytes;
                    if (this.frameHeaderIndex >= 9) {
                        ByteBuf wrapped = Unpooled.wrappedBuffer((byte[])this.frameHeader);
                        this.responseBytes = wrapped.getUnsignedMedium(0);
                        this.streamId = wrapped.getInt(5) & Integer.MAX_VALUE;
                        HttpRequest request = this.connection.peekRequest(this.streamId);
                        this.onRawData(request, wrapped, wrapped.readableBytes() == this.responseBytes);
                        ctx.fireChannelRead((Object)wrapped);
                        this.frameHeaderIndex = 0;
                        this.handleBuffer(ctx, buf, this.streamId);
                    }
                } else if (buf.readableBytes() >= 9) {
                    this.responseBytes = 9 + buf.getUnsignedMedium(buf.readerIndex());
                    this.streamId = buf.getInt(buf.readerIndex() + 5) & Integer.MAX_VALUE;
                    this.handleBuffer(ctx, buf, this.streamId);
                } else {
                    this.frameHeaderIndex = buf.readableBytes();
                    buf.readBytes(this.frameHeader, 0, this.frameHeaderIndex);
                    assert (!buf.isReadable());
                    buf.release();
                }
            } else {
                this.handleBuffer(ctx, buf, this.streamId);
            }
        } else {
            log.error((Object)"Unexpected message type: {}", new Object[]{msg});
            super.channelRead(ctx, msg);
        }
    }
}

