/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.connection.HttpClientPoolImpl;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.ScheduledFuture;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

class HttpConnectionPoolImpl
implements HttpConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectionPoolImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int MAX_FAILURES = 100;
    private final HttpClientPoolImpl clientPool;
    private final ArrayList<HttpConnection> connections = new ArrayList();
    private final ArrayDeque<HttpConnection> available;
    private final List<HttpConnection> temporaryInFlight;
    private final int size;
    private final EventLoop eventLoop;
    private int count;
    private int created;
    private int closed;
    private int failures;
    private Handler<AsyncResult<Void>> startedHandler;
    private boolean shutdown;
    private Deque<Session> waitingSessions = new ArrayDeque<Session>();
    private ScheduledFuture<?> pulseFuture;

    HttpConnectionPoolImpl(HttpClientPoolImpl clientPool, EventLoop eventLoop, int size) {
        this.clientPool = clientPool;
        this.size = size;
        this.eventLoop = eventLoop;
        this.available = new ArrayDeque(size);
        this.temporaryInFlight = new ArrayList<HttpConnection>(size);
    }

    @Override
    public HttpClientPool clientPool() {
        return this.clientPool;
    }

    @Override
    public boolean request(HttpRequest request, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator, boolean exclusiveConnection) {
        assert (this.eventLoop.inEventLoop());
        if (request.session.currentRequest() != null) {
            log.error((Object)"#{} Invoking request directly from a request handler; current: {}, requested {}", (Throwable)new IllegalStateException(), new Object[]{request.session.uniqueId(), request.session.currentRequest(), request});
            return false;
        }
        try {
            while (true) {
                HttpConnection connection;
                if ((connection = this.available.pollFirst()) == null) {
                    log.debug((Object)"No connection to {} available", new Object[]{this.clientPool.authority});
                    if (this.failures > 100) {
                        log.error((Object)"The request cannot be made since the failures to connect to {} exceeded a threshold. Stopping session.", new Object[]{this.clientPool.authority});
                        request.session.stop();
                    }
                    boolean bl = false;
                    return bl;
                }
                if (!connection.isClosed()) {
                    if (exclusiveConnection && connection.inFlight() > 0) {
                        this.temporaryInFlight.add(connection);
                        continue;
                    }
                    request.attach(connection);
                    connection.attach(this);
                    connection.request(request, headerAppenders, injectHostHeader, bodyGenerator);
                    if (!exclusiveConnection && connection.isAvailable()) {
                        this.available.addLast(connection);
                    }
                    boolean bl = true;
                    return bl;
                }
                log.trace((Object)"Connection {} to {} is already closed", new Object[]{connection, this.clientPool.authority});
            }
        }
        finally {
            if (!this.temporaryInFlight.isEmpty()) {
                this.available.addAll(this.temporaryInFlight);
                this.temporaryInFlight.clear();
            }
        }
    }

    @Override
    public void release(HttpConnection connection) {
        this.available.add(connection);
    }

    @Override
    public void onSessionReset() {
    }

    @Override
    public void registerWaitingSession(Session session) {
        this.waitingSessions.add(session);
    }

    @Override
    public int waitingSessions() {
        return this.waitingSessions.size();
    }

    @Override
    public EventLoop executor() {
        return this.eventLoop;
    }

    @Override
    public void pulse() {
        Session session = this.waitingSessions.poll();
        if (trace) {
            log.trace((Object)"Pulse #{} to {} ({} waiting)", new Object[]{session == null ? "<none>" : Integer.valueOf(session.uniqueId()), this.clientPool.authority, this.waitingSessions.size()});
        }
        if (session != null) {
            session.proceed();
        }
        if (this.pulseFuture == null && !this.waitingSessions.isEmpty()) {
            this.pulseFuture = this.executor().schedule(this::scheduledPulse, 1L, TimeUnit.MILLISECONDS);
        }
    }

    private Object scheduledPulse() {
        this.pulseFuture = null;
        this.pulse();
        return null;
    }

    public Collection<HttpConnection> connections() {
        return this.connections;
    }

    private void checkCreateConnections() {
        assert (this.eventLoop.inEventLoop());
        if (this.shutdown) {
            return;
        }
        if (this.failures > 100) {
            Handler<AsyncResult<Void>> handler = this.startedHandler;
            if (handler != null) {
                this.startedHandler = null;
                Object failureMessage = String.format("Cannot connect to %s: %d created, %d failures.", this.clientPool.authority, this.created, this.failures);
                if (this.created > 0) {
                    failureMessage = (String)failureMessage + " Hint: either configure SUT to accept more open connections or reduce http.sharedConnections.";
                }
                handler.handle((Object)Future.failedFuture((String)failureMessage));
            }
            this.pulse();
            return;
        }
        if (this.count < this.size) {
            ++this.count;
            this.clientPool.connect(this, (conn, err) -> {
                if (err != null) {
                    --this.count;
                    ++this.failures;
                    if (!this.eventLoop.isShuttingDown() && !this.eventLoop.isShutdown()) {
                        log.warn((Object)"Cannot create connection to {} (created: {}, failures: {})", err, new Object[]{this.clientPool.authority, this.created, this.failures});
                        this.eventLoop.execute(this::checkCreateConnections);
                    }
                } else {
                    assert (conn.context().executor() == this.eventLoop);
                    assert (this.eventLoop.inEventLoop());
                    Handler<AsyncResult<Void>> handler = null;
                    this.connections.add((HttpConnection)conn);
                    ++this.created;
                    this.failures = 0;
                    this.available.add((HttpConnection)conn);
                    log.debug((Object)"Connection {} to {} created ({}->{}=?{}:{}/{})", new Object[]{conn, this.clientPool.authority, this.count, this.created, this.connections.size(), this.available.size(), this.size});
                    if (this.count < this.size) {
                        this.checkCreateConnections();
                    } else if (this.created == this.size) {
                        handler = this.startedHandler;
                        this.startedHandler = null;
                    }
                    conn.context().channel().closeFuture().addListener(v -> {
                        conn.setClosed();
                        log.debug((Object)"Connection {} to {} closed. ({}->{}=?{}:{}/{})", new Object[]{conn, this.clientPool.authority, this.count, this.created, this.connections.size(), this.available.size(), this.size});
                        --this.count;
                        --this.created;
                        ++this.closed;
                        if (!this.shutdown) {
                            if (this.closed > this.size) {
                                this.connections.removeIf(Connection::isClosed);
                                this.closed = 0;
                            }
                            this.checkCreateConnections();
                        }
                    });
                    if (handler != null) {
                        handler.handle((Object)Future.succeededFuture());
                    }
                    this.pulse();
                }
            });
            this.eventLoop.schedule(() -> this.checkCreateConnections(), 2L, TimeUnit.MILLISECONDS);
        }
    }

    void start(Handler<AsyncResult<Void>> handler) {
        this.startedHandler = handler;
        this.eventLoop.execute(() -> this.checkCreateConnections());
    }

    void shutdown() {
        log.debug((Object)"Shutdown called");
        this.shutdown = true;
        if (this.eventLoop.isShutdown()) {
            return;
        }
        this.eventLoop.execute(() -> {
            log.debug((Object)"Closing all connections");
            for (HttpConnection conn : this.connections) {
                if (conn.isClosed()) continue;
                conn.context().writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
                conn.context().close();
                conn.context().flush();
            }
        });
    }
}

