/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;

public class HttpDestinationTableImpl
implements HttpDestinationTable {
    private final Map<String, HttpConnectionPool> pools;
    private final String[] authorities;
    private final byte[][] authorityBytes;

    public HttpDestinationTableImpl(Map<String, HttpConnectionPool> pools) {
        this.pools = pools;
        this.authorities = (String[])pools.keySet().stream().filter(Objects::nonNull).toArray(String[]::new);
        this.authorityBytes = (byte[][])Stream.of(this.authorities).map(url -> url.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
    }

    public HttpDestinationTableImpl(HttpDestinationTable other, Function<HttpConnectionPool, HttpConnectionPool> replacePool) {
        this.authorities = other.authorities();
        this.authorityBytes = other.authorityBytes();
        this.pools = new HashMap<String, HttpConnectionPool>();
        HttpConnectionPool defaultPool = other.getConnectionPool(null);
        for (String authority : this.authorities) {
            HttpConnectionPool pool = other.getConnectionPool(authority);
            HttpConnectionPool newPool = replacePool.apply(pool);
            this.pools.put(authority, newPool);
            if (pool != defaultPool) continue;
            this.pools.put(null, newPool);
        }
    }

    @Override
    public String[] authorities() {
        return this.authorities;
    }

    @Override
    public byte[][] authorityBytes() {
        return this.authorityBytes;
    }

    @Override
    public void onSessionReset(Session session) {
        this.pools.values().forEach(HttpConnectionPool::onSessionReset);
    }

    @Override
    public boolean hasSingleDestination() {
        return this.authorities.length == 1;
    }

    @Override
    public HttpConnectionPool getConnectionPool(String authority) {
        return this.pools.get(authority);
    }

    public Iterable<Map.Entry<String, HttpConnectionPool>> iterable() {
        return this.pools.entrySet();
    }
}

