/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HttpClientPool;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoop;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class PrivateConnectionPool
implements HttpConnectionPool {
    private final HttpConnectionPool parent;
    private final ArrayDeque<HttpConnection> available = new ArrayDeque();

    public PrivateConnectionPool(HttpConnectionPool parent) {
        this.parent = parent;
    }

    @Override
    public HttpClientPool clientPool() {
        return this.parent.clientPool();
    }

    @Override
    public boolean request(HttpRequest request, BiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, BiFunction<Session, Connection, ByteBuf> bodyGenerator, boolean reserveConnection) {
        HttpConnection connection;
        assert (!reserveConnection);
        do {
            if ((connection = this.available.pollFirst()) != null) continue;
            boolean success = this.parent.request(request, headerAppenders, injectHostHeader, bodyGenerator, true);
            if (success) {
                request.connection().attach(this);
            }
            return success;
        } while (connection.isClosed());
        request.attach(connection);
        connection.attach(this);
        connection.request(request, headerAppenders, injectHostHeader, bodyGenerator);
        if (connection.isAvailable()) {
            this.available.addLast(connection);
        }
        return true;
    }

    @Override
    public void registerWaitingSession(Session session) {
        this.parent.registerWaitingSession(session);
    }

    @Override
    public int waitingSessions() {
        return this.parent.waitingSessions();
    }

    @Override
    public EventLoop executor() {
        return this.parent.executor();
    }

    @Override
    public void pulse() {
        this.parent.pulse();
    }

    @Override
    public Collection<? extends HttpConnection> connections() {
        return this.available;
    }

    @Override
    public void release(HttpConnection connection) {
        this.available.addLast(connection);
    }

    @Override
    public void onSessionReset() {
        HttpConnection connection;
        while ((connection = this.available.pollFirst()) != null) {
            this.parent.release(connection);
        }
    }
}

