/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.connection;

import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class RawRequestHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(RawRequestHandler.class);
    private final HttpConnection connection;

    public RawRequestHandler(HttpConnection connection) {
        this.connection = connection;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            HttpRequest request = this.connection.dispatchedRequest();
            if (request != null && request.handlers != null) {
                int readerIndex = buf.readerIndex();
                request.handlers.handleRawRequest(request, buf, readerIndex, buf.readableBytes());
                if (readerIndex != buf.readerIndex()) {
                    throw new IllegalStateException("Handler has changed readerIndex on the buffer!");
                }
            }
        } else {
            log.warn((Object)"Unknown message being sent: {}", new Object[]{msg});
        }
        ctx.write(msg, promise);
    }
}

