/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseDelegatingHeaderHandler
implements HeaderHandler,
ResourceUtilizer {
    protected final HeaderHandler[] handlers;

    public BaseDelegatingHeaderHandler(HeaderHandler[] handlers) {
        this.handlers = handlers;
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.handlers);
    }

    @Override
    public void beforeHeaders(HttpRequest request) {
        for (HeaderHandler h : this.handlers) {
            h.beforeHeaders(request);
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        for (HeaderHandler h : this.handlers) {
            h.handleHeader(request, header, value);
        }
    }

    @Override
    public void afterHeaders(HttpRequest request) {
        for (HeaderHandler h : this.handlers) {
            h.afterHeaders(request);
        }
    }

    public static abstract class Builder<S extends Builder<S>>
    implements HeaderHandler.Builder {
        protected final List<HeaderHandler.Builder> handlers = new ArrayList<HeaderHandler.Builder>();

        protected S self() {
            return (S)this;
        }

        public S handler(HeaderHandler.Builder handler) {
            this.handlers.add(handler);
            return this.self();
        }

        public S handlers(Collection<? extends HeaderHandler.Builder> handlers) {
            this.handlers.addAll(handlers);
            return this.self();
        }

        public ServiceLoadedBuilderProvider<HeaderHandler.Builder> handler() {
            return new ServiceLoadedBuilderProvider<HeaderHandler.Builder>(HeaderHandler.Builder.class, this::handler);
        }

        protected HeaderHandler[] buildHandlers() {
            return (HeaderHandler[])this.handlers.stream().map(HeaderHandler.Builder::build).toArray(HeaderHandler[]::new);
        }
    }
}

