/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;

public abstract class BaseRangeStatusHandler
implements StatusHandler {
    protected final int[] statusRanges;

    public BaseRangeStatusHandler(int[] statusRanges) {
        this.statusRanges = statusRanges;
    }

    @Override
    public void handleStatus(HttpRequest request, int status) {
        int i = 0;
        while (2 * i < this.statusRanges.length) {
            if (status >= this.statusRanges[2 * i] && status <= this.statusRanges[2 * i + 1]) {
                this.onStatusRange(request, status, i);
                return;
            }
            ++i;
        }
        this.onOtherStatus(request, status);
    }

    protected abstract void onStatusRange(HttpRequest var1, int var2, int var3);

    protected abstract void onOtherStatus(HttpRequest var1, int var2);

    protected static <S, T> T checkAndSortRanges(Map<String, S> map, List<Integer> ranges, List<T> values, Function<S, T> func) {
        T other = null;
        TreeMap<Integer, T> byLow = new TreeMap<Integer, T>();
        HashMap<Integer, Integer> toHigh = new HashMap<Integer, Integer>();
        for (Map.Entry<String, S> entry : map.entrySet()) {
            if (entry.getKey().equals("other")) {
                other = func.apply(entry.getValue());
                continue;
            }
            for (String part : entry.getKey().split(",")) {
                part = part.trim();
                try {
                    int high;
                    int low;
                    if (part.contains("-")) {
                        int di = part.indexOf(45);
                        low = Integer.parseInt(part.substring(0, di).trim());
                        high = Integer.parseInt(part.substring(di + 1).trim());
                    } else {
                        int xn = 0;
                        for (int i = part.length() - 1; i >= 0 && part.charAt(i) == 'x'; --i) {
                            ++xn;
                        }
                        int value = Integer.parseInt(part.substring(0, part.length() - xn));
                        int mul = Util.pow(10, xn);
                        low = value * mul;
                        high = (value + 1) * mul - 1;
                    }
                    if (low > high || low < 100 || high > 599) {
                        throw new BenchmarkDefinitionException("Invalid status range " + low + "-" + high + " in '" + entry.getKey() + "'");
                    }
                    T partValue = func.apply(entry.getValue());
                    Integer floor = byLow.floorKey(low);
                    if (floor == null) {
                        Integer ceiling = byLow.ceilingKey(low);
                        if (ceiling != null && ceiling <= high) {
                            throw new BenchmarkDefinitionException("Overlapping ranges: " + low + "-" + high + " and " + ceiling + "-" + toHigh.get(ceiling));
                        }
                        byLow.put(low, partValue);
                        toHigh.put(low, high);
                        continue;
                    }
                    if (floor == low) {
                        throw new BenchmarkDefinitionException("Overlapping ranges: " + low + "-" + high + " and " + floor + "-" + toHigh.get(floor));
                    }
                    Integer floorHigh = (Integer)toHigh.get(floor);
                    if (floorHigh >= low) {
                        throw new BenchmarkDefinitionException("Overlapping ranges: " + low + "-" + high + " and " + floor + "-" + floorHigh);
                    }
                    Integer ceiling = byLow.ceilingKey(low);
                    if (ceiling != null && ceiling <= high) {
                        throw new BenchmarkDefinitionException("Overlapping ranges: " + low + "-" + high + " and " + ceiling + "-" + toHigh.get(ceiling));
                    }
                    byLow.put(low, partValue);
                    toHigh.put(low, high);
                }
                catch (NumberFormatException e) {
                    throw new BenchmarkDefinitionException("Cannot parse status range '" + part + "' in '" + entry.getKey() + "'");
                }
            }
        }
        Integer lastLow = null;
        Integer lastHigh = null;
        Object lastValue = null;
        for (Map.Entry entry : byLow.entrySet()) {
            Integer high = (Integer)toHigh.get(entry.getKey());
            if (lastValue == entry.getValue() && lastHigh != null && lastHigh == (Integer)entry.getKey() - 1) {
                lastHigh = high;
                continue;
            }
            if (lastValue != null) {
                ranges.add(lastLow);
                ranges.add(lastHigh);
                values.add(lastValue);
            }
            lastLow = (Integer)entry.getKey();
            lastHigh = high;
            lastValue = entry.getValue();
        }
        if (lastValue != null) {
            ranges.add(lastLow);
            ranges.add(lastHigh);
            values.add(lastValue);
        }
        return other;
    }
}

