/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.core.builders.Condition;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.handlers.BaseDelegatingHeaderHandler;

public class ConditionalHeaderHandler
extends BaseDelegatingHeaderHandler {
    private final Condition condition;

    public ConditionalHeaderHandler(Condition condition, HeaderHandler[] handlers) {
        super(handlers);
        this.condition = condition;
    }

    @Override
    public void beforeHeaders(HttpRequest request) {
        if (this.condition.test(request.session)) {
            super.beforeHeaders(request);
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (this.condition.test(request.session)) {
            super.handleHeader(request, header, value);
        }
    }

    @Override
    public void afterHeaders(HttpRequest request) {
        if (this.condition.test(request.session)) {
            super.afterHeaders(request);
        }
    }

    @Name(value="conditional")
    public static class Builder
    extends BaseDelegatingHeaderHandler.Builder<Builder> {
        private Condition.TypesBuilder<Builder> condition = new Condition.TypesBuilder<Builder>(this);

        @Embed
        public Condition.TypesBuilder<Builder> condition() {
            return this.condition;
        }

        @Override
        public ConditionalHeaderHandler build() {
            if (this.handlers.isEmpty()) {
                throw new BenchmarkDefinitionException("Conditional handler does not delegate to any handler.");
            }
            Condition condition = this.condition.buildCondition();
            if (condition == null) {
                throw new BenchmarkDefinitionException("Conditional handler must specify a condition.");
            }
            return new ConditionalHeaderHandler(condition, this.buildHandlers());
        }
    }
}

