/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.builders.StringConditionBuilder;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableBiPredicate;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;

public class FilterHeaderHandler
implements HeaderHandler,
ResourceUtilizer {
    private final SerializableBiPredicate<Session, CharSequence> header;
    private final Processor processor;

    public FilterHeaderHandler(SerializableBiPredicate<Session, CharSequence> header, Processor processor) {
        this.header = header;
        this.processor = processor;
    }

    @Override
    public void beforeHeaders(HttpRequest request) {
        this.processor.before(request.session);
    }

    @Override
    public void afterHeaders(HttpRequest request) {
        this.processor.after(request.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (this.header.test(request.session, header)) {
            if (value == null || value.length() == 0) {
                this.processor.process(request.session, Unpooled.EMPTY_BUFFER, 0, 0, true);
            } else {
                ByteBuf byteBuf = Util.string2byteBuf(value, request.connection().context().alloc().buffer());
                try {
                    this.processor.process(request.session, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, (Object)this.processor);
    }

    @Name(value="filter")
    public static class Builder
    implements HeaderHandler.Builder {
        private StringConditionBuilder<?, Builder> header = new StringConditionBuilder(this).caseSensitive(false);
        private List<HttpRequestProcessorBuilder> processors = new ArrayList<HttpRequestProcessorBuilder>();

        @Override
        public FilterHeaderHandler build() {
            if (this.processors.isEmpty()) {
                throw new BenchmarkDefinitionException("Processor was not set!");
            }
            Processor processor = this.processors.size() == 1 ? this.processors.get(0).build(false) : new MultiProcessor((Processor[])this.processors.stream().map(p -> p.build(false)).toArray(Processor[]::new));
            return new FilterHeaderHandler(this.header.buildPredicate(), processor);
        }

        public Builder processor(HttpRequestProcessorBuilder processor) {
            this.processors.add(processor);
            return this;
        }

        public StringConditionBuilder<?, Builder> header() {
            return this.header;
        }

        public ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder> processor() {
            return new ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder>(HttpRequestProcessorBuilder.class, this::processor);
        }
    }
}

