/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogInvalidHandler
implements Processor,
HeaderHandler {
    private Logger log = LoggerFactory.getLogger(LogInvalidHandler.class);

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLast) {
        HttpRequest request = (HttpRequest)session.currentRequest();
        if (request != null && !request.isValid()) {
            this.log.debug("#{}: {} {}/{}, {} bytes: {}", new Object[]{session.uniqueId(), request.method, request.authority, request.path, data.readableBytes(), Util.toString(data, data.readerIndex(), data.readableBytes())});
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (!request.isValid()) {
            this.log.debug("#{}: {} {}/{}, {}: {}", new Object[]{request.session.uniqueId(), request.method, request.authority, request.path, header, value});
        }
    }

    @Name(value="logInvalid")
    public static class HeaderHandlerBuilder
    implements HeaderHandler.Builder {
        @Override
        public LogInvalidHandler build() {
            return new LogInvalidHandler();
        }
    }

    @Name(value="logInvalid")
    public static class BodyHandlerBuilder
    implements HttpRequestProcessorBuilder {
        @Override
        public LogInvalidHandler build(boolean fragmented) {
            return new LogInvalidHandler();
        }
    }
}

