/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.handlers.BaseDelegatingAction;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.handlers.BaseDelegatingHeaderHandler;
import io.hyperfoil.http.handlers.BaseDelegatingStatusHandler;
import io.hyperfoil.http.handlers.Location;
import io.netty.buffer.ByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Objects;
import java.util.function.Supplier;

public class Redirect {
    private static final Logger log = LoggerFactory.getLogger(Redirect.class);
    private static final boolean trace = log.isTraceEnabled();

    private static SequenceInstance pushCurrentSequence(Session session, Access coordsVar) {
        Coords coords = (Coords)coordsVar.getObject(session);
        SequenceInstance currentSequence = session.currentSequence();
        session.currentSequence(coords.originalSequence);
        Request request = session.currentRequest();
        if (request != null) {
            request.unsafeEnterSequence(coords.originalSequence);
        }
        return currentSequence;
    }

    private static void popCurrentSequence(Session session, SequenceInstance currentSequence) {
        session.currentSequence(currentSequence);
        Request request = session.currentRequest();
        if (request != null) {
            request.unsafeEnterSequence(currentSequence);
        }
    }

    public static class GetOriginalSequence
    implements SerializableFunction<Session, SequenceInstance> {
        private final Access coordVar;

        public GetOriginalSequence(Access coordVar) {
            this.coordVar = coordVar;
        }

        @Override
        public SequenceInstance apply(Session session) {
            return ((Coords)this.coordVar.getObject((Session)session)).originalSequence;
        }
    }

    public static class WrappingAction
    extends BaseDelegatingAction {
        private final Access coordVar;

        public WrappingAction(Action[] actions, Access coordVar) {
            super(actions);
            this.coordVar = coordVar;
        }

        @Override
        public void run(Session session) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(session, this.coordVar);
            try {
                super.run(session);
            }
            finally {
                Redirect.popCurrentSequence(session, currentSequence);
            }
        }

        public static class Builder
        extends BaseDelegatingAction.Builder<Builder> {
            private Object coordVar;

            public Builder coordVar(Object coordVar) {
                this.coordVar = coordVar;
                return this;
            }

            @Override
            public WrappingAction build() {
                return new WrappingAction(this.buildActions(), SessionFactory.sequenceScopedAccess(this.coordVar));
            }
        }
    }

    public static class WrappingProcessor
    extends MultiProcessor {
        private final Access coordVar;

        public WrappingProcessor(Processor[] processors, Access coordVar) {
            super(processors);
            this.coordVar = coordVar;
        }

        @Override
        public void before(Session session) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(session, this.coordVar);
            try {
                super.before(session);
            }
            finally {
                Redirect.popCurrentSequence(session, currentSequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(session, this.coordVar);
            try {
                super.process(session, data, offset, length, isLastPart);
            }
            finally {
                Redirect.popCurrentSequence(session, currentSequence);
            }
        }

        @Override
        public void after(Session session) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(session, this.coordVar);
            try {
                super.after(session);
            }
            finally {
                Redirect.popCurrentSequence(session, currentSequence);
            }
        }

        public static class Builder
        extends MultiProcessor.Builder<Builder> {
            private Object coordVar;

            public Builder coordVar(Object coordVar) {
                this.coordVar = coordVar;
                return this;
            }

            @Override
            public WrappingProcessor build(boolean fragmented) {
                return new WrappingProcessor(this.buildProcessors(fragmented), SessionFactory.sequenceScopedAccess(this.coordVar));
            }
        }
    }

    public static class WrappingHeaderHandler
    extends BaseDelegatingHeaderHandler {
        private final Access coordsVar;

        public WrappingHeaderHandler(HeaderHandler[] handlers, Access coordsVar) {
            super(handlers);
            this.coordsVar = coordsVar;
        }

        @Override
        public void beforeHeaders(HttpRequest request) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(request.session, this.coordsVar);
            try {
                super.beforeHeaders(request);
            }
            finally {
                Redirect.popCurrentSequence(request.session, currentSequence);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(request.session, this.coordsVar);
            try {
                super.handleHeader(request, header, value);
            }
            finally {
                Redirect.popCurrentSequence(request.session, currentSequence);
            }
        }

        @Override
        public void afterHeaders(HttpRequest request) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(request.session, this.coordsVar);
            try {
                super.afterHeaders(request);
            }
            finally {
                Redirect.popCurrentSequence(request.session, currentSequence);
            }
        }

        public static class Builder
        extends BaseDelegatingHeaderHandler.Builder<Builder> {
            private Object coordVar;

            public Builder coordVar(Object coordVar) {
                this.coordVar = coordVar;
                return this;
            }

            @Override
            public WrappingHeaderHandler build() {
                return new WrappingHeaderHandler(this.buildHandlers(), SessionFactory.sequenceScopedAccess(this.coordVar));
            }
        }
    }

    public static class WrappingStatusHandler
    extends BaseDelegatingStatusHandler {
        private final Access coordsVar;

        public WrappingStatusHandler(io.hyperfoil.http.api.StatusHandler[] handlers, Access coordsVar) {
            super(handlers);
            this.coordsVar = coordsVar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStatus(HttpRequest request, int status) {
            SequenceInstance currentSequence = Redirect.pushCurrentSequence(request.session, this.coordsVar);
            try {
                super.handleStatus(request, status);
            }
            finally {
                Redirect.popCurrentSequence(request.session, currentSequence);
            }
        }

        public static class Builder
        extends BaseDelegatingStatusHandler.Builder<Builder> {
            private Object coordsVar;

            public Builder coordsVar(Object coordsVar) {
                this.coordsVar = coordsVar;
                return this;
            }

            @Override
            public WrappingStatusHandler build() {
                return new WrappingStatusHandler(this.buildHandlers(), SessionFactory.sequenceScopedAccess(this.coordsVar));
            }
        }
    }

    public static class GetMethod
    implements SerializableFunction<Session, HttpMethod> {
        private final Access coordVar;

        public GetMethod(Access coordVar) {
            this.coordVar = coordVar;
        }

        @Override
        public HttpMethod apply(Session session) {
            Coords coords = (Coords)this.coordVar.getObject(session);
            return coords.method;
        }
    }

    public static class LocationRecorder
    implements HeaderHandler,
    ResourceUtilizer {
        private static final String LOCATION = "location";
        private final int concurrency;
        private final Session.ResourceKey<Queue> queueKey;
        private final Access inputVar;
        private final Access outputVar;
        private final String sequence;
        private final SerializableFunction<Session, SequenceInstance> originalSequenceSupplier;

        public LocationRecorder(int concurrency, Session.ResourceKey<Queue> queueKey, Access inputVar, Access outputVar, String sequence, SerializableFunction<Session, SequenceInstance> originalSequenceSupplier) {
            this.concurrency = concurrency;
            this.queueKey = queueKey;
            this.inputVar = inputVar;
            this.outputVar = outputVar;
            this.sequence = sequence;
            this.originalSequenceSupplier = originalSequenceSupplier;
        }

        @Override
        public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
            if (Util.regionMatchesIgnoreCase(header, 0, LOCATION, 0, LOCATION.length())) {
                Session session = request.session;
                ObjectVar var = (ObjectVar)this.inputVar.getVar(session);
                if (!var.isSet()) {
                    return;
                }
                Coords coords = (Coords)var.objectValue(session);
                if (coords.path == null) {
                    if (!Util.startsWith((CharSequence)value, 0, "http://") && !Util.startsWith((CharSequence)value, 0, "https://")) {
                        coords.authority = request.authority;
                        if (!Util.startsWith((CharSequence)value, 0, "/")) {
                            int lastSlash = request.path.lastIndexOf(47);
                            if (lastSlash < 0) {
                                log.warn((Object)"#{} Did the request have a relative path? {}", new Object[]{session.uniqueId(), request.path});
                                value = "/" + (CharSequence)value;
                            }
                            value = request.path.substring(0, lastSlash + 1) + (CharSequence)value;
                        }
                    }
                    coords.path = value;
                    coords.originalSequence = (SequenceInstance)this.originalSequenceSupplier.apply(request.session);
                    var.set(coords);
                    Queue queue = session.getResource(this.queueKey);
                    queue.push(session, coords);
                } else {
                    log.error((Object)"Duplicate location header: previously got {}, now {}. Ignoring the second match.", new Object[]{coords.path, value});
                }
            }
        }

        @Override
        public void afterHeaders(HttpRequest request) {
            Session.Var var = this.inputVar.getVar(request.session);
            if (var.isSet() && !(var.objectValue(request.session) instanceof Coords)) {
                log.error((Object)"Location header is missing in response from {} {}{}!", new Object[]{request.method, request.authority, request.path});
                request.markInvalid();
            }
        }

        @Override
        public void reserve(Session session) {
            this.outputVar.declareObject(session);
            if (!this.outputVar.isSet(session)) {
                this.outputVar.setObject(session, ObjectVar.newArray(session, this.concurrency));
            }
            session.declareResource(this.queueKey, () -> new Queue(this.outputVar, this.concurrency, this.concurrency, this.sequence, null));
        }

        public static class Builder
        implements HeaderHandler.Builder {
            private Session.ResourceKey<Queue> queueKey;
            private Object inputVar;
            private Object outputVar;
            private int concurrency;
            private String sequence;
            private Supplier<SerializableFunction<Session, SequenceInstance>> originalSequenceSupplier;

            public Builder concurrency(int concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            public Builder inputVar(Object inputVar) {
                this.inputVar = inputVar;
                return this;
            }

            public Builder outputVar(Object outputVar) {
                this.outputVar = outputVar;
                return this;
            }

            public Builder queueKey(Session.ResourceKey<Queue> queueKey) {
                this.queueKey = queueKey;
                return this;
            }

            public Builder sequence(String sequence) {
                this.sequence = sequence;
                return this;
            }

            public Builder originalSequenceSupplier(Supplier<SerializableFunction<Session, SequenceInstance>> supplier) {
                this.originalSequenceSupplier = supplier;
                return this;
            }

            @Override
            public LocationRecorder build() {
                if (Objects.equals(this.inputVar, this.outputVar)) {
                    throw new BenchmarkDefinitionException("Input (" + this.inputVar + ") and output (" + this.outputVar + ") variables must differ");
                }
                assert (this.inputVar != null);
                assert (this.outputVar != null);
                assert (this.sequence != null);
                return new LocationRecorder(this.concurrency, this.queueKey, SessionFactory.access(this.inputVar), SessionFactory.access(this.outputVar), this.sequence, this.originalSequenceSupplier.get());
            }
        }
    }

    public static class Coords
    extends Location {
        public HttpMethod method;
        public int delay;
        public SequenceInstance originalSequence;

        @Override
        public Coords reset() {
            super.reset();
            this.method = null;
            this.delay = 0;
            this.originalSequence = null;
            return this;
        }

        public String toString() {
            return this.method + " " + this.path;
        }
    }

    public static class StatusHandler
    extends BaseDelegatingStatusHandler {
        private final Access coordsVar;
        private final LimitedPoolResource.Key<Coords> poolKey;
        private final int concurrency;

        public StatusHandler(Access coordsVar, io.hyperfoil.http.api.StatusHandler[] handlers, LimitedPoolResource.Key<Coords> poolKey, int concurrency) {
            super(handlers);
            this.coordsVar = coordsVar;
            this.poolKey = poolKey;
            this.concurrency = concurrency;
        }

        @Override
        public void handleStatus(HttpRequest request, int status) {
            switch (status) {
                case 301: 
                case 302: 
                case 303: {
                    Coords coords = (Coords)((LimitedPoolResource)((Object)request.session.getResource(this.poolKey))).acquire();
                    coords.method = HttpMethod.GET;
                    this.coordsVar.setObject(request.session, coords);
                    break;
                }
                case 307: 
                case 308: {
                    Coords coords = (Coords)((LimitedPoolResource)((Object)request.session.getResource(this.poolKey))).acquire();
                    coords.method = request.method;
                    this.coordsVar.setObject(request.session, coords);
                    break;
                }
                default: {
                    this.coordsVar.unset(request.session);
                    super.handleStatus(request, status);
                }
            }
        }

        @Override
        public void reserve(Session session) {
            super.reserve(session);
            this.coordsVar.declareObject(session);
            session.declareResource(this.poolKey, () -> LimitedPoolResource.create(this.concurrency, Coords.class, Coords::new), true);
        }

        public static class Builder
        extends BaseDelegatingStatusHandler.Builder<Builder> {
            private Object coordsVar;
            private LimitedPoolResource.Key<Coords> poolKey;
            private int concurrency;

            public Builder coordsVar(Object coordsVar) {
                this.coordsVar = coordsVar;
                return this;
            }

            public Builder poolKey(LimitedPoolResource.Key<Coords> poolKey) {
                this.poolKey = poolKey;
                return this;
            }

            public Builder concurrency(int concurrency) {
                this.concurrency = concurrency;
                return this;
            }

            @Override
            public StatusHandler build() {
                return new StatusHandler(SessionFactory.access(this.coordsVar), this.buildHandlers(), this.poolKey, this.concurrency);
            }
        }
    }
}

