/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;

public class StatusToCounterHandler
implements StatusHandler,
ResourceUtilizer {
    private final Integer expectStatus;
    private final Access var;
    private final int init;
    private final Integer add;
    private final Integer set;

    public StatusToCounterHandler(int expectStatus, Access var, int init, Integer add, Integer set) {
        this.expectStatus = expectStatus;
        this.var = var;
        this.init = init;
        this.add = add;
        this.set = set;
    }

    @Override
    public void handleStatus(HttpRequest request, int status) {
        if (this.expectStatus != null && this.expectStatus != status) {
            return;
        }
        if (this.add != null) {
            if (this.var.isSet(request.session)) {
                this.var.addToInt(request.session, this.add);
            } else {
                this.var.setInt(request.session, this.init + this.add);
            }
        } else if (this.set != null) {
            this.var.setInt(request.session, this.set);
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void reserve(Session session) {
        this.var.declareInt(session);
    }

    @Name(value="counter")
    public static class Builder
    implements StatusHandler.Builder {
        private Integer expectStatus;
        private String var;
        private int init;
        private Integer add;
        private Integer set;

        public Builder expectStatus(int expectStatus) {
            this.expectStatus = expectStatus;
            return this;
        }

        public Builder var(String var) {
            this.var = var;
            return this;
        }

        public Builder init(int init) {
            this.init = init;
            return this;
        }

        public Builder add(int add) {
            this.add = add;
            return this;
        }

        public Builder set(int set) {
            this.set = set;
            return this;
        }

        @Override
        public StatusHandler build() {
            if (this.add != null && this.set != null) {
                throw new BenchmarkDefinitionException("Use either 'add' or 'set' (not both)");
            }
            if (this.add == null && this.set == null) {
                throw new BenchmarkDefinitionException("Use either 'add' or 'set'");
            }
            return new StatusToCounterHandler(this.expectStatus, SessionFactory.access(this.var), this.init, this.add, this.set);
        }
    }
}

