/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.http.html.EmbeddedResourceProcessor;
import io.hyperfoil.http.html.FetchResourceHandler;
import io.hyperfoil.http.html.HtmlHandler;

public class EmbeddedResourceHandlerBuilder
implements HtmlHandler.TagHandlerBuilder<EmbeddedResourceHandlerBuilder> {
    private static final String[] TAGS = new String[]{"img", "link", "embed", "frame", "iframe", "object", "script"};
    private static final String[] ATTRS = new String[]{"src", "href", "src", "src", "src", "data", "src"};
    private boolean ignoreExternal = true;
    private Processor.Builder<?> processor;
    private FetchResourceHandler.Builder fetchResource;

    public EmbeddedResourceHandlerBuilder ignoreExternal(boolean ignoreExternal) {
        this.ignoreExternal = ignoreExternal;
        return this;
    }

    public FetchResourceHandler.Builder fetchResource() {
        this.fetchResource = new FetchResourceHandler.Builder();
        return this.fetchResource;
    }

    public EmbeddedResourceHandlerBuilder processor(Processor.Builder<?> processor) {
        if (this.processor == null) {
            this.processor = processor;
        } else if (this.processor instanceof MultiProcessor.Builder) {
            MultiProcessor.Builder multiprocessor = (MultiProcessor.Builder)this.processor;
            multiprocessor.processor(processor);
        } else {
            this.processor = ((MultiProcessor.Builder)new MultiProcessor.Builder().processor(this.processor)).processor(processor);
        }
        return this;
    }

    public ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder> processor() {
        return new ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder>(HttpRequestProcessorBuilder.class, this::processor);
    }

    @Override
    public HtmlHandler.BaseTagAttributeHandler build() {
        if (this.processor == null && this.fetchResource == null) {
            throw new BenchmarkDefinitionException("embedded resource handler must define either processor or fetchResource!");
        }
        Processor processor = this.processor != null ? this.processor.build(false) : null;
        FetchResourceHandler fetchResource = this.fetchResource != null ? this.fetchResource.build() : null;
        return new HtmlHandler.BaseTagAttributeHandler(TAGS, ATTRS, new EmbeddedResourceProcessor(this.ignoreExternal, processor, fetchResource));
    }
}

