/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.util.Trie;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.http.html.EmbeddedResourceHandlerBuilder;
import io.hyperfoil.http.html.Match;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class HtmlHandler
implements Processor,
ResourceUtilizer,
Session.ResourceKey<Context> {
    private static final Logger log = LoggerFactory.getLogger(HtmlHandler.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] SCRIPT = "script".getBytes(StandardCharsets.UTF_8);
    private final TagHandler[] handlers;

    private HtmlHandler(TagHandler ... handlers) {
        this.handlers = handlers;
    }

    @Override
    public void before(Session session) {
        for (TagHandler h : this.handlers) {
            h.processor().before(session);
        }
    }

    @Override
    public void after(Session session) {
        for (TagHandler h : this.handlers) {
            h.processor().after(session);
        }
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Context ctx = session.getResource(this);
        switch (ctx.tagStatus) {
            case PARSING_TAG: {
                ctx.tagStart = offset;
                break;
            }
            case PARSING_ATTR: {
                ctx.attrStart = offset;
                break;
            }
            case PARSING_VALUE: {
                ctx.valueStart = offset;
            }
        }
        block23: while (length > 0) {
            byte c = data.getByte(offset++);
            --length;
            switch (ctx.tagStatus) {
                case NO_TAG: {
                    if (c != 60) continue block23;
                    ctx.tagStatus = TagStatus.ENTERED;
                    break;
                }
                case ENTERED: {
                    if (c == 33) {
                        ctx.tagStatus = TagStatus.DOCTYPE_START;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        ctx.tagStatus = TagStatus.BEFORE_TAG;
                        break;
                    }
                    if (c == 47) {
                        ctx.tagClosing = true;
                        ctx.tagStatus = TagStatus.BEFORE_TAG;
                        break;
                    }
                    ctx.tagStart = offset - 1;
                    ctx.tagStatus = TagStatus.PARSING_TAG;
                    break;
                }
                case DOCTYPE_START: {
                    if (c == 45) {
                        ctx.comment = 3;
                        ctx.tagStatus = TagStatus.COMMENT;
                        break;
                    }
                    ctx.tagStatus = TagStatus.DOCTYPE;
                    break;
                }
                case DOCTYPE: {
                    if (c != 62) continue block23;
                    ctx.endTag(session);
                    break;
                }
                case COMMENT: {
                    if (ctx.comment == 1) {
                        if (c == 62) {
                            ctx.comment = 0;
                            ctx.tagStatus = TagStatus.NO_TAG;
                            break;
                        }
                        if (c == 45) continue block23;
                        ctx.comment = 3;
                        break;
                    }
                    if (ctx.comment <= 0 || c != 45) continue block23;
                    --ctx.comment;
                    break;
                }
                case BEFORE_TAG: {
                    if (Character.isWhitespace(c)) continue block23;
                    ctx.tagStatus = TagStatus.PARSING_TAG;
                    ctx.tagStart = offset - 1;
                    break;
                }
                case PARSING_TAG: {
                    if (Character.isWhitespace(c)) {
                        ctx.tagStatus = TagStatus.BEFORE_ATTR;
                        ctx.onTag(session, data, offset - 1, true);
                        break;
                    }
                    if (c != 62) continue block23;
                    ctx.onTag(session, data, offset - 1, true);
                    ctx.endTag(session);
                    break;
                }
                case BEFORE_ATTR: {
                    if (c == 62) {
                        ctx.endTag(session);
                        break;
                    }
                    if (c == 47) {
                        ctx.tagClosing = true;
                        break;
                    }
                    if (Character.isWhitespace(c)) continue block23;
                    ctx.attrStart = offset - 1;
                    ctx.tagStatus = TagStatus.PARSING_ATTR;
                    ctx.tagClosing = false;
                    break;
                }
                case PARSING_ATTR: {
                    if (c == 61 || Character.isWhitespace(c)) {
                        ctx.onAttr(session, data, offset - 1, true);
                        ctx.tagStatus = TagStatus.BEFORE_VALUE;
                        break;
                    }
                    if (c == 47) {
                        ctx.tagClosing = true;
                        break;
                    }
                    if (c != 62) continue block23;
                    ctx.onAttr(session, data, offset - 1, true);
                    ctx.endTag(session);
                    break;
                }
                case BEFORE_VALUE: {
                    if (c == 62) {
                        ctx.endTag(session);
                        break;
                    }
                    if (c == 61) continue block23;
                    if (Character.isWhitespace(c)) break;
                    if (c == 34) {
                        ctx.tagStatus = TagStatus.PARSING_VALUE;
                        ctx.valueStart = offset;
                        ctx.valueQuoted = true;
                        break;
                    }
                    ctx.tagStatus = TagStatus.PARSING_VALUE;
                    ctx.valueStart = offset - 1;
                    break;
                }
                case PARSING_VALUE: {
                    if (c == 92) {
                        ctx.charEscaped = true;
                        break;
                    }
                    if (c == 34 && !ctx.charEscaped) {
                        ctx.onValue(session, data, offset - 1, true);
                        ctx.tagStatus = TagStatus.BEFORE_ATTR;
                        ctx.valueQuoted = false;
                        break;
                    }
                    if (!ctx.valueQuoted && Character.isWhitespace(c)) {
                        ctx.onValue(session, data, offset - 1, true);
                        ctx.tagStatus = TagStatus.BEFORE_ATTR;
                        break;
                    }
                    ctx.charEscaped = false;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        switch (ctx.tagStatus) {
            case PARSING_TAG: {
                ctx.onTag(session, data, offset, false);
                break;
            }
            case PARSING_ATTR: {
                ctx.onAttr(session, data, offset, false);
                break;
            }
            case PARSING_VALUE: {
                ctx.onValue(session, data, offset, false);
            }
        }
    }

    @Override
    public void reserve(Session session) {
        session.declareResource(this, () -> new Context());
        ResourceUtilizer.reserve(session, this.handlers);
    }

    static class BaseTagAttributeHandler
    implements TagHandler,
    ResourceUtilizer {
        private final Trie trie;
        private final byte[][] attributes;
        private final Processor processor;

        BaseTagAttributeHandler(String[] tags, String[] attributes, Processor processor) {
            this.processor = processor;
            if (tags.length != attributes.length) {
                throw new IllegalArgumentException();
            }
            this.trie = new Trie(tags);
            this.attributes = (byte[][])Stream.of(attributes).map(s -> s.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        }

        @Override
        public Processor processor() {
            return this.processor;
        }

        @Override
        public HandlerContext newContext() {
            return new Ctx();
        }

        @Override
        public void reserve(Session session) {
            ResourceUtilizer.reserve(session, (Object)this.processor);
        }

        protected class Ctx
        implements HandlerContext {
            private final Trie.State trieState;
            private int tagMatched;
            private int attrMatchedIndex;
            private final ByteBuf valueBuffer;

            protected Ctx() {
                this.trieState = BaseTagAttributeHandler.this.trie.newState();
                this.tagMatched = -1;
                this.attrMatchedIndex = -1;
                this.valueBuffer = ByteBufAllocator.DEFAULT.buffer();
            }

            @Override
            public void onTag(Session session, boolean close, ByteBuf data, int offset, int length, boolean isLast) {
                for (int i = 0; i < length; ++i) {
                    int terminal = this.trieState.next(Util.toLowerCase(data.getByte(offset + i)));
                    if (!isLast || terminal < 0) continue;
                    this.tagMatched = terminal;
                    this.attrMatchedIndex = 0;
                }
            }

            @Override
            public void onAttr(Session session, ByteBuf data, int offset, int length, boolean isLast) {
                if (this.tagMatched < 0) {
                    return;
                }
                if (this.attrMatchedIndex >= 0) {
                    for (int i = 0; i < length; ++i) {
                        if (this.attrMatchedIndex >= BaseTagAttributeHandler.this.attributes[this.tagMatched].length) {
                            this.attrMatchedIndex = -1;
                            break;
                        }
                        if (BaseTagAttributeHandler.this.attributes[this.tagMatched][this.attrMatchedIndex] == data.getByte(offset + i)) {
                            ++this.attrMatchedIndex;
                            continue;
                        }
                        this.attrMatchedIndex = -1;
                        break;
                    }
                }
                if (isLast && this.attrMatchedIndex != BaseTagAttributeHandler.this.attributes[this.tagMatched].length) {
                    this.attrMatchedIndex = 0;
                }
            }

            @Override
            public void onValue(Session session, ByteBuf data, int offset, int length, boolean isLast) {
                if (this.tagMatched < 0 || this.attrMatchedIndex <= 0) {
                    return;
                }
                this.valueBuffer.ensureWritable(length);
                this.valueBuffer.writeBytes(data, offset, length);
                if (isLast) {
                    BaseTagAttributeHandler.this.processor().process(session, this.valueBuffer, this.valueBuffer.readerIndex(), this.valueBuffer.readableBytes(), true);
                    this.valueBuffer.clear();
                    this.attrMatchedIndex = 0;
                }
            }

            @Override
            public void endTag(Session session, boolean closing) {
                this.trieState.reset();
                this.tagMatched = -1;
                this.attrMatchedIndex = -1;
            }
        }
    }

    @Name(value="parseHtml")
    public static class Builder
    implements HttpRequestProcessorBuilder {
        private List<TagHandlerBuilder<?>> handlers = new ArrayList();

        public EmbeddedResourceHandlerBuilder onEmbeddedResource() {
            if (this.handlers.stream().anyMatch(EmbeddedResourceHandlerBuilder.class::isInstance)) {
                throw new BenchmarkDefinitionException("Embedded resource handler already set!");
            }
            EmbeddedResourceHandlerBuilder builder = new EmbeddedResourceHandlerBuilder();
            this.handler(builder);
            return builder;
        }

        public Builder handler(TagHandlerBuilder<?> handler) {
            this.handlers.add(handler);
            return this;
        }

        @Override
        public HtmlHandler build(boolean fragmented) {
            TagHandler[] tagHandlers = (TagHandler[])this.handlers.stream().map(TagHandlerBuilder::build).toArray(TagHandler[]::new);
            return new HtmlHandler(tagHandlers);
        }
    }

    static interface HandlerContext {
        public void onTag(Session var1, boolean var2, ByteBuf var3, int var4, int var5, boolean var6);

        public void onAttr(Session var1, ByteBuf var2, int var3, int var4, boolean var5);

        public void onValue(Session var1, ByteBuf var2, int var3, int var4, boolean var5);

        public void endTag(Session var1, boolean var2);
    }

    class Context
    implements Session.Resource {
        TagStatus tagStatus = TagStatus.NO_TAG;
        boolean valueQuoted;
        boolean charEscaped;
        boolean tagClosing;
        int tagStart = -1;
        int attrStart = -1;
        int valueStart = -1;
        int comment;
        Match scriptMatch = new Match();
        boolean inScript;
        HandlerContext[] handlerCtx;

        Context() {
            this.handlerCtx = (HandlerContext[])Stream.of(HtmlHandler.this.handlers).map(TagHandler::newContext).toArray(HandlerContext[]::new);
        }

        void onTag(Session session, ByteBuf data, int tagEnd, boolean isLast) {
            assert (this.tagStart >= 0);
            this.scriptMatch.shift(data, this.tagStart, tagEnd - this.tagStart, isLast, SCRIPT);
            if (!(!this.inScript || this.tagClosing && this.scriptMatch.hasMatch())) {
                this.tagStart = -1;
                this.tagStatus = TagStatus.NO_TAG;
                return;
            }
            for (HandlerContext handlerCtx : this.handlerCtx) {
                handlerCtx.onTag(session, this.tagClosing, data, this.tagStart, tagEnd - this.tagStart, isLast);
            }
            this.tagStart = -1;
        }

        void onAttr(Session session, ByteBuf data, int attrEnd, boolean isLast) {
            assert (this.attrStart >= 0);
            for (HandlerContext handlerCtx : this.handlerCtx) {
                handlerCtx.onAttr(session, data, this.attrStart, attrEnd - this.attrStart, isLast);
            }
            this.attrStart = -1;
        }

        void onValue(Session session, ByteBuf data, int valueEnd, boolean isLast) {
            assert (this.valueStart >= 0);
            for (HandlerContext handlerCtx : this.handlerCtx) {
                handlerCtx.onValue(session, data, this.valueStart, valueEnd - this.valueStart, isLast);
            }
            this.valueStart = -1;
        }

        private void endTag(Session session) {
            if (!this.inScript && !this.tagClosing && this.scriptMatch.hasMatch()) {
                this.inScript = true;
            } else if (this.inScript && this.tagClosing && this.scriptMatch.hasMatch()) {
                this.inScript = false;
            }
            this.scriptMatch.reset();
            for (int i = 0; i < this.handlerCtx.length; ++i) {
                this.handlerCtx[i].endTag(session, this.tagClosing);
            }
            this.tagStatus = TagStatus.NO_TAG;
            this.tagClosing = false;
        }
    }

    static enum TagStatus {
        NO_TAG,
        ENTERED,
        BEFORE_TAG,
        PARSING_TAG,
        BEFORE_ATTR,
        PARSING_ATTR,
        DOCTYPE_START,
        DOCTYPE,
        BEFORE_VALUE,
        PARSING_VALUE,
        COMMENT;

    }

    public static interface TagHandler
    extends Serializable {
        public Processor processor();

        public HandlerContext newContext();
    }

    public static interface TagHandlerBuilder<S extends TagHandlerBuilder<S>>
    extends BuilderBase<S> {
        public TagHandler build();
    }
}

