/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.handlers.Redirect;
import io.netty.buffer.ByteBuf;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.nio.charset.StandardCharsets;

public class RefreshHandler
implements Processor,
ResourceUtilizer {
    private static final Logger log = LoggerFactory.getLogger(RefreshHandler.class);
    private static final byte[] URL = "url".getBytes(StandardCharsets.UTF_8);
    private final Queue.Key immediateQueueKey;
    private final Queue.Key delayedQueueKey;
    private final LimitedPoolResource.Key<Redirect.Coords> poolKey;
    private final int concurrency;
    private final Access immediateQueueVar;
    private final Access delayedQueueVar;
    private final String redirectSequence;
    private final String delaySequence;
    private final Access tempCoordsVar;
    private final SerializableFunction<Session, SequenceInstance> originalSequenceSupplier;

    public RefreshHandler(Queue.Key immediateQueueKey, Queue.Key delayedQueueKey, LimitedPoolResource.Key<Redirect.Coords> poolKey, int concurrency, Access immediateQueueVar, Access delayedQueueVar, String redirectSequence, String delaySequence, Access tempCoordsVar, SerializableFunction<Session, SequenceInstance> originalSequenceSupplier) {
        this.immediateQueueKey = immediateQueueKey;
        this.delayedQueueKey = delayedQueueKey;
        this.poolKey = poolKey;
        this.concurrency = concurrency;
        this.immediateQueueVar = immediateQueueVar;
        this.delayedQueueVar = delayedQueueVar;
        this.redirectSequence = redirectSequence;
        this.delaySequence = delaySequence;
        this.tempCoordsVar = tempCoordsVar;
        this.originalSequenceSupplier = originalSequenceSupplier;
    }

    @Override
    public void before(Session session) {
        this.tempCoordsVar.unset(session);
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        assert (isLastPart);
        try {
            long seconds = 0L;
            String url = null;
            for (int i = 0; i < length; ++i) {
                if (data.getByte(offset + i) != 59) continue;
                seconds = Util.parseLong(data, offset, i);
                ++i;
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                while (length > 0 && Character.isWhitespace(data.getByte(offset + length - 1))) {
                    --length;
                }
                int j = 0;
                while (j < URL.length) {
                    if (Util.toLowerCase(data.getByte(offset + i)) != URL[j]) {
                        log.warn((Object)"#{} Failed to parse META refresh content (missing URL): {}", new Object[]{session.uniqueId(), Util.toString(data, offset, length)});
                        return;
                    }
                    ++j;
                    ++i;
                }
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                if (data.getByte(offset + i) != 61) {
                    log.warn((Object)"#{} Failed to parse META refresh content (missing = after URL): {}", new Object[]{session.uniqueId(), Util.toString(data, offset, length)});
                    return;
                }
                ++i;
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                url = Util.toString(data, offset + i, length - i);
                break;
            }
            if (url == null) {
                seconds = Util.parseLong(data, offset, length);
            }
            Redirect.Coords coords = (Redirect.Coords)((LimitedPoolResource)((Object)session.getResource(this.poolKey))).acquire();
            coords.method = HttpMethod.GET;
            coords.originalSequence = (SequenceInstance)this.originalSequenceSupplier.apply(session);
            coords.delay = (int)seconds;
            if (url == null) {
                HttpRequest request = (HttpRequest)session.currentRequest();
                coords.authority = request.authority;
                coords.path = request.path;
            } else if (url.startsWith("http://") || url.startsWith("https://")) {
                coords.authority = null;
                coords.path = url;
            } else {
                HttpRequest request = (HttpRequest)session.currentRequest();
                coords.authority = request.authority;
                if (url.startsWith("/")) {
                    coords.path = url;
                } else {
                    int lastSlash = request.path.lastIndexOf(47);
                    if (lastSlash < 0) {
                        log.warn((Object)"#{} Did the request have a relative path? {}", new Object[]{session.uniqueId(), request.path});
                        coords.path = "/" + url;
                    } else {
                        coords.path = request.path.substring(0, lastSlash + 1) + url;
                    }
                }
            }
            session.getResource(seconds == 0L ? this.immediateQueueKey : this.delayedQueueKey).push(session, coords);
            this.tempCoordsVar.setObject(session, coords);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"#{} Failed to parse META refresh content: {}", new Object[]{session.uniqueId(), Util.toString(data, offset, length)});
        }
    }

    @Override
    public void reserve(Session session) {
        this.tempCoordsVar.declareObject(session);
        session.declareResource(this.poolKey, () -> LimitedPoolResource.create(this.concurrency, Redirect.Coords.class, Redirect.Coords::new), true);
        session.declareResource(this.immediateQueueKey, () -> new Queue(this.immediateQueueVar, this.concurrency, this.concurrency, this.redirectSequence, null), true);
        session.declareResource(this.delayedQueueKey, () -> new Queue(this.delayedQueueVar, this.concurrency, this.concurrency, this.delaySequence, null), true);
        this.initQueueVar(session, this.immediateQueueVar);
        this.initQueueVar(session, this.delayedQueueVar);
    }

    private void initQueueVar(Session session, Access var) {
        var.declareObject(session);
        if (!var.isSet(session)) {
            var.setObject(session, ObjectVar.newArray(session, this.concurrency));
        }
    }
}

