/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ReflectionParser;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class HttpParser
extends AbstractParser<BenchmarkBuilder, HttpBuilder> {
    private static AddressParser ADDRESS_PARSER = new AddressParser();

    public HttpParser() {
        this.register("protocol", new PropertyParser.String<HttpBuilder>((builder, scheme) -> builder.protocol(Protocol.fromScheme(scheme))));
        this.register("host", new PropertyParser.String<HttpBuilder>(HttpBuilder::host));
        this.register("port", new PropertyParser.Int<HttpBuilder>(HttpBuilder::port));
        this.register("allowHttp1x", new PropertyParser.Boolean<HttpBuilder>(HttpBuilder::allowHttp1x));
        this.register("allowHttp2", new PropertyParser.Boolean<HttpBuilder>(HttpBuilder::allowHttp2));
        this.register("maxHttp2Streams", new PropertyParser.Int<HttpBuilder>(HttpBuilder::maxHttp2Streams));
        this.register("sharedConnections", new PropertyParser.Int<HttpBuilder>(HttpBuilder::sharedConnections));
        this.register("pipeliningLimit", new PropertyParser.Int<HttpBuilder>(HttpBuilder::pipeliningLimit));
        this.register("directHttp2", new PropertyParser.Boolean<HttpBuilder>(HttpBuilder::directHttp2));
        this.register("requestTimeout", new PropertyParser.String<HttpBuilder>(HttpBuilder::requestTimeout));
        this.register("addresses", HttpParser::parseAddresses);
        this.register("rawBytesHandlers", new PropertyParser.Boolean<HttpBuilder>(HttpBuilder::rawBytesHandlers));
        this.register("keyManager", new ReflectionParser<HttpBuilder, HttpBuilder.KeyManagerBuilder>(HttpBuilder::keyManager));
        this.register("trustManager", new ReflectionParser<HttpBuilder, HttpBuilder.TrustManagerBuilder>(HttpBuilder::trustManager));
        this.register("privatePools", new PropertyParser.Boolean<HttpBuilder>(HttpBuilder::privatePools));
    }

    @Override
    public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
        HttpPluginBuilder plugin = target.addPlugin(HttpPluginBuilder::new);
        if (ctx.peek() instanceof SequenceStartEvent) {
            ctx.parseList(plugin, (ctx1, builder) -> {
                HttpBuilder http = builder.decoupledHttp();
                this.callSubBuilders(ctx1, http);
                builder.addHttp(http);
            });
        } else {
            this.callSubBuilders(ctx, plugin.http());
        }
    }

    private static void parseAddresses(Context ctx, HttpBuilder builder) throws ParserException {
        if (ctx.peek() instanceof ScalarEvent) {
            String value = ctx.expectEvent(ScalarEvent.class).getValue();
            if (value != null && !value.isEmpty()) {
                builder.addAddress(value);
            }
        } else {
            ctx.parseList(builder, ADDRESS_PARSER);
        }
    }

    private static class AddressParser
    implements Parser<HttpBuilder> {
        private AddressParser() {
        }

        @Override
        public void parse(Context ctx, HttpBuilder target) throws ParserException {
            ScalarEvent event = ctx.expectEvent(ScalarEvent.class);
            target.addAddress(event.getValue());
        }
    }
}

