/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.PartialBuilder;
import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.builders.SLA;
import io.hyperfoil.core.builders.SLABuilder;
import io.hyperfoil.core.builders.StringConditionBuilder;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.generators.StringGeneratorBuilder;
import io.hyperfoil.core.generators.StringGeneratorImplBuilder;
import io.hyperfoil.core.handlers.StoreProcessor;
import io.hyperfoil.core.http.GzipInflatorProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.DelaySessionStartStep;
import io.hyperfoil.core.steps.PathMetricSelector;
import io.hyperfoil.core.steps.StatisticsStep;
import io.hyperfoil.core.util.BitSetResource;
import io.hyperfoil.core.util.DoubleIncrementBuilder;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.HttpRequestPool;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.UserAgentAppender;
import io.hyperfoil.http.api.HttpConnectionPool;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.config.Http;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.HttpPluginConfig;
import io.hyperfoil.http.cookie.CookieAppender;
import io.hyperfoil.http.handlers.FilterHeaderHandler;
import io.hyperfoil.http.steps.BodyBuilder;
import io.hyperfoil.http.steps.HttpMethodBuilder;
import io.hyperfoil.http.steps.HttpResponseHandlersImpl;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class HttpRequestStep
extends StatisticsStep
implements ResourceUtilizer,
SLA.Provider {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestStep.class);
    private static final boolean trace = log.isTraceEnabled();
    final SerializableFunction<Session, HttpMethod> method;
    final SerializableFunction<Session, String> authority;
    final SerializableFunction<Session, String> pathGenerator;
    final SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator;
    final SerializableBiConsumer<Session, HttpRequestWriter>[] headerAppenders;
    @Visitor.Ignore
    private final boolean injectHostHeader;
    final SerializableBiFunction<String, String, String> metricSelector;
    final long timeout;
    final HttpResponseHandlersImpl handler;
    final SLA[] sla;

    public HttpRequestStep(int stepId, SerializableFunction<Session, HttpMethod> method, SerializableFunction<Session, String> authority, SerializableFunction<Session, String> pathGenerator, SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator, SerializableBiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, SerializableBiFunction<String, String, String> metricSelector, long timeout, HttpResponseHandlersImpl handler, SLA[] sla) {
        super(stepId);
        this.method = method;
        this.authority = authority;
        this.pathGenerator = pathGenerator;
        this.bodyGenerator = bodyGenerator;
        this.headerAppenders = headerAppenders;
        this.injectHostHeader = injectHostHeader;
        this.metricSelector = metricSelector;
        this.timeout = timeout;
        this.handler = handler;
        this.sla = sla;
    }

    @Override
    public boolean invoke(Session session) {
        HttpConnectionPool connectionPool;
        String path;
        String authority;
        SequenceInstance sequence = session.currentSequence();
        HttpRequest request = HttpRequestPool.get(session).acquire();
        if (request == null) {
            log.warn((Object)"#{} Request pool too small; increase it to prevent blocking.", new Object[]{session.uniqueId()});
            return false;
        }
        request.method = (HttpMethod)((Object)this.method.apply(session));
        try {
            boolean isHttp;
            authority = this.authority == null ? null : (String)this.authority.apply(session);
            path = (String)this.pathGenerator.apply(session);
            HttpDestinationTable destinations = HttpDestinationTable.get(session);
            if (authority == null && ((isHttp = path.startsWith("http://")) || path.startsWith("https://"))) {
                for (String hostPort : destinations.authorities()) {
                    if (!HttpUtil.authorityMatch(path, hostPort, isHttp)) continue;
                    authority = hostPort;
                    break;
                }
                if (authority == null) {
                    log.error((Object)"Cannot access {}: no base url configured", new Object[]{path});
                    return true;
                }
                path = path.substring(this.prefixLength(isHttp) + authority.length());
            }
            String metric = destinations.hasSingleDestination() ? (String)this.metricSelector.apply(null, path) : (String)this.metricSelector.apply(authority, path);
            Statistics statistics = session.statistics(this.id(), metric);
            request.path = path;
            request.start(this.handler, sequence, statistics);
            connectionPool = destinations.getConnectionPool(authority);
            if (connectionPool == null) {
                session.fail(new BenchmarkExecutionException("There is no connection pool with authority '" + authority + "', available pools are: " + Arrays.asList(destinations.authorities())));
                return false;
            }
            request.authority = authority == null ? connectionPool.clientPool().authority() : authority;
        }
        catch (Throwable t) {
            if (!request.isRunning()) {
                request.start(sequence, null);
            }
            request.setCompleted();
            request.release();
            throw t;
        }
        if (!connectionPool.request(request, this.headerAppenders, this.injectHostHeader, this.bodyGenerator, false)) {
            request.setCompleted();
            request.release();
            connectionPool.registerWaitingSession(session);
            sequence.setBlockedTimestamp();
            request.statistics().incrementBlockedCount(request.startTimestampMillis());
            return false;
        }
        long blockedTime = sequence.getBlockedTime();
        if (blockedTime > 0L) {
            request.statistics().incrementBlockedTime(request.startTimestampMillis(), blockedTime);
        }
        if (request.isCompleted()) {
            request.release();
            return true;
        }
        if (this.timeout > 0L) {
            request.setTimeout(this.timeout, TimeUnit.MILLISECONDS);
        } else {
            Benchmark benchmark = session.phase().benchmark();
            HttpPluginConfig httpConfig = benchmark.plugin(HttpPluginConfig.class);
            Http http = authority == null ? httpConfig.defaultHttp() : httpConfig.http().get(authority);
            long timeout = http.requestTimeout();
            if (timeout > 0L) {
                request.setTimeout(timeout, TimeUnit.MILLISECONDS);
            }
        }
        if (trace) {
            log.trace((Object)"#{} sent to {} request on {}", new Object[]{session.uniqueId(), path, request.connection()});
        }
        request.statistics().incrementRequests(request.startTimestampMillis());
        return true;
    }

    private int prefixLength(boolean isHttp) {
        return isHttp ? "http://".length() : "https://".length();
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.authority, this.pathGenerator, this.bodyGenerator);
        ResourceUtilizer.reserve(session, this.headerAppenders);
        this.handler.reserve(session);
    }

    @Override
    public SLA[] sla() {
        return this.sla;
    }

    public static enum CompressionType {
        CONTENT_ENCODING,
        TRANSFER_ENCODING;

    }

    public static class CompressionBuilder
    implements BuilderBase<CompressionBuilder> {
        private final Builder parent;
        private String encoding;
        private CompressionType type = CompressionType.CONTENT_ENCODING;

        public CompressionBuilder() {
            this(null);
        }

        public CompressionBuilder(Builder parent) {
            this.parent = parent;
        }

        public CompressionBuilder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public CompressionBuilder type(CompressionType type) {
            this.type = type;
            return this;
        }

        public Builder end() {
            return this.parent;
        }

        @Override
        public void prepareBuild() {
            if (this.encoding != null) {
                AsciiString expectedHeader;
                if (!this.encoding.equalsIgnoreCase("gzip")) {
                    throw new BenchmarkDefinitionException("The only supported compression encoding is 'gzip'");
                }
                Unique encoding = new Unique(Locator.current().sequence().rootSequence().concurrency() > 0);
                if (this.type == CompressionType.CONTENT_ENCODING) {
                    this.parent.headerAppender(new StaticHeaderWriter(HttpHeaderNames.ACCEPT_ENCODING.toString(), this.encoding));
                    expectedHeader = HttpHeaderNames.CONTENT_ENCODING;
                } else if (this.type == CompressionType.TRANSFER_ENCODING) {
                    this.parent.headerAppender(new StaticHeaderWriter((CharSequence)HttpHeaderNames.TE, this.encoding));
                    expectedHeader = HttpHeaderNames.TRANSFER_ENCODING;
                } else {
                    throw new BenchmarkDefinitionException("Unexpected compression type: " + this.type);
                }
                this.parent.handler.header(((FilterHeaderHandler.Builder)((StringConditionBuilder)new FilterHeaderHandler.Builder().header().equalTo(expectedHeader.toString())).end()).processor(HttpRequestProcessorBuilder.adapt(new StoreProcessor.Builder().toVar(encoding))));
                this.parent.handler.wrapBodyHandlers(handlers -> new GzipInflatorProcessor.Builder().processors((Collection<? extends Processor.Builder<?>>)handlers).encodingVar(encoding));
            }
        }
    }

    public static class CompensatedResponseRecorder
    implements Action {
        private final int stepId;
        private final SerializableBiFunction<String, String, String> metricSelector;

        public CompensatedResponseRecorder(int stepId, SerializableBiFunction<String, String, String> metricSelector) {
            this.stepId = stepId;
            this.metricSelector = metricSelector;
        }

        @Override
        public void run(Session session) {
            HttpRequest request = (HttpRequest)session.currentRequest();
            String metric = (String)this.metricSelector.apply(request.authority, request.path);
            Statistics statistics = session.statistics(this.stepId, metric);
            DelaySessionStartStep.Holder holder = session.getResource(DelaySessionStartStep.KEY);
            long startTimeMs = holder.lastStartTime();
            statistics.incrementRequests(startTimeMs);
            if (request.cacheControl.wasCached) {
                statistics.addCacheHit(startTimeMs);
            } else {
                long now = System.currentTimeMillis();
                log.trace((Object)"#{} Session start {}, now {}, diff {}", new Object[]{session.uniqueId(), startTimeMs, now, now - startTimeMs});
                statistics.recordResponse(startTimeMs, 0L, TimeUnit.MILLISECONDS.toNanos(now - startTimeMs));
            }
        }

        public static class Builder
        implements Action.Builder {
            private SerializableBiFunction<String, String, String> metricSelector;

            @Override
            public Action build() {
                io.hyperfoil.http.steps.HttpRequestStep$Builder stepBuilder = (io.hyperfoil.http.steps.HttpRequestStep$Builder)Locator.current().step();
                Builder.PrefixMetricSelector metricSelector = this.metricSelector;
                if (metricSelector == null) {
                    metricSelector = new Builder.PrefixMetricSelector("compensated-", stepBuilder.metricSelector);
                }
                return new CompensatedResponseRecorder(stepBuilder.id(), metricSelector);
            }

            public Builder metric(SerializableBiFunction<String, String, String> metricSelector) {
                this.metricSelector = metricSelector;
                return this;
            }
        }
    }

    public static class CompensationBuilder {
        private static final String DELAY_SESSION_START = "__delay-session-start";
        private final Builder parent;
        public SerializableBiFunction<String, String, String> metricSelector;
        public double targetRate;
        public double targetRateIncrement;
        private DoubleIncrementBuilder targetRateBuilder;

        public CompensationBuilder(Builder parent) {
            this.parent = parent;
        }

        public CompensationBuilder targetRate(double targetRate) {
            this.targetRate = targetRate;
            return this;
        }

        public DoubleIncrementBuilder targetRate() {
            this.targetRateBuilder = new DoubleIncrementBuilder((base, inc) -> {
                this.targetRate = base;
                this.targetRateIncrement = inc;
            });
            return this.targetRateBuilder;
        }

        public CompensationBuilder metric(String name) {
            this.metricSelector = new Builder.ProvidedMetricSelector(name);
            return this;
        }

        public PathMetricSelector metric() {
            PathMetricSelector metricSelector;
            this.metricSelector = metricSelector = new PathMetricSelector();
            return metricSelector;
        }

        public void prepareBuild() {
            ScenarioBuilder scenario;
            PhaseBuilder<?> phaseBuilder;
            if (this.targetRateBuilder != null) {
                this.targetRateBuilder.apply();
            }
            if (!((phaseBuilder = (scenario = Locator.current().scenario()).endScenario()) instanceof PhaseBuilder.Always)) {
                throw new BenchmarkDefinitionException("delaySessionStart step makes sense only in phase type 'always'");
            }
            if (!scenario.hasSequence(DELAY_SESSION_START)) {
                List<SequenceBuilder> prev = scenario.resetInitialSequences();
                scenario.initialSequence(DELAY_SESSION_START).step(new DelaySessionStartStep((String[])prev.stream().map(SequenceBuilder::name).toArray(String[]::new), this.targetRate, this.targetRateIncrement, true));
            } else {
                log.warn((Object)"Scenario for phase {} contains multiple compensating HTTP requests: make sure that all use the same rate.", new Object[]{phaseBuilder.name()});
            }
            this.parent.handler.onCompletion(new CompensatedResponseRecorder.Builder().metric(this.metricSelector));
        }

        public Builder end() {
            return this.parent;
        }
    }

    private static class FromVarHeaderWriter
    implements SerializableBiConsumer<Session, HttpRequestWriter> {
        private final CharSequence header;
        private final Access fromVar;

        public FromVarHeaderWriter(CharSequence header, Access fromVar) {
            this.fromVar = fromVar;
            this.header = header;
        }

        @Override
        public void accept(Session session, HttpRequestWriter writer) {
            Object value = this.fromVar.getObject(session);
            if (value instanceof CharSequence) {
                writer.putHeader(this.header, (CharSequence)value);
            } else {
                log.error((Object)"#{} Cannot convert variable {}: {} to CharSequence", new Object[]{session.uniqueId(), this.fromVar, value});
            }
        }
    }

    public static interface BodyGeneratorBuilder
    extends BuilderBase<BodyGeneratorBuilder> {
        public SerializableBiFunction<Session, Connection, ByteBuf> build();
    }

    public static class PartialHeadersBuilder
    implements InitFromParam<PartialHeadersBuilder> {
        private final HeadersBuilder parent;
        private final String header;
        private boolean added;

        private PartialHeadersBuilder(HeadersBuilder parent, String header) {
            this.parent = parent;
            this.header = header;
        }

        @Override
        public PartialHeadersBuilder init(String param) {
            return this.pattern(param);
        }

        public PartialHeadersBuilder fromVar(String var) {
            this.ensureOnce();
            this.parent.parent.headerAppenders.add(() -> new FromVarHeaderWriter(this.header, SessionFactory.access(var)));
            return this;
        }

        public PartialHeadersBuilder pattern(String patternString) {
            this.ensureOnce();
            this.parent.parent.headerAppenders.add(() -> new PatternHeaderWriter(this.header, new Pattern(patternString, false)));
            return this;
        }

        private void ensureOnce() {
            if (this.added) {
                throw new BenchmarkDefinitionException("Trying to add header " + this.header + " twice. Use only one of: fromVar, pattern");
            }
            this.added = true;
        }

        public HeadersBuilder end() {
            return this.parent;
        }

        private static class PatternHeaderWriter
        implements SerializableBiConsumer<Session, HttpRequestWriter> {
            private final String header;
            private final Pattern pattern;

            public PatternHeaderWriter(String header, Pattern pattern) {
                this.header = header;
                this.pattern = pattern;
            }

            @Override
            public void accept(Session session, HttpRequestWriter writer) {
                writer.putHeader(this.header, this.pattern.apply(session));
            }
        }
    }

    private static class StaticHeaderWriter
    implements SerializableBiConsumer<Session, HttpRequestWriter> {
        private final CharSequence header;
        private final CharSequence value;

        private StaticHeaderWriter(CharSequence header, CharSequence value) {
            this.header = header;
            this.value = value;
        }

        @Override
        public void accept(Session session, HttpRequestWriter writer) {
            writer.putHeader(this.header, this.value);
        }
    }

    public static class HeadersBuilder
    extends PairBuilder.OfString
    implements PartialBuilder {
        private final Builder parent;

        public HeadersBuilder(Builder builder) {
            this.parent = builder;
        }

        public HeadersBuilder header(CharSequence header, CharSequence value) {
            this.warnIfUsingHostHeader(header);
            this.parent.headerAppender(new StaticHeaderWriter(header, value));
            return this;
        }

        @Override
        public void accept(String header, String value) {
            this.withKey(header).pattern(value);
        }

        public Builder endHeaders() {
            return this.parent;
        }

        @Override
        public PartialHeadersBuilder withKey(String key) {
            this.warnIfUsingHostHeader(key);
            return new PartialHeadersBuilder(this, key);
        }

        private void warnIfUsingHostHeader(CharSequence key) {
            if (key.toString().equalsIgnoreCase("host")) {
                log.warn((Object)"Setting `host` header explicitly is not recommended. Use the HTTP host and adjust actual target using `addresses` property.");
                this.parent.injectHostHeader = false;
            }
        }
    }

    private static class AfterSyncRequestStep
    implements Step {
        private final Session.ResourceKey<BitSetResource> key;

        private AfterSyncRequestStep(Session.ResourceKey<BitSetResource> key) {
            this.key = key;
        }

        @Override
        public boolean invoke(Session session) {
            BitSetResource resource = session.getResource(this.key);
            return resource.get(session.currentSequence().index());
        }
    }

    private static class BeforeSyncRequestStep
    implements Step,
    ResourceUtilizer,
    Session.ResourceKey<BitSetResource> {
        private BeforeSyncRequestStep() {
        }

        @Override
        public boolean invoke(Session s) {
            BitSetResource resource = s.getResource(this);
            resource.clear(s.currentSequence().index());
            return true;
        }

        @Override
        public void reserve(Session session) {
            int concurrency = session.currentSequence().definition().concurrency();
            session.declareResource(this, () -> new BitSetResource(concurrency), true);
        }
    }

    @Name(value="httpRequest")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private int stepId = -1;
        private HttpMethodBuilder method;
        private StringGeneratorBuilder authority;
        private StringGeneratorBuilder path;
        private BodyGeneratorBuilder body;
        private final List<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> headerAppenders = new ArrayList<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>>();
        private boolean injectHostHeader = true;
        private SerializableBiFunction<String, String, String> metricSelector;
        private long timeout = Long.MIN_VALUE;
        private final HttpResponseHandlersImpl.Builder handler = new HttpResponseHandlersImpl.Builder(this);
        private boolean sync = true;
        private SLABuilder.ListBuilder<Builder> sla = null;
        private CompensationBuilder compensation;
        private CompressionBuilder compression = new CompressionBuilder(this);

        public Builder method(HttpMethod method) {
            return this.method(() -> new HttpMethodBuilder.Provided(method));
        }

        public Builder method(HttpMethodBuilder method) {
            this.method = method;
            return this;
        }

        public Builder GET(String path) {
            return this.method(HttpMethod.GET).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> GET() {
            return this.method(HttpMethod.GET).path();
        }

        public Builder HEAD(String path) {
            return this.method(HttpMethod.HEAD).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> HEAD() {
            return this.method(HttpMethod.HEAD).path();
        }

        public Builder POST(String path) {
            return this.method(HttpMethod.POST).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> POST() {
            return this.method(HttpMethod.POST).path();
        }

        public Builder PUT(String path) {
            return this.method(HttpMethod.PUT).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> PUT() {
            return this.method(HttpMethod.PUT).path();
        }

        public Builder DELETE(String path) {
            return this.method(HttpMethod.DELETE).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> DELETE() {
            return this.method(HttpMethod.DELETE).path();
        }

        public Builder OPTIONS(String path) {
            return this.method(HttpMethod.OPTIONS).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> OPTIONS() {
            return this.method(HttpMethod.OPTIONS).path();
        }

        public Builder PATCH(String path) {
            return this.method(HttpMethod.PATCH).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> PATCH() {
            return this.method(HttpMethod.PATCH).path();
        }

        public Builder TRACE(String path) {
            return this.method(HttpMethod.TRACE).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> TRACE() {
            return this.method(HttpMethod.TRACE).path();
        }

        public Builder CONNECT(String path) {
            return this.method(HttpMethod.CONNECT).path().pattern(path).end();
        }

        public StringGeneratorImplBuilder<Builder> CONNECT() {
            return this.method(HttpMethod.CONNECT).path();
        }

        public Builder authority(String authority) {
            return this.authority(() -> new Pattern(authority, false));
        }

        public Builder authority(SerializableFunction<Session, String> authorityGenerator) {
            return this.authority(() -> authorityGenerator);
        }

        public StringGeneratorImplBuilder<Builder> authority() {
            StringGeneratorImplBuilder<Builder> builder = new StringGeneratorImplBuilder<Builder>(this, false);
            this.authority(builder);
            return builder;
        }

        public Builder authority(StringGeneratorBuilder authority) {
            this.authority = authority;
            return this;
        }

        StringGeneratorBuilder getAuthority() {
            return this.authority;
        }

        public Builder path(String path) {
            return this.path(() -> new Pattern(path, false));
        }

        public StringGeneratorImplBuilder<Builder> path() {
            StringGeneratorImplBuilder<Builder> builder = new StringGeneratorImplBuilder<Builder>(this, false);
            this.path(builder);
            return builder;
        }

        public Builder path(SerializableFunction<Session, String> pathGenerator) {
            return this.path(() -> pathGenerator);
        }

        public Builder path(StringGeneratorBuilder builder) {
            if (this.path != null) {
                throw new BenchmarkDefinitionException("Path generator already set.");
            }
            this.path = builder;
            return this;
        }

        public Builder body(String string) {
            return this.body().pattern(string).endBody();
        }

        public BodyBuilder body() {
            return new BodyBuilder(this);
        }

        public Builder body(SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator) {
            return this.body(() -> bodyGenerator);
        }

        public Builder body(BodyGeneratorBuilder bodyGenerator) {
            if (this.body != null) {
                throw new BenchmarkDefinitionException("Body generator already set.");
            }
            this.body = bodyGenerator;
            return this;
        }

        BodyGeneratorBuilder bodyBuilder() {
            return this.body;
        }

        public Builder headerAppender(SerializableBiConsumer<Session, HttpRequestWriter> headerAppender) {
            this.headerAppenders.add(() -> headerAppender);
            return this;
        }

        public Builder headerAppenders(Collection<? extends Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> appenders) {
            this.headerAppenders.addAll(appenders);
            return this;
        }

        List<Supplier<SerializableBiConsumer<Session, HttpRequestWriter>>> headerAppenders() {
            return Collections.unmodifiableList(this.headerAppenders);
        }

        public HeadersBuilder headers() {
            return new HeadersBuilder(this);
        }

        public Builder timeout(long timeout, TimeUnit timeUnit) {
            if (timeout <= 0L) {
                throw new BenchmarkDefinitionException("Timeout must be positive!");
            }
            if (this.timeout != Long.MIN_VALUE) {
                throw new BenchmarkDefinitionException("Timeout already set!");
            }
            this.timeout = timeUnit.toMillis(timeout);
            return this;
        }

        public Builder timeout(String timeout) {
            return this.timeout(Util.parseToMillis(timeout), TimeUnit.MILLISECONDS);
        }

        public Builder metric(String name) {
            return this.metric(new ProvidedMetricSelector(name));
        }

        public Builder metric(SerializableBiFunction<String, String, String> selector) {
            this.metricSelector = selector;
            return this;
        }

        public PathMetricSelector metric() {
            PathMetricSelector selector;
            this.metricSelector = selector = new PathMetricSelector();
            return selector;
        }

        public HttpResponseHandlersImpl.Builder handler() {
            return this.handler;
        }

        public Builder sync(boolean sync) {
            this.sync = sync;
            return this;
        }

        public SLABuilder.ListBuilder<Builder> sla() {
            if (this.sla == null) {
                this.sla = new SLABuilder.ListBuilder<Builder>(this);
            }
            return this.sla;
        }

        public CompensationBuilder compensation() {
            this.compensation = new CompensationBuilder(this);
            return this.compensation;
        }

        public Builder compression(String encoding) {
            this.compression().encoding(encoding);
            return this;
        }

        public CompressionBuilder compression() {
            return this.compression;
        }

        @Override
        public int id() {
            assert (this.stepId >= 0);
            return this.stepId;
        }

        @Override
        public void prepareBuild() {
            this.stepId = StatisticsStep.nextId();
            Locator locator = Locator.current();
            HttpErgonomics ergonomics = locator.benchmark().plugin(HttpPluginBuilder.class).ergonomics();
            if (ergonomics.repeatCookies()) {
                this.headerAppender(new CookieAppender());
            }
            if (ergonomics.userAgentFromSession()) {
                this.headerAppender(new UserAgentAppender());
            }
            if (this.sync) {
                BeforeSyncRequestStep beforeSyncRequestStep = new BeforeSyncRequestStep();
                locator.sequence().insertBefore(locator).step(beforeSyncRequestStep);
                this.handler.onCompletion(new ReleaseSyncAction(beforeSyncRequestStep));
                locator.sequence().insertAfter(locator).step(new AfterSyncRequestStep(beforeSyncRequestStep));
            }
            if (this.metricSelector == null) {
                String sequenceName = Locator.current().sequence().name();
                this.metricSelector = new ProvidedMetricSelector(sequenceName);
            }
            if (this.compensation != null) {
                this.compensation.prepareBuild();
            }
            this.compression.prepareBuild();
            this.handler.prepareBuild();
        }

        @Override
        public List<Step> build() {
            String guessedAuthority = null;
            boolean checkAuthority = true;
            SerializableFunction<Session, String> authority = this.authority != null ? this.authority.build() : null;
            SerializableFunction<Session, String> pathGenerator = this.path != null ? this.path.build() : null;
            try {
                guessedAuthority = authority == null ? null : (String)authority.apply(null);
            }
            catch (Throwable e) {
                checkAuthority = false;
            }
            if (checkAuthority && !Locator.current().benchmark().plugin(HttpPluginBuilder.class).validateAuthority(guessedAuthority)) {
                String guessedPath = "<unknown path>";
                try {
                    if (pathGenerator != null) {
                        guessedPath = (String)pathGenerator.apply(null);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (authority == null) {
                    throw new BenchmarkDefinitionException(String.format("%s to <default route>%s is invalid as we don't have a default route set.", this.method, guessedPath));
                }
                if (!guessedAuthority.contains(":")) {
                    throw new BenchmarkDefinitionException(String.format("%s to %s%s is invalid - did you forget the port number?.", this.method, guessedAuthority, guessedPath));
                }
                throw new BenchmarkDefinitionException(String.format("%s to %s%s is invalid - no HTTP configuration defined.", this.method, guessedAuthority, guessedPath));
            }
            SerializableBiConsumer[] headerAppenders = this.headerAppenders.isEmpty() ? null : (SerializableBiConsumer[])this.headerAppenders.stream().map(Supplier::get).toArray(SerializableBiConsumer[]::new);
            SLA[] sla = this.sla != null ? this.sla.build() : SLABuilder.DEFAULT;
            SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator = this.body != null ? this.body.build() : null;
            HttpRequestStep step = new HttpRequestStep(this.stepId, this.method.build(), authority, pathGenerator, bodyGenerator, headerAppenders, this.injectHostHeader, this.metricSelector, this.timeout, this.handler.build(), sla);
            return Collections.singletonList(step);
        }

        private static class ReleaseSyncAction
        implements Action {
            @Visitor.Ignore
            private final BeforeSyncRequestStep beforeSyncRequestStep;

            public ReleaseSyncAction(BeforeSyncRequestStep beforeSyncRequestStep) {
                this.beforeSyncRequestStep = beforeSyncRequestStep;
            }

            @Override
            public void run(Session s) {
                s.getResource(this.beforeSyncRequestStep).set(s.currentSequence().index());
            }
        }

        private static class PrefixMetricSelector
        implements SerializableBiFunction<String, String, String> {
            private final String prefix;
            private final SerializableBiFunction<String, String, String> delegate;

            private PrefixMetricSelector(String prefix, SerializableBiFunction<String, String, String> delegate) {
                this.prefix = prefix;
                this.delegate = delegate;
            }

            @Override
            public String apply(String authority, String path) {
                return this.prefix + (String)this.delegate.apply(authority, path);
            }
        }

        private static class ProvidedMetricSelector
        implements SerializableBiFunction<String, String, String> {
            private final String name;

            private ProvidedMetricSelector(String name) {
                this.name = name;
            }

            @Override
            public String apply(String authority, String path) {
                return this.name;
            }
        }
    }
}

