/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.processor.HttpRequestProcessorBuilder;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.session.Access;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.SessionStopException;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.handlers.ConditionalAction;
import io.hyperfoil.core.handlers.ConditionalProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.steps.AwaitDelayStep;
import io.hyperfoil.core.steps.PushQueueAction;
import io.hyperfoil.core.steps.ScheduleDelayStep;
import io.hyperfoil.core.util.Unique;
import io.hyperfoil.function.SerializableToLongFunction;
import io.hyperfoil.http.api.FollowRedirect;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpCache;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpResponseHandlers;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.config.HttpErgonomics;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.cookie.CookieRecorder;
import io.hyperfoil.http.handlers.ConditionalHeaderHandler;
import io.hyperfoil.http.handlers.Location;
import io.hyperfoil.http.handlers.RangeStatusValidator;
import io.hyperfoil.http.handlers.Redirect;
import io.hyperfoil.http.html.HtmlHandler;
import io.hyperfoil.http.html.MetaRefreshHandler;
import io.hyperfoil.http.html.RefreshHandler;
import io.hyperfoil.http.steps.HttpRequestStep;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;

public class HttpResponseHandlersImpl
implements HttpResponseHandlers,
ResourceUtilizer,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseHandlersImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    final StatusHandler[] statusHandlers;
    final HeaderHandler[] headerHandlers;
    final Processor[] bodyHandlers;
    final Action[] completionHandlers;
    final RawBytesHandler[] rawBytesHandlers;

    private HttpResponseHandlersImpl(StatusHandler[] statusHandlers, HeaderHandler[] headerHandlers, Processor[] bodyHandlers, Action[] completionHandlers, RawBytesHandler[] rawBytesHandlers) {
        this.statusHandlers = statusHandlers;
        this.headerHandlers = headerHandlers;
        this.bodyHandlers = bodyHandlers;
        this.completionHandlers = completionHandlers;
        this.rawBytesHandlers = rawBytesHandlers;
    }

    @Override
    public void handleStatus(HttpRequest request, int status, String reason) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace((Object)"#{} Ignoring status {} as the request has been marked completed (failed).", new Object[]{session.uniqueId(), status});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Received status {}: {}", new Object[]{session.uniqueId(), status, reason});
        }
        try {
            switch (request.method) {
                case GET: 
                case HEAD: {
                    if (status == 200) break;
                    request.cacheControl.noStore = true;
                    break;
                }
                case POST: 
                case PUT: 
                case DELETE: 
                case PATCH: {
                    if (status >= 200 && status <= 399) {
                        HttpCache.get(request.session).invalidate(request.authority, request.path);
                        request.cacheControl.invalidate = true;
                    }
                    request.cacheControl.noStore = true;
                }
            }
            request.statistics().addStatus(request.startTimestampMillis(), status);
            if (this.statusHandlers != null) {
                for (Serializable serializable : this.statusHandlers) {
                    serializable.handleStatus(request, status);
                }
            }
            if (this.headerHandlers != null) {
                for (Serializable serializable : this.headerHandlers) {
                    serializable.beforeHeaders(request);
                }
            }
            if (this.bodyHandlers != null) {
                for (Serializable serializable : this.bodyHandlers) {
                    serializable.before(request.session);
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Response status processing failed on {}", t, new Object[]{session.uniqueId(), this});
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace((Object)"#{} Ignoring header on a failed request: {}: {}", new Object[]{session.uniqueId(), header, value});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Received header {}: {}", new Object[]{session.uniqueId(), header, value});
        }
        try {
            HttpCache httpCache = HttpCache.get(session);
            if (request.cacheControl.invalidate && (AsciiString.contentEqualsIgnoreCase((CharSequence)header, (CharSequence)HttpHeaderNames.LOCATION) || AsciiString.contentEqualsIgnoreCase((CharSequence)header, (CharSequence)HttpHeaderNames.CONTENT_LOCATION))) {
                httpCache.invalidate(request.authority, value);
            }
            if (this.headerHandlers != null) {
                for (HeaderHandler handler : this.headerHandlers) {
                    handler.handleHeader(request, header, value);
                }
            }
            httpCache.responseHeader(request, header, value);
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Response header processing failed on {}", t, new Object[]{session.uniqueId(), this});
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleThrowable(HttpRequest request, Throwable throwable) {
        Session session = request.session;
        if (trace) {
            log.trace((Object)"#{} {} Received exception", throwable, new Object[]{session.uniqueId(), request});
        }
        if (request.isCompleted()) {
            if (trace) {
                log.trace((Object)"#{} Request has been already completed", new Object[]{session.uniqueId()});
            }
            return;
        }
        if (request.isValid()) {
            request.markInvalid();
        }
        try {
            if (request.isRunning()) {
                request.statistics().incrementResets(request.startTimestampMillis());
                request.setCompleting();
                if (this.completionHandlers != null) {
                    for (Action handler : this.completionHandlers) {
                        handler.run(session);
                    }
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            t.addSuppressed(throwable);
            log.error((Object)"#{} Exception {} thrown while handling another exception: ", t, new Object[]{session.uniqueId(), throwable.toString()});
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            session.stop();
        }
        finally {
            request.setCompleted();
        }
    }

    @Override
    public void handleBodyPart(HttpRequest request, ByteBuf data, int offset, int length, boolean isLastPart) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace((Object)"#{} Ignoring body part ({} bytes) on a failed request.", new Object[]{session.uniqueId(), data.readableBytes()});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Received part ({} bytes):\n{}", new Object[]{session.uniqueId(), length, data.toString(offset, length, StandardCharsets.UTF_8)});
        }
        try {
            int dataStartIndex = data.readerIndex();
            if (this.bodyHandlers != null) {
                for (Processor handler : this.bodyHandlers) {
                    handler.process(request.session, data, offset, length, isLastPart);
                    data.readerIndex(dataStartIndex);
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Response body processing failed on {}", t, new Object[]{session.uniqueId(), this});
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleEnd(HttpRequest request, boolean executed) {
        Session session = request.session;
        if (request.isCompleted()) {
            if (trace) {
                log.trace((Object)"#{} Request has been already completed.", new Object[]{session.uniqueId()});
            }
            return;
        }
        if (trace) {
            log.trace((Object)"#{} Completed request on {}", new Object[]{session.uniqueId(), request.connection()});
        }
        try {
            if (executed) {
                request.recordResponse(System.nanoTime());
                if (this.headerHandlers != null) {
                    for (Serializable serializable : this.headerHandlers) {
                        serializable.afterHeaders(request);
                    }
                }
                if (this.bodyHandlers != null) {
                    for (Serializable serializable : this.bodyHandlers) {
                        serializable.after(request.session);
                    }
                }
                HttpCache.get(request.session).tryStore(request);
            }
            if (request.isRunning()) {
                request.setCompleting();
                if (this.completionHandlers != null) {
                    for (Serializable serializable : this.completionHandlers) {
                        serializable.run(session);
                    }
                }
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Response completion failed on {}, stopping the session.", t, new Object[]{request.session.uniqueId(), this});
            request.statistics().incrementInternalErrors(request.startTimestampMillis());
            request.markInvalid();
            session.stop();
        }
        finally {
            if (executed && !request.isValid() && !request.isCompleted()) {
                request.statistics().addInvalid(request.startTimestampMillis());
            }
            request.setCompleted();
        }
    }

    @Override
    public void handleRawRequest(HttpRequest request, ByteBuf data, int offset, int length) {
        if (this.rawBytesHandlers == null) {
            return;
        }
        try {
            for (RawBytesHandler rawBytesHandler : this.rawBytesHandlers) {
                rawBytesHandler.onRequest(request, data, offset, length);
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Raw request processing failed on {}", t, new Object[]{request.session.uniqueId(), this});
            request.markInvalid();
            request.session.stop();
        }
    }

    @Override
    public void handleRawResponse(HttpRequest request, ByteBuf data, int offset, int length, boolean isLastPart) {
        if (this.rawBytesHandlers == null) {
            return;
        }
        try {
            for (RawBytesHandler rawBytesHandler : this.rawBytesHandlers) {
                rawBytesHandler.onResponse(request, data, offset, length, isLastPart);
            }
        }
        catch (SessionStopException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error((Object)"#{} Raw response processing failed on {}", t, new Object[]{request.session.uniqueId(), this});
            request.markInvalid();
            request.session.stop();
        }
    }

    @Override
    public void reserve(Session session) {
        ResourceUtilizer.reserve(session, this.statusHandlers);
        ResourceUtilizer.reserve(session, this.headerHandlers);
        ResourceUtilizer.reserve(session, this.bodyHandlers);
        ResourceUtilizer.reserve(session, this.completionHandlers);
        ResourceUtilizer.reserve(session, this.rawBytesHandlers);
    }

    private static class StopOnInvalidAction
    implements Action {
        private static final Action INSTANCE = new StopOnInvalidAction();

        private StopOnInvalidAction() {
        }

        @Override
        public void run(Session session) {
            if (!session.currentRequest().isValid()) {
                session.stop();
            }
        }
    }

    public static class Builder
    implements Rewritable<Builder> {
        private final HttpRequestStep.Builder parent;
        private Boolean autoRangeCheck;
        private Boolean stopOnInvalid;
        private FollowRedirect followRedirect;
        private List<StatusHandler.Builder> statusHandlers = new ArrayList<StatusHandler.Builder>();
        private List<HeaderHandler.Builder> headerHandlers = new ArrayList<HeaderHandler.Builder>();
        private List<HttpRequestProcessorBuilder> bodyHandlers = new ArrayList<HttpRequestProcessorBuilder>();
        private List<Action.Builder> completionHandlers = new ArrayList<Action.Builder>();
        private List<RawBytesHandler.Builder> rawBytesHandlers = new ArrayList<RawBytesHandler.Builder>();

        public static Builder forTesting() {
            return new Builder(null);
        }

        Builder(HttpRequestStep.Builder parent) {
            this.parent = parent;
        }

        public Builder status(StatusHandler.Builder builder) {
            this.statusHandlers.add(builder);
            return this;
        }

        public Builder status(StatusHandler handler) {
            this.statusHandlers.add(() -> handler);
            return this;
        }

        public ServiceLoadedBuilderProvider<StatusHandler.Builder> status() {
            return new ServiceLoadedBuilderProvider<StatusHandler.Builder>(StatusHandler.Builder.class, this.statusHandlers::add);
        }

        public Builder header(HeaderHandler handler) {
            return this.header(() -> handler);
        }

        public Builder header(HeaderHandler.Builder builder) {
            this.headerHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<HeaderHandler.Builder> header() {
            return new ServiceLoadedBuilderProvider<HeaderHandler.Builder>(HeaderHandler.Builder.class, this.headerHandlers::add);
        }

        public Builder body(HttpRequestProcessorBuilder builder) {
            this.bodyHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder> body() {
            return new ServiceLoadedBuilderProvider<HttpRequestProcessorBuilder>(HttpRequestProcessorBuilder.class, this.bodyHandlers::add);
        }

        public Builder onCompletion(Action handler) {
            return this.onCompletion(() -> handler);
        }

        public Builder onCompletion(Action.Builder builder) {
            this.completionHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<Action.Builder> onCompletion() {
            return new ServiceLoadedBuilderProvider<Action.Builder>(Action.Builder.class, this.completionHandlers::add);
        }

        public Builder rawBytes(RawBytesHandler handler) {
            this.rawBytesHandlers.add(() -> handler);
            return this;
        }

        public Builder rawBytes(RawBytesHandler.Builder builder) {
            this.rawBytesHandlers.add(builder);
            return this;
        }

        public ServiceLoadedBuilderProvider<RawBytesHandler.Builder> rawBytes() {
            return new ServiceLoadedBuilderProvider<RawBytesHandler.Builder>(RawBytesHandler.Builder.class, this::rawBytes);
        }

        public Builder autoRangeCheck(boolean autoRangeCheck) {
            this.autoRangeCheck = autoRangeCheck;
            return this;
        }

        public Builder stopOnInvalid(boolean stopOnInvalid) {
            this.stopOnInvalid = stopOnInvalid;
            return this;
        }

        public Builder followRedirect(FollowRedirect followRedirect) {
            this.followRedirect = followRedirect;
            return this;
        }

        public HttpRequestStep.Builder endHandler() {
            return this.parent;
        }

        public Builder wrapBodyHandlers(Function<Collection<HttpRequestProcessorBuilder>, HttpRequestProcessorBuilder> func) {
            HttpRequestProcessorBuilder wrapped = func.apply(this.bodyHandlers);
            this.bodyHandlers = new ArrayList<HttpRequestProcessorBuilder>();
            this.bodyHandlers.add(wrapped);
            return this;
        }

        public void prepareBuild() {
            HttpErgonomics ergonomics = Locator.current().benchmark().plugin(HttpPluginBuilder.class).ergonomics();
            if (ergonomics.repeatCookies()) {
                this.header(new CookieRecorder());
            }
            this.statusHandlers.forEach(BuilderBase::prepareBuild);
            this.headerHandlers.forEach(BuilderBase::prepareBuild);
            this.bodyHandlers.forEach(BuilderBase::prepareBuild);
            this.completionHandlers.forEach(BuilderBase::prepareBuild);
            this.rawBytesHandlers.forEach(BuilderBase::prepareBuild);
            if (this.autoRangeCheck != null ? this.autoRangeCheck != false : ergonomics.autoRangeCheck()) {
                this.statusHandlers.add(new RangeStatusValidator.Builder().min(200).max(399));
            }
            if (this.stopOnInvalid != null ? this.stopOnInvalid != false : ergonomics.stopOnInvalid()) {
                this.completionHandlers.add(() -> StopOnInvalidAction.INSTANCE);
            }
            FollowRedirect followRedirect = this.followRedirect != null ? this.followRedirect : ergonomics.followRedirect();
            switch (followRedirect) {
                case LOCATION_ONLY: {
                    this.applyRedirect(true, false);
                    break;
                }
                case HTML_ONLY: {
                    this.applyRedirect(false, true);
                    break;
                }
                case ALWAYS: {
                    this.applyRedirect(true, true);
                }
            }
        }

        private void applyRedirect(boolean location, boolean html) {
            Locator locator = Locator.current();
            Unique coordsVar = new Unique();
            String redirectSequenceName = String.format("%s_redirect_%08x", locator.sequence().name(), ThreadLocalRandom.current().nextInt());
            String delaySequenceName = String.format("%s_delay_%08x", locator.sequence().name(), ThreadLocalRandom.current().nextInt());
            Queue.Key queueKey = new Queue.Key();
            Queue.Key delayedQueueKey = new Queue.Key();
            Unique delayedCoordVar = new Unique();
            int concurrency = Math.max(1, locator.sequence().rootSequence().concurrency());
            if (html) {
                Unique delay = new Unique();
                SequenceBuilder delaySequence = locator.scenario().sequence(delaySequenceName);
                delaySequence.concurrency(Math.max(1, concurrency)).step(() -> {
                    Access inputVar = SessionFactory.sequenceScopedAccess(delayedCoordVar);
                    Access delayVar = SessionFactory.sequenceScopedAccess(delay);
                    SerializableToLongFunction delayFunc = session -> TimeUnit.SECONDS.toMillis(((Redirect.Coords)inputVar.getObject((Session)session)).delay);
                    return new ScheduleDelayStep(delayVar, ScheduleDelayStep.Type.FROM_NOW, delayFunc);
                }).step(() -> new AwaitDelayStep(SessionFactory.sequenceScopedAccess(delay))).stepBuilder(new StepBuilder.ActionAdapter(() -> new PushQueueAction(SessionFactory.sequenceScopedAccess(delayedCoordVar), queueKey))).step(session -> {
                    session.getResource(delayedQueueKey).consumed(session);
                    return true;
                });
                Locator.push(null, delaySequence);
                delaySequence.prepareBuild();
                Locator.pop();
            }
            int redirectConcurrency = 2 * concurrency;
            LimitedPoolResource.Key<Redirect.Coords> poolKey = new LimitedPoolResource.Key<Redirect.Coords>();
            Unique newTempCoordsVar = new Unique(true);
            HttpRequestStep.BodyGeneratorBuilder bodyBuilder = this.parent.bodyBuilder();
            HttpRequestStep.Builder httpRequest = new HttpRequestStep.Builder().method(() -> new Redirect.GetMethod(SessionFactory.sequenceScopedAccess(coordsVar))).path(() -> new Location.GetPath(SessionFactory.sequenceScopedAccess(coordsVar))).authority(() -> new Location.GetAuthority(SessionFactory.sequenceScopedAccess(coordsVar))).headerAppenders(this.parent.headerAppenders()).body(bodyBuilder == null ? null : (HttpRequestStep.BodyGeneratorBuilder)bodyBuilder.copy()).sync(false).handler().followRedirect(FollowRedirect.NEVER).endHandler();
            if (location) {
                httpRequest.handler().status((StatusHandler.Builder)new Redirect.StatusHandler.Builder().poolKey(poolKey).concurrency(redirectConcurrency).coordsVar(newTempCoordsVar).handlers(this.statusHandlers)).header(new Redirect.LocationRecorder.Builder().originalSequenceSupplier(() -> new Redirect.GetOriginalSequence(SessionFactory.sequenceScopedAccess(coordsVar))).concurrency(redirectConcurrency).inputVar(newTempCoordsVar).outputVar(coordsVar).queueKey(queueKey).sequence(redirectSequenceName));
            }
            if (!this.headerHandlers.isEmpty()) {
                Redirect.WrappingHeaderHandler.Builder wrappingHandler = (Redirect.WrappingHeaderHandler.Builder)new Redirect.WrappingHeaderHandler.Builder().coordVar(coordsVar).handlers(this.headerHandlers);
                if (location) {
                    httpRequest.handler().header((HeaderHandler.Builder)((ConditionalHeaderHandler.Builder)new ConditionalHeaderHandler.Builder().condition().stringCondition().fromVar(newTempCoordsVar).isSet(false).end()).handler(wrappingHandler));
                } else {
                    httpRequest.handler().header(wrappingHandler);
                }
            }
            if (!this.bodyHandlers.isEmpty() || html) {
                Consumer<HttpRequestProcessorBuilder> handlerConsumer;
                Redirect.WrappingProcessor.Builder wrappingProcessor = (Redirect.WrappingProcessor.Builder)new Redirect.WrappingProcessor.Builder().coordVar(coordsVar).processors(this.bodyHandlers);
                if (location) {
                    if (!this.bodyHandlers.isEmpty() || html) {
                        ConditionalProcessor.Builder conditionalBodyHandler = ((ConditionalProcessor.Builder)new ConditionalProcessor.Builder().condition().stringCondition().fromVar(newTempCoordsVar).isSet(false).end()).processor(wrappingProcessor);
                        handlerConsumer = conditionalBodyHandler::processor;
                        httpRequest.handler().body(HttpRequestProcessorBuilder.adapt(conditionalBodyHandler));
                    } else {
                        handlerConsumer = null;
                    }
                } else {
                    assert (html);
                    httpRequest.handler().body(HttpRequestProcessorBuilder.adapt(wrappingProcessor));
                    handlerConsumer = httpRequest.handler()::body;
                }
                if (html) {
                    handlerConsumer.accept(new HtmlHandler.Builder().handler(new MetaRefreshHandler.Builder().processor(fragmented -> new RefreshHandler(queueKey, delayedQueueKey, poolKey, redirectConcurrency, SessionFactory.access(coordsVar), SessionFactory.access(delayedCoordVar), redirectSequenceName, delaySequenceName, SessionFactory.access(newTempCoordsVar), new Redirect.GetOriginalSequence(SessionFactory.sequenceScopedAccess(coordsVar))))));
                }
            }
            if (!this.completionHandlers.isEmpty()) {
                httpRequest.handler().onCompletion((Action.Builder)((ConditionalAction.Builder)new ConditionalAction.Builder().condition().stringCondition().fromVar(newTempCoordsVar).isSet(false).end()).action((Action.Builder)new Redirect.WrappingAction.Builder().coordVar(coordsVar).actions(this.completionHandlers)));
            }
            httpRequest.handler().onCompletion(() -> new Location.Complete(poolKey, queueKey, SessionFactory.sequenceScopedAccess(coordsVar)));
            SequenceBuilder redirectSequence = locator.scenario().sequence(redirectSequenceName).concurrency(redirectConcurrency).stepBuilder(httpRequest).rootSequence();
            Locator.push(null, redirectSequence);
            redirectSequence.prepareBuild();
            Locator.pop();
            Unique tempCoordsVar = new Unique(locator.sequence().rootSequence().concurrency() > 0);
            if (location) {
                this.statusHandlers = Collections.singletonList(new Redirect.StatusHandler.Builder().poolKey(poolKey).concurrency(redirectConcurrency).coordsVar(tempCoordsVar).handlers(this.statusHandlers));
                ArrayList<HeaderHandler.Builder> headerHandlers = new ArrayList<HeaderHandler.Builder>();
                headerHandlers.add(new Redirect.LocationRecorder.Builder().originalSequenceSupplier(() -> Session::currentSequence).concurrency(redirectConcurrency).inputVar(tempCoordsVar).outputVar(coordsVar).queueKey(queueKey).sequence(redirectSequenceName));
                if (!this.headerHandlers.isEmpty()) {
                    headerHandlers.add((HeaderHandler.Builder)((ConditionalHeaderHandler.Builder)new ConditionalHeaderHandler.Builder().condition().stringCondition().fromVar(tempCoordsVar).isSet(false).end()).handlers(this.headerHandlers));
                }
                this.headerHandlers = headerHandlers;
            }
            if (!this.bodyHandlers.isEmpty() || html) {
                Consumer<HttpRequestProcessorBuilder> handlerConsumer;
                ConditionalProcessor.Builder conditionalBodyHandler = null;
                if (location) {
                    conditionalBodyHandler = ((ConditionalProcessor.Builder)new ConditionalProcessor.Builder().condition().stringCondition().fromVar(tempCoordsVar).isSet(false).end()).processors(this.bodyHandlers);
                    handlerConsumer = conditionalBodyHandler::processor;
                } else {
                    handlerConsumer = this.bodyHandlers::add;
                }
                if (html) {
                    handlerConsumer.accept(new HtmlHandler.Builder().handler(new MetaRefreshHandler.Builder().processor(fragmented -> new RefreshHandler(queueKey, delayedQueueKey, poolKey, redirectConcurrency, SessionFactory.access(coordsVar), SessionFactory.access(delayedCoordVar), redirectSequenceName, delaySequenceName, SessionFactory.access(tempCoordsVar), Session::currentSequence))));
                }
                if (location) {
                    this.bodyHandlers = Collections.singletonList(HttpRequestProcessorBuilder.adapt(conditionalBodyHandler));
                }
            }
            if (!this.completionHandlers.isEmpty()) {
                this.completionHandlers = Collections.singletonList(((ConditionalAction.Builder)new ConditionalAction.Builder().condition().stringCondition().fromVar(tempCoordsVar).isSet(false).end()).actions(this.completionHandlers));
            }
        }

        public HttpResponseHandlersImpl build() {
            return new HttpResponseHandlersImpl(Builder.toArray(this.statusHandlers, StatusHandler.Builder::build, StatusHandler[]::new), Builder.toArray(this.headerHandlers, HeaderHandler.Builder::build, HeaderHandler[]::new), Builder.toArray(this.bodyHandlers, b -> b.build(true), Processor[]::new), Builder.toArray(this.completionHandlers, Action.Builder::build, Action[]::new), Builder.toArray(this.rawBytesHandlers, RawBytesHandler.Builder::build, RawBytesHandler[]::new));
        }

        private static <B, T> T[] toArray(List<B> list, Function<B, T> build, IntFunction<T[]> generator) {
            if (list.isEmpty()) {
                return null;
            }
            return list.stream().map(build).toArray(generator);
        }

        @Override
        public void readFrom(Builder other) {
            this.statusHandlers.addAll(BuilderBase.copy(other.statusHandlers));
            this.headerHandlers.addAll(BuilderBase.copy(other.headerHandlers));
            this.bodyHandlers.addAll(BuilderBase.copy(other.bodyHandlers));
            this.completionHandlers.addAll(BuilderBase.copy(other.completionHandlers));
            this.rawBytesHandlers.addAll(BuilderBase.copy(other.rawBytesHandlers));
            this.autoRangeCheck = other.autoRangeCheck;
            this.stopOnInvalid = other.stopOnInvalid;
            this.followRedirect = other.followRedirect;
        }
    }
}

