/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil;

import io.hyperfoil.HyperfoilChannelLookup;
import io.hyperfoil.api.Version;
import io.hyperfoil.clustering.AgentVerticle;
import io.hyperfoil.clustering.Codecs;
import io.hyperfoil.clustering.ControllerVerticle;
import io.hyperfoil.internal.Properties;
import io.netty.util.ResourceLeakDetector;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;

public class Hyperfoil {
    static final Logger log = LoggerFactory.getLogger(Hyperfoil.class);
    private static final Set<String> LOCALHOST_IPS = new HashSet<String>(Arrays.asList("127.0.0.1", "::1", "[::1]"));

    public static void clusteredVertx(boolean isController, Handler<Vertx> startedHandler, Runnable onError) {
        Hyperfoil.logVersion();
        Thread.setDefaultUncaughtExceptionHandler(Hyperfoil::defaultUncaughtExceptionHandler);
        log.info((Object)"Starting Vert.x...");
        VertxOptions options = new VertxOptions();
        options.getEventBusOptions().setClustered(true);
        try {
            InetAddress address;
            String clusterIp = Properties.get((String)"io.hyperfoil.controller.cluster.ip", null);
            if (isController && clusterIp != null) {
                address = InetAddress.getByName(clusterIp);
            } else {
                address = InetAddress.getLocalHost();
                if (!isController && LOCALHOST_IPS.contains(address.getHostAddress())) {
                    InetAddress bestMatch = Hyperfoil.getAddressWithBestMatch(InetAddress.getByName(clusterIp));
                    if (bestMatch != null) {
                        address = bestMatch;
                    } else {
                        log.warn((Object)"No match found between controller IP and local addresses.");
                    }
                }
            }
            String hostName = address.getHostName();
            String hostAddress = address.getHostAddress();
            log.info((Object)"Using host name {}/{}", new Object[]{hostName, hostAddress});
            if (LOCALHOST_IPS.contains(hostAddress) && clusterIp == null) {
                log.error((Object)"This machine is configured to resolve its hostname to 127.0.0.1; this is an invalid configuration for clustering. Make sure `hostname -i` does not return 127.0.0.1 or ::1  or set -Dio.hyperfoil.controller.cluster.ip=x.x.x.x to use different address. (if you set that to 127.0.0.1 you won't be able to connect from agents on other machines).");
                onError.run();
            }
            options.getEventBusOptions().setHost(hostAddress).setClusterPublicHost(hostAddress);
            if (System.getProperty("jgroups.tcp.address") == null) {
                System.setProperty("jgroups.tcp.address", hostAddress);
            }
            String clusterPort = Properties.get((String)"io.hyperfoil.controller.cluster.port", null);
            if (isController && clusterPort != null && System.getProperty("jgroups.tcp.port") == null) {
                System.setProperty("jgroups.tcp.port", clusterPort);
            }
        }
        catch (UnknownHostException e) {
            log.error((Object)"Cannot lookup hostname", (Throwable)e);
            onError.run();
        }
        DefaultCacheManager cacheManager = Hyperfoil.createCacheManager();
        options.setClusterManager((ClusterManager)new InfinispanClusterManager(cacheManager));
        Vertx.clusteredVertx((VertxOptions)options, result -> {
            if (result.failed()) {
                log.error((Object)"Cannot start Vert.x", result.cause());
                onError.run();
            }
            Vertx vertx = (Vertx)result.result();
            Codecs.register(vertx);
            startedHandler.handle((Object)vertx);
        });
        Hyperfoil.ensureNettyResourceLeakDetection();
    }

    private static InetAddress getAddressWithBestMatch(InetAddress controllerAddress) {
        InetAddress address = null;
        try {
            List allAddresses = Collections.list(NetworkInterface.getNetworkInterfaces()).stream().filter(nic -> {
                try {
                    return !nic.isLoopback() && nic.isUp();
                }
                catch (SocketException e) {
                    log.warn((Object)"Error enumerating NIC {}", (Throwable)e, new Object[]{nic});
                    return false;
                }
            }).flatMap(nic -> Collections.list(nic.getInetAddresses()).stream()).collect(Collectors.toList());
            log.info((Object)"Agent must choose NIC with best subnet match to controller ({}/{}), available IPs: {} (loopback is ignored)", new Object[]{controllerAddress.getHostName(), controllerAddress.getHostAddress(), allAddresses});
            int longestMatch = -1;
            BitSet controllerBits = BitSet.valueOf(controllerAddress.getAddress());
            for (InetAddress a : allAddresses) {
                int i;
                if (a.getAddress().length != controllerAddress.getAddress().length) {
                    log.debug((Object)"Ignoring {} as this has different address length", new Object[]{a});
                    continue;
                }
                BitSet aBits = BitSet.valueOf(a.getAddress());
                for (i = 0; i < aBits.length() && aBits.get(i) == controllerBits.get(i); ++i) {
                }
                log.debug((Object)"{} and {} have common prefix {} bits", new Object[]{controllerAddress, a, i});
                if (i <= longestMatch) continue;
                longestMatch = i;
                address = a;
            }
        }
        catch (SocketException e) {
            log.warn((Object)"Error enumerating NICs", (Throwable)e);
        }
        return address;
    }

    private static DefaultCacheManager createCacheManager() {
        DefaultCacheManager defaultCacheManager;
        block8: {
            InputStream stream = FileLookupFactory.newInstance().lookupFile("infinispan.xml", Thread.currentThread().getContextClassLoader());
            try {
                ConfigurationBuilderHolder holder = new ParserRegistry().parse(stream);
                holder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("channelLookup", HyperfoilChannelLookup.class.getName()).initialClusterSize(1);
                defaultCacheManager = new DefaultCacheManager(holder, true);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error((Object)"Cannot load Infinispan configuration");
                    System.exit(1);
                    return null;
                }
            }
            stream.close();
        }
        return defaultCacheManager;
    }

    static void deploy(Vertx vertx, Class<? extends Verticle> verticleClass) {
        log.info((Object)"Deploying {}...", new Object[]{verticleClass.getSimpleName()});
        vertx.deployVerticle(verticleClass, new DeploymentOptions(), event -> {
            if (event.succeeded()) {
                log.info((Object)"{} deployed.", new Object[]{verticleClass.getSimpleName()});
            } else {
                log.error((Object)"Failed to deploy {}.", event.cause(), new Object[]{verticleClass.getSimpleName()});
                System.exit(1);
            }
        });
    }

    static void ensureNettyResourceLeakDetection() {
        String leakDetectionLevel = System.getProperty("io.netty.leakDetection.level");
        if (leakDetectionLevel != null) {
            leakDetectionLevel = leakDetectionLevel.trim();
            for (ResourceLeakDetector.Level level : ResourceLeakDetector.Level.values()) {
                if (!leakDetectionLevel.equalsIgnoreCase(level.name()) && !leakDetectionLevel.equals(String.valueOf(level.ordinal()))) continue;
                ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)level);
                return;
            }
            log.warn((Object)"Cannot parse Netty leak detection level '{}', use one of: ", new Object[]{leakDetectionLevel, ResourceLeakDetector.Level.values()});
        }
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.SIMPLE);
    }

    public static void shutdownVertx(Vertx vertx, Handler<AsyncResult<Void>> handler) {
        ClusterManager clusterManager = ((VertxInternal)vertx).getClusterManager();
        DefaultCacheManager cacheManager = (DefaultCacheManager)((InfinispanClusterManager)clusterManager).getCacheContainer();
        vertx.close(result -> {
            try {
                cacheManager.close();
            }
            catch (IOException e) {
                log.error((Object)"Failed to close Infinispan cache manager", (Throwable)e);
            }
            finally {
                if (handler != null) {
                    handler.handle(result);
                }
            }
        });
    }

    private static void defaultUncaughtExceptionHandler(Thread thread, Throwable throwable) {
        log.error((Object)"Uncaught exception in thread {}({})", throwable, new Object[]{thread.getName(), thread.getId()});
    }

    private static void logVersion() {
        log.info((Object)"Java: {} {} {} {} ({})", new Object[]{System.getProperty("java.vm.vendor", "<unknown VM vendor>"), System.getProperty("java.vm.name", "<unknown VM name>"), System.getProperty("java.version", "<unknown version>"), System.getProperty("java.vm.version", "<unknown VM version>"), System.getProperty("java.home", "<unknown Java home>")});
        String path = new File(Hyperfoil.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile().getParent();
        log.info((Object)"Hyperfoil: {} ({})", new Object[]{Version.VERSION, Version.COMMIT_ID});
        log.info((Object)"           DISTRIBUTION:  {}", new Object[]{path});
        log.info((Object)"           ROOT_DIR:      {}", new Object[]{io.hyperfoil.internal.Controller.ROOT_DIR});
        log.info((Object)"           BENCHMARK_DIR: {}", new Object[]{io.hyperfoil.internal.Controller.BENCHMARK_DIR});
        log.info((Object)"           RUN_DIR:       {}", new Object[]{io.hyperfoil.internal.Controller.RUN_DIR});
        log.info((Object)"           HOOKS_DIR:     {}", new Object[]{io.hyperfoil.internal.Controller.HOOKS_DIR});
    }

    public static class Standalone
    extends Hyperfoil {
        public static void main(String[] args) {
            Hyperfoil.logVersion();
            Thread.setDefaultUncaughtExceptionHandler((x$0, x$1) -> Hyperfoil.defaultUncaughtExceptionHandler(x$0, x$1));
            log.info((Object)"Starting non-clustered Vert.x...");
            Vertx vertx = Vertx.vertx();
            Standalone.ensureNettyResourceLeakDetection();
            Codecs.register(vertx);
            Standalone.deploy(vertx, ControllerVerticle.class);
        }
    }

    public static class Controller
    extends Hyperfoil {
        public static void main(String[] args) {
            Controller.clusteredVertx(true, (Handler<Vertx>)((Handler)vertx -> Controller.deploy(vertx, ControllerVerticle.class)), () -> System.exit(1));
        }
    }

    public static class Agent
    extends Hyperfoil {
        public static void main(String[] args) {
            Agent.clusteredVertx(false, (Handler<Vertx>)((Handler)vertx -> Agent.deploy(vertx, AgentVerticle.class)), () -> System.exit(1));
        }
    }
}

