/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil;

import io.hyperfoil.internal.Properties;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.jgroups.JChannel;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TCPPING;
import org.jgroups.protocols.pbcast.GMS;

public class HyperfoilChannelLookup
implements JGroupsChannelLookup {
    private static final Logger log = LoggerFactory.getLogger(HyperfoilChannelLookup.class);

    public JChannel getJGroupsChannel(java.util.Properties p) {
        JChannel jChannel;
        block10: {
            InputStream stream = FileLookupFactory.newInstance().lookupFile("jgroups-tcp.xml", Thread.currentThread().getContextClassLoader());
            try {
                JChannel channel = new JChannel(stream);
                TCPPING ping = (TCPPING)channel.getProtocolStack().findProtocol(TCPPING.class);
                String controllerIP = Properties.get((String)"io.hyperfoil.controller.cluster.ip", null);
                String controllerPort = Properties.get((String)"io.hyperfoil.controller.cluster.port", null);
                if (controllerIP != null && controllerPort != null) {
                    log.info((Object)"Connecting to controller {}:{}", new Object[]{controllerIP, controllerPort});
                    ping.initialHosts(Collections.singletonList(new InetSocketAddress(controllerIP, Integer.parseInt(controllerPort))));
                } else {
                    log.info((Object)"Reducing join timeout.");
                    GMS gms = (GMS)channel.getProtocolStack().findProtocol(GMS.class);
                    gms.joinTimeout(0L);
                }
                TCP tcp = (TCP)channel.getProtocolStack().findProtocol(TCP.class);
                System.setProperty("io.hyperfoil.controller.cluster.ip", tcp.getBindAddress().getHostAddress());
                System.setProperty("io.hyperfoil.controller.cluster.port", String.valueOf(tcp.getBindPort()));
                log.info((Object)"Using {}:{} as clustering address", new Object[]{tcp.getBindAddress().getHostAddress(), tcp.getBindPort()});
                jChannel = channel;
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return jChannel;
    }

    public boolean shouldConnect() {
        return true;
    }

    public boolean shouldDisconnect() {
        return true;
    }

    public boolean shouldClose() {
        return true;
    }
}

