/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil;

import io.hyperfoil.Hyperfoil;
import io.hyperfoil.clustering.Codecs;
import io.hyperfoil.clustering.ControllerVerticle;
import io.hyperfoil.internal.Controller;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;

public class LocalController
implements Controller {
    private final Vertx vertx;
    private final String host;
    private final int port;

    public LocalController(Vertx vertx, String host, int port) {
        this.vertx = vertx;
        this.host = host;
        this.port = port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public void stop() {
        CompletableFuture stopFuture = new CompletableFuture();
        this.vertx.close(result -> {
            if (result.succeeded()) {
                stopFuture.complete(null);
            } else {
                stopFuture.completeExceptionally(result.cause());
            }
        });
        stopFuture.join();
    }

    public static class Factory
    implements Controller.Factory {
        public Controller start(Path rootDir) {
            if (rootDir != null) {
                System.setProperty("io.hyperfoil.rootdir", rootDir.toFile().getAbsolutePath());
            } else {
                rootDir = Controller.DEFAULT_ROOT_DIR;
            }
            JsonObject config = new JsonObject();
            config.put("io.hyperfoil.controller.log.file", rootDir.resolve("hyperfoil.local.log").toFile().getAbsolutePath());
            config.put("io.hyperfoil.controller.host", "127.0.0.1");
            config.put("io.hyperfoil.controller.port", Integer.valueOf(0));
            Vertx vertx = Vertx.vertx();
            Codecs.register(vertx);
            Hyperfoil.ensureNettyResourceLeakDetection();
            CompletableFuture completion = new CompletableFuture();
            ControllerVerticle controller = new ControllerVerticle();
            vertx.deployVerticle((Verticle)controller, new DeploymentOptions().setConfig(config), event -> {
                if (event.succeeded()) {
                    completion.complete(controller.actualPort());
                } else {
                    completion.completeExceptionally(event.cause());
                }
            });
            return new LocalController(vertx, "127.0.0.1", (Integer)completion.join());
        }
    }
}

