/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Phase;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;

public class ControllerPhase {
    private static Logger log = LoggerFactory.getLogger(ControllerPhase.class);
    private final Phase definition;
    private Status status = Status.NOT_STARTED;
    private long absoluteStartTime = Long.MIN_VALUE;
    private long absoluteCompletionTime = Long.MIN_VALUE;
    private boolean failed;

    public ControllerPhase(Phase definition) {
        this.definition = definition;
    }

    public Phase definition() {
        return this.definition;
    }

    public Status status() {
        return this.status;
    }

    public long absoluteStartTime() {
        return this.absoluteStartTime;
    }

    public void status(String runId, Status status) {
        if (this.status.ordinal() < status.ordinal()) {
            log.info((Object)"{} {} changing status {} to {}", new Object[]{runId, this.definition.name, this.status, status});
            this.status = status;
        }
    }

    public void absoluteStartTime(long time) {
        this.absoluteStartTime = time;
    }

    public long absoluteCompletionTime() {
        return this.absoluteCompletionTime;
    }

    public void absoluteCompletionTime(long absoluteCompletionTime) {
        this.absoluteCompletionTime = absoluteCompletionTime;
    }

    public void setFailed() {
        this.failed = true;
    }

    public boolean isFailed() {
        return this.failed;
    }

    static enum Status {
        NOT_STARTED,
        STARTING,
        RUNNING,
        FINISHING,
        FINISHED,
        TERMINATING,
        TERMINATED,
        CANCELLED;


        public boolean isFinished() {
            return this.ordinal() >= FINISHED.ordinal();
        }

        public boolean isTerminated() {
            return this.ordinal() >= TERMINATED.ordinal();
        }
    }
}

