/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.Version;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.clustering.ControllerVerticle;
import io.hyperfoil.clustering.RequestBenchmarkData;
import io.hyperfoil.clustering.Run;
import io.hyperfoil.clustering.Zipper;
import io.hyperfoil.clustering.util.PersistedBenchmarkData;
import io.hyperfoil.clustering.webcli.WebCLI;
import io.hyperfoil.controller.ApiService;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.controller.model.Agent;
import io.hyperfoil.controller.model.CustomStats;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.controller.router.ApiRouter;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.print.YamlVisitor;
import io.hyperfoil.core.util.CountDown;
import io.hyperfoil.core.util.LowHigh;
import io.hyperfoil.core.util.Util;
import io.hyperfoil.internal.Controller;
import io.hyperfoil.internal.Properties;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.handler.StaticHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class ControllerServer
implements ApiService {
    private static final Logger log = LoggerFactory.getLogger(ControllerServer.class);
    private static final String MIME_TYPE_JSON = "application/json";
    private static final String MIME_TYPE_SERIALIZED = "application/java-serialized-object";
    private static final String MIME_TYPE_TEXT_PLAIN = "text/plain";
    private static final String MIME_TYPE_YAML = "text/vnd.yaml";
    private static final String KEYSTORE_PATH = Properties.get((String)"io.hyperfoil.controller.keystore.path", null);
    private static final String KEYSTORE_PASSWORD = Properties.get((String)"io.hyperfoil.controller.keystore.password", null);
    private static final String PEM_KEYS = Properties.get((String)"io.hyperfoil.controller.pem.keys", null);
    private static final String PEM_CERTS = Properties.get((String)"io.hyperfoil.controller.pem.certs", null);
    private static final String CONTROLLER_PASSWORD = Properties.get((String)"io.hyperfoil.controller.password", null);
    private static final boolean CONTROLLER_SECURED_VIA_PROXY = Properties.getBoolean((String)"io.hyperfoil.controller.secured.via.proxy");
    private static final String CONTROLLER_EXTERNAL_URI = Properties.get((String)"io.hyperfoil.controller.external.uri", null);
    private static final String TRIGGER_URL = Properties.get((String)"io.hyperfoil.trigger.url", null);
    private static final String BEARER_TOKEN;
    private static final Comparator<ControllerPhase> PHASE_COMPARATOR;
    private static final BinaryOperator<Run> LAST_RUN_OPERATOR;
    final ControllerVerticle controller;
    HttpServer httpServer;
    String baseURL;

    ControllerServer(ControllerVerticle controller, CountDown countDown) {
        this.controller = controller;
        HttpServerOptions options = new HttpServerOptions();
        if (KEYSTORE_PATH != null) {
            options.setSsl(true).setUseAlpn(true).setKeyCertOptions((KeyCertOptions)new JksOptions().setPath(KEYSTORE_PATH).setPassword(KEYSTORE_PASSWORD));
        } else if (PEM_CERTS != null || PEM_KEYS != null) {
            PemKeyCertOptions pem = new PemKeyCertOptions();
            if (PEM_CERTS != null) {
                for (String certPath : PEM_CERTS.split(",")) {
                    pem.addCertPath(certPath.trim());
                }
            }
            if (PEM_KEYS != null) {
                for (String keyPath : PEM_KEYS.split(",")) {
                    pem.addKeyPath(keyPath.trim());
                }
            }
            options.setSsl(true).setUseAlpn(true).setKeyCertOptions((KeyCertOptions)pem);
        }
        Router router = Router.router((Vertx)controller.getVertx());
        if (CONTROLLER_PASSWORD != null) {
            if (!options.isSsl() && !CONTROLLER_SECURED_VIA_PROXY) {
                throw new IllegalStateException("Server uses basic authentication scheme (io.hyperfoil.controller.password is set) but it does not use TLS connections. If the confidentiality is guaranteed by a proxy set -Dio.hyperfoil.controller.secured.via.proxy=true.");
            }
            log.info((Object)"Server is protected using a password.");
            router.route().handler((Handler)new BasicAuthHandler());
        }
        StaticHandler staticHandler = StaticHandler.create().setCachingEnabled(true);
        router.route("/").handler((Handler)staticHandler);
        router.route("/web/*").handler((Handler)staticHandler);
        router.route("/favicon.ico").handler((Handler)FaviconHandler.create((String)"webroot/favicon.ico"));
        new ApiRouter((ApiService)this, router);
        String controllerHost = Properties.get((String)"io.hyperfoil.controller.host", (String)controller.getConfig().getString("io.hyperfoil.controller.host", "0.0.0.0"));
        int controllerPort = Properties.getInt((String)"io.hyperfoil.controller.port", (int)controller.getConfig().getInteger("io.hyperfoil.controller.port", Integer.valueOf(8090)));
        this.httpServer = controller.getVertx().createHttpServer(options).requestHandler((Handler)router).webSocketHandler((Handler)new WebCLI(controller.getVertx())).listen(controllerPort, controllerHost, serverResult -> {
            if (serverResult.succeeded()) {
                if (CONTROLLER_EXTERNAL_URI == null) {
                    String host = controllerHost;
                    if (host.equals("0.0.0.0")) {
                        try {
                            host = InetAddress.getLocalHost().getHostName();
                        }
                        catch (UnknownHostException e) {
                            host = "localhost";
                        }
                    }
                    this.baseURL = (options.isSsl() ? "https://" : "http://") + host + ":" + ((HttpServer)serverResult.result()).actualPort();
                } else {
                    this.baseURL = CONTROLLER_EXTERNAL_URI;
                }
            }
            log.info((Object)"Hyperfoil controller listening on {}", new Object[]{this.baseURL});
            countDown.handle(serverResult.mapEmpty());
        });
    }

    void stop(Promise<Void> stopFuture) {
        this.httpServer.close(result -> stopFuture.complete());
    }

    public void openApi(RoutingContext ctx) {
        try {
            String contentType;
            Buffer payload;
            InputStream stream = ApiService.class.getClassLoader().getResourceAsStream("openapi.yaml");
            if (stream == null) {
                payload = Buffer.buffer((String)"API definition not available");
                contentType = MIME_TYPE_TEXT_PLAIN;
            } else {
                payload = Buffer.buffer((String)Util.toString((InputStream)stream));
                contentType = MIME_TYPE_YAML;
            }
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE.toString(), contentType).putHeader("x-epoch-millis", String.valueOf(System.currentTimeMillis())).end(payload);
        }
        catch (IOException e) {
            log.error((Object)"Cannot read OpenAPI definition", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot read OpenAPI definition.").end();
        }
    }

    public void listBenchmarks(RoutingContext ctx) {
        ctx.response().end(Json.encodePrettily(this.controller.getBenchmarks()));
    }

    public void addBenchmark$application_json(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        this.addBenchmark$text_vnd_yaml(ctx, ifMatch, storedFilesBenchmark);
    }

    private void addBenchmarkAndReply(RoutingContext ctx, Benchmark benchmark, String prevVersion) {
        if (benchmark != null) {
            String location = this.baseURL + "/benchmark/" + ControllerServer.encode(benchmark.name());
            if (!this.controller.addBenchmark(benchmark, prevVersion, (Handler<AsyncResult<Void>>)((Handler)event -> {
                if (event.succeeded()) {
                    ctx.response().setStatusCode(HttpResponseStatus.NO_CONTENT.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)location).end();
                } else {
                    ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                }
            }))) {
                ctx.response().setStatusCode(HttpResponseStatus.CONFLICT.code()).end();
            }
        } else {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Cannot read benchmark.");
        }
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addBenchmark$text_vnd_yaml(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        String source = ctx.getBodyAsString();
        if (source == null || source.isEmpty()) {
            log.error((Object)"Benchmark is empty, upload failed.");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Benchmark is empty.");
        }
        try {
            BenchmarkBuilder builder = BenchmarkParser.instance().builder(source, BenchmarkData.EMPTY);
            if (storedFilesBenchmark != null) {
                storedFilesBenchmark = PersistedBenchmarkData.sanitize(storedFilesBenchmark);
                builder.data((BenchmarkData)new PersistedBenchmarkData(Controller.BENCHMARK_DIR.resolve(storedFilesBenchmark + ".data")));
            }
            this.addBenchmarkAndReply(ctx, builder.build(), ifMatch);
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            this.respondParsingError(ctx, (Exception)e);
        }
    }

    private void respondParsingError(RoutingContext ctx, Exception e) {
        log.error((Object)"Failed to read benchmark", (Throwable)e);
        ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Cannot read benchmark: " + Util.explainCauses((Throwable)e));
    }

    public void addBenchmark$application_java_serialized_object(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        if (storedFilesBenchmark != null) {
            log.warn((Object)"Ignoring parameter useStoredData for serialized benchmark upload.");
        }
        byte[] bytes = ctx.getBody().getBytes();
        try {
            Benchmark benchmark = Util.deserialize((byte[])bytes);
            this.addBenchmarkAndReply(ctx, benchmark, ifMatch);
        }
        catch (IOException | ClassNotFoundException e) {
            log.error((Object)"Failed to deserialize", (Throwable)e);
            StringBuilder message = new StringBuilder("Cannot read benchmark - the controller (server) version and CLI version are probably not in sync.\n");
            message.append("This partial stack-track might help you diagnose the problematic part:\n---\n");
            for (StackTraceElement ste : e.getStackTrace()) {
                message.append(ste).append('\n');
                if (ste.getClassName().equals(Util.class.getName())) break;
            }
            message.append("---\n");
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end(message.toString());
        }
    }

    public void addBenchmark$multipart_form_data(RoutingContext ctx, String ifMatch, String storedFilesBenchmark) {
        String source = null;
        RequestBenchmarkData data = new RequestBenchmarkData();
        for (FileUpload upload : ctx.fileUploads()) {
            byte[] bytes;
            try {
                bytes = Files.readAllBytes(Paths.get(upload.uploadedFileName(), new String[0]));
            }
            catch (IOException e) {
                log.error((Object)"Cannot read uploaded file {}", (Throwable)e, new Object[]{upload.uploadedFileName()});
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
                return;
            }
            if (upload.name().equals("benchmark")) {
                try {
                    source = new String(bytes, upload.charSet());
                }
                catch (UnsupportedEncodingException e) {
                    source = new String(bytes, StandardCharsets.UTF_8);
                }
                continue;
            }
            data.addFile(upload.fileName(), bytes);
        }
        if (source == null) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Multi-part definition missing benchmark=source-file.yaml");
            return;
        }
        try {
            BenchmarkBuilder builder = BenchmarkParser.instance().builder(source, (BenchmarkData)data);
            if (storedFilesBenchmark != null) {
                storedFilesBenchmark = PersistedBenchmarkData.sanitize(storedFilesBenchmark);
                Path dataDirPath = Controller.BENCHMARK_DIR.resolve(storedFilesBenchmark + ".data");
                log.info((Object)"Trying to use stored files from {}, adding files from request: {}", new Object[]{dataDirPath, data.files().keySet()});
                if (!data.files().isEmpty()) {
                    File dataDir = dataDirPath.toFile();
                    dataDir.mkdirs();
                    if (dataDir.exists() && dataDir.isDirectory()) {
                        try {
                            PersistedBenchmarkData.store(data.files(), dataDirPath);
                        }
                        catch (IOException e) {
                            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("Failed to store benchmark files.");
                        }
                    }
                }
                builder.data((BenchmarkData)new PersistedBenchmarkData(dataDirPath));
            }
            this.addBenchmarkAndReply(ctx, builder.build(), ifMatch);
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            this.respondParsingError(ctx, (Exception)e);
        }
    }

    public void getBenchmark$text_vnd_yaml(RoutingContext ctx, String name) {
        this.withBenchmark(ctx, name, benchmark -> this.sendYamlBenchmark(ctx, (Benchmark)benchmark));
    }

    private void sendYamlBenchmark(RoutingContext ctx, Benchmark benchmark) {
        if (benchmark.source() == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_ACCEPTABLE.code()).setStatusMessage("Benchmark does not preserve the original source.");
        } else {
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/vnd.yaml; charset=UTF-8").putHeader(HttpHeaders.ETAG.toString(), benchmark.version()).end(benchmark.source());
        }
    }

    public void getBenchmark$application_java_serialized_object(RoutingContext ctx, String name) {
        this.withBenchmark(ctx, name, benchmark -> this.sendSerializedBenchmark(ctx, (Benchmark)benchmark));
    }

    private void sendSerializedBenchmark(RoutingContext ctx, Benchmark benchmark) {
        try {
            byte[] bytes = Util.serialize((Benchmark)benchmark);
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_SERIALIZED).end(Buffer.buffer((byte[])bytes));
        }
        catch (IOException e) {
            log.error((Object)"Failed to serialize", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end("Error encoding benchmark.");
        }
    }

    public void startBenchmark(RoutingContext ctx, String name, String desc, String xTriggerJob, String runId) {
        Run run;
        String triggerUrl;
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end("Benchmark not found");
            return;
        }
        String string = triggerUrl = benchmark.triggerUrl() != null ? benchmark.triggerUrl() : TRIGGER_URL;
        if (triggerUrl != null && xTriggerJob == null) {
            Run run2 = this.controller.createRun(benchmark, desc);
            ctx.response().setStatusCode(HttpResponseStatus.MOVED_PERMANENTLY.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)(triggerUrl + "BENCHMARK=" + name + "&RUN_ID=" + run2.id)).putHeader("x-run-id", run2.id).end("This controller is configured to trigger jobs through CI instance.");
            return;
        }
        if (runId == null) {
            run = this.controller.createRun(benchmark, desc);
        } else {
            run = this.controller.run(runId);
            if (run == null || run.startTime != Long.MIN_VALUE) {
                ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end("Run already started");
                return;
            }
        }
        String error = this.controller.startBenchmark(run);
        if (error == null) {
            ctx.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).putHeader(HttpHeaders.LOCATION, (CharSequence)(this.baseURL + "/run/" + run.id)).end(Json.encodePrettily((Object)this.runInfo(run, false)));
        } else {
            ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).end(error);
        }
    }

    public void getBenchmarkStructure(RoutingContext ctx, String name) {
        this.withBenchmark(ctx, name, benchmark -> {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream(byteStream);){
                new YamlVisitor(stream).walk(benchmark);
            }
            ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_YAML).end(Buffer.buffer((byte[])byteStream.toByteArray()));
        });
    }

    public void listRuns(RoutingContext ctx, boolean details) {
        io.hyperfoil.controller.model.Run[] runs = (io.hyperfoil.controller.model.Run[])this.controller.runs().stream().map(r -> details ? this.runInfo((Run)r, false) : new io.hyperfoil.controller.model.Run(r.id, null, null, null, r.cancelled, r.completed, null, null, null, null)).toArray(io.hyperfoil.controller.model.Run[]::new);
        ctx.response().end(Json.encodePrettily((Object)runs));
    }

    public void getRun(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> ctx.response().end(Json.encodePrettily((Object)this.runInfo((Run)run, true))));
    }

    private io.hyperfoil.controller.model.Run runInfo(Run run, boolean reportPhases) {
        String benchmark = null;
        if (run.benchmark != null) {
            benchmark = run.benchmark.name();
        }
        Date started = null;
        Date terminated = null;
        if (run.startTime > Long.MIN_VALUE) {
            started = new Date(run.startTime);
        }
        if (run.terminateTime.future().isComplete()) {
            terminated = new Date((Long)run.terminateTime.future().result());
        }
        List phases = null;
        if (reportPhases) {
            long now = System.currentTimeMillis();
            phases = run.phases.values().stream().filter(p -> !(p.definition() instanceof Phase.Noop)).sorted(PHASE_COMPARATOR).map(phase -> {
                Date phaseStarted = null;
                Date phaseTerminated = null;
                StringBuilder remaining = null;
                StringBuilder totalDuration = null;
                if (phase.absoluteStartTime() > Long.MIN_VALUE) {
                    phaseStarted = new Date(phase.absoluteStartTime());
                    if (!phase.status().isTerminated()) {
                        remaining = new StringBuilder().append(phase.definition().duration() - (now - phase.absoluteStartTime())).append(" ms");
                        if (phase.definition().maxDuration() >= 0L) {
                            remaining.append(" (").append(phase.definition().maxDuration() - (now - phase.absoluteStartTime())).append(" ms)");
                        }
                    } else {
                        phaseTerminated = new Date(phase.absoluteCompletionTime());
                        long totalDurationValue = phase.absoluteCompletionTime() - phase.absoluteStartTime();
                        totalDuration = new StringBuilder().append(totalDurationValue).append(" ms");
                        if (totalDurationValue > phase.definition().duration()) {
                            totalDuration.append(" (exceeded by ").append(totalDurationValue - phase.definition().duration()).append(" ms)");
                        }
                    }
                }
                Object type = phase.definition().getClass().getSimpleName();
                type = Character.toLowerCase(((String)type).charAt(0)) + ((String)type).substring(1);
                return new Phase(phase.definition().name(), phase.status().toString(), (String)type, phaseStarted, remaining == null ? null : remaining.toString(), phaseTerminated, phase.isFailed(), totalDuration == null ? null : totalDuration.toString(), phase.definition().description());
            }).collect(Collectors.toList());
        }
        List agents = run.agents.stream().map(ai -> new Agent(ai.name, ai.deploymentId, ai.status.toString())).collect(Collectors.toList());
        return new io.hyperfoil.controller.model.Run(run.id, benchmark, started, terminated, run.cancelled, run.completed, run.description, phases, agents, run.errors.stream().map(Run.Error::toString).collect(Collectors.toList()));
    }

    private void withRun(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        Run run = "last".equals(runId) ? (Run)this.controller.runs.values().stream().reduce(LAST_RUN_OPERATOR).orElse(null) : this.controller.run(runId);
        if (run == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
        } else {
            consumer.accept(run);
        }
    }

    public void killRun(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> this.controller.kill((Run)run, (Handler<AsyncResult<Void>>)((Handler)result -> {
            if (result.succeeded()) {
                ctx.response().setStatusCode(HttpResponseStatus.ACCEPTED.code()).end();
            } else {
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage(result.cause().getMessage()).end();
            }
        })));
    }

    public void listSessions(RoutingContext ctx, String runId, boolean inactive) {
        this.withRun(ctx, runId, run -> {
            ctx.response().setChunked(true);
            this.controller.listSessions((Run)run, inactive, (agent, session) -> {
                String line = agent.name + ": " + session + "\n";
                ctx.response().write(Buffer.buffer((byte[])line.getBytes(StandardCharsets.UTF_8)));
            }, this.commonListingHandler(ctx.response()));
        });
    }

    private Handler<AsyncResult<Void>> commonListingHandler(HttpServerResponse response) {
        return result -> {
            if (result.succeeded()) {
                response.setStatusCode(HttpResponseStatus.OK.code()).end();
            } else if (result.cause() instanceof NoStackTraceThrowable) {
                response.setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            } else {
                response.setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end(result.cause().getMessage());
            }
        };
    }

    public void getRecentSessions(RoutingContext ctx, String runId) {
        this.getSessionStats(ctx, runId, ss -> ss.recentSessionPoolSummary(System.currentTimeMillis() - 5000L));
    }

    public void getTotalSessions(RoutingContext ctx, String runId) {
        this.getSessionStats(ctx, runId, StatisticsStore::totalSessionPoolSummary);
    }

    private void getSessionStats(RoutingContext ctx, String runId, Function<StatisticsStore, Map<String, Map<String, LowHigh>>> func) {
        this.withRun(ctx, runId, run -> {
            if (run.statisticsStore == null) {
                ctx.response().end("{}");
                return;
            }
            Map stats = (Map)func.apply(run.statisticsStore);
            JsonObject reply = new JsonObject();
            for (Map.Entry entry : stats.entrySet()) {
                String phase = (String)entry.getKey();
                Map addressStats = (Map)entry.getValue();
                JsonObject phaseStats = new JsonObject();
                reply.put(phase, phaseStats);
                addressStats.forEach((address, lowHigh) -> {
                    String agent = run.agents.stream().filter(a -> a.deploymentId.equals(address)).map(a -> a.name).findFirst().orElse("unknown");
                    phaseStats.put(agent, new JsonObject().put("min", Integer.valueOf(lowHigh.low)).put("max", Integer.valueOf(lowHigh.high)));
                });
            }
            ctx.response().end(reply.encodePrettily());
        });
    }

    public void listConnections(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> {
            ctx.response().setChunked(true);
            this.controller.listConnections((Run)run, (agent, connection) -> {
                String line = agent.name + ": " + connection + "\n";
                ctx.response().write(Buffer.buffer((byte[])line.getBytes(StandardCharsets.UTF_8)));
            }, this.commonListingHandler(ctx.response()));
        });
    }

    public void getAllStats$application_zip(RoutingContext ctx, String runId) {
        this.getAllStatsCsv(ctx, runId);
    }

    public void getAllStatsCsv(RoutingContext ctx, String runId) {
        this.withTerminatedRun(ctx, runId, run -> new Zipper(ctx.response(), this.controller.getRunDir((Run)run).resolve("stats")).run());
    }

    public void getAllStats$application_json(RoutingContext ctx, String runId) {
        this.getAllStatsJson(ctx, runId);
    }

    public void getAllStatsJson(RoutingContext ctx, String runId) {
        this.withTerminatedRun(ctx, runId, run -> ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)MIME_TYPE_JSON).sendFile(this.controller.getRunDir((Run)run).resolve("all.json").toString()));
    }

    private void withTerminatedRun(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        this.withRun(ctx, runId, run -> {
            if (!run.terminateTime.future().isComplete()) {
                ctx.response().setStatusCode(HttpResponseStatus.SEE_OTHER.code()).setStatusMessage("Run is not completed yet.").putHeader(HttpHeaders.LOCATION, (CharSequence)("/run/" + run.id)).end();
            } else {
                consumer.accept((Run)run);
            }
        });
    }

    public void getRecentStats(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> {
            List<RequestStats> stats = run.statisticsStore.recentSummary(System.currentTimeMillis() - 5000L);
            ctx.response().end(Json.encodePrettily((Object)this.statsToJson((Run)run, stats)));
        });
    }

    public void getTotalStats(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> {
            List<RequestStats> stats = run.statisticsStore.totalSummary();
            ctx.response().end(Json.encodePrettily((Object)this.statsToJson((Run)run, stats)));
        });
    }

    public void getCustomStats(RoutingContext ctx, String runId) {
        this.withStats(ctx, runId, run -> {
            List<CustomStats> stats = run.statisticsStore.customStats();
            ctx.response().end(new JsonArray(stats).encodePrettily());
        });
    }

    public void getHistogramStats(RoutingContext ctx, String runId, String phase, int stepId, String metric) {
        this.withStats(ctx, runId, run -> {
            Histogram histogram = run.statisticsStore.histogram(phase, stepId, metric);
            ctx.response().end(Json.encode((Object)histogram));
        });
    }

    public void getRunFile(RoutingContext ctx, String runId, String file) {
        this.withRun(ctx, runId, run -> {
            Path runDir = this.controller.getRunDir((Run)run).toAbsolutePath();
            Path path = runDir.resolve(file).toAbsolutePath();
            if (!path.startsWith(runDir)) {
                ctx.response().setStatusCode(403).end("Requested file is not within the run directory!");
            } else if (!path.toFile().exists() || !path.toFile().isFile()) {
                ctx.response().setStatusCode(404).end("Requested file was not found");
            } else {
                ctx.response().sendFile(path.toString());
            }
        });
    }

    private void withStats(RoutingContext ctx, String runId, Consumer<Run> consumer) {
        this.withRun(ctx, runId, run -> {
            if (run.statisticsStore == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end();
            } else {
                consumer.accept((Run)run);
            }
        });
    }

    private RequestStatisticsResponse statsToJson(Run run, List<RequestStats> stats) {
        String status = run.terminateTime.future().isComplete() ? "TERMINATED" : (run.startTime > Long.MIN_VALUE ? "RUNNING" : "INITIALIZING");
        return new RequestStatisticsResponse(status, stats);
    }

    public void getBenchmarkForRun$text_vnd_yaml(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> this.sendYamlBenchmark(ctx, run.benchmark));
    }

    public void getBenchmarkForRun$application_java_serialized_object(RoutingContext ctx, String runId) {
        this.withRun(ctx, runId, run -> this.sendSerializedBenchmark(ctx, run.benchmark));
    }

    public void listAgents(RoutingContext ctx) {
        ctx.response().end(new JsonArray(this.controller.runs.values().stream().flatMap(run -> run.agents.stream().map(agentInfo -> agentInfo.name)).distinct().collect(Collectors.toList())).encodePrettily());
    }

    public void getControllerLog(RoutingContext ctx, long offset, String ifMatch) {
        String logPath = Properties.get((String)"io.hyperfoil.controller.log.file", (String)this.controller.getConfig().getString("io.hyperfoil.controller.log.file"));
        if (ifMatch != null && !ifMatch.equals(this.controller.deploymentID())) {
            ctx.response().setStatusCode(HttpResponseStatus.PRECONDITION_FAILED.code()).end();
            return;
        }
        if (this.controller.hasControllerLog()) {
            try {
                File tempFile = File.createTempFile("controller.", ".log");
                tempFile.deleteOnExit();
                this.controller.downloadControllerLog(offset, tempFile, (Handler<AsyncResult<Void>>)((Handler)result -> {
                    if (result.succeeded()) {
                        ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)this.controller.deploymentID()).sendFile(tempFile.toString(), r -> tempFile.delete());
                    } else {
                        log.error((Object)"Failed to download controller log.", result.cause());
                        ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot download controller log").end();
                    }
                }));
            }
            catch (IOException e) {
                log.error((Object)"Failed to create temporary file", (Throwable)e);
                ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
            }
        } else {
            if (logPath == null) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Log file not defined.").end();
                return;
            }
            File logFile = new File(logPath);
            if (!logFile.exists()) {
                ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Log file does not exist.").end();
            } else if (offset < 0L) {
                ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage("Offset must be non-negative").end();
            } else {
                ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)this.controller.deploymentID());
                ctx.response().sendFile(logPath, offset);
            }
        }
    }

    public void getAgentLog(RoutingContext ctx, String agent, long offset, String ifMatch) {
        Optional agentInfo;
        if (agent == null || "controller".equals(agent)) {
            this.getControllerLog(ctx, offset, ifMatch);
            return;
        }
        if (offset < 0L) {
            ctx.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).setStatusMessage("Offset must be non-negative").end();
        }
        if (!(agentInfo = this.controller.runs.values().stream().reduce(LAST_RUN_OPERATOR).flatMap(run -> run.agents.stream().filter(ai -> agent.equals(ai.name)).findFirst())).isPresent()) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("Agent " + agent + " not found.").end();
            return;
        }
        if (ifMatch != null && !ifMatch.equals(((AgentInfo)agentInfo.get()).deploymentId)) {
            ctx.response().setStatusCode(HttpResponseStatus.PRECONDITION_FAILED.code()).end();
            return;
        }
        try {
            File tempFile = File.createTempFile("agent." + agent, ".log");
            tempFile.deleteOnExit();
            this.controller.downloadAgentLog(((AgentInfo)agentInfo.get()).deployedAgent, offset, tempFile, (Handler<AsyncResult<Void>>)((Handler)result -> {
                if (result.succeeded()) {
                    ctx.response().putHeader(HttpHeaders.ETAG, (CharSequence)((AgentInfo)agentInfo.get()).deploymentId).sendFile(tempFile.toString(), r -> tempFile.delete());
                } else {
                    log.error((Object)("Failed to download agent log for " + agentInfo.get()), result.cause());
                    ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).setStatusMessage("Cannot download agent log").end();
                }
            }));
        }
        catch (IOException e) {
            log.error((Object)"Failed to create temporary file", (Throwable)e);
            ctx.response().setStatusCode(HttpResponseStatus.INTERNAL_SERVER_ERROR.code()).end();
        }
    }

    public void shutdown(RoutingContext ctx, boolean force) {
        List runs = this.controller.runs.values().stream().filter(run -> !run.terminateTime.future().isComplete()).collect(Collectors.toList());
        if (force) {
            ArrayList<Future> futures = new ArrayList<Future>();
            for (Run run2 : runs) {
                Promise promise = Promise.promise();
                futures.add(promise.future());
                this.controller.kill(run2, (Handler<AsyncResult<Void>>)((Handler)result -> promise.complete()));
            }
            CompositeFuture.all(futures).onComplete(nil -> {
                ctx.response().end();
                this.controller.shutdown();
            });
        } else if (runs.isEmpty()) {
            ctx.response().end();
            this.controller.shutdown();
        } else {
            String running = runs.stream().map(run -> run.id).collect(Collectors.joining(", "));
            ctx.response().setStatusCode(HttpResponseStatus.FORBIDDEN.code()).setStatusMessage("These runs are still in progress: " + running).end();
        }
    }

    public void getToken(RoutingContext ctx) {
        ctx.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/plain; charset=utf-8").end(BEARER_TOKEN);
    }

    public void getVersion(RoutingContext ctx) {
        ctx.response().end(Json.encodePrettily((Object)new io.hyperfoil.controller.model.Version(Version.VERSION, Version.COMMIT_ID, this.controller.deploymentID(), new Date())));
    }

    public void withBenchmark(RoutingContext ctx, String name, Consumer<Benchmark> consumer) {
        Benchmark benchmark = this.controller.getBenchmark(name);
        if (benchmark == null) {
            ctx.response().setStatusCode(HttpResponseStatus.NOT_FOUND.code()).setStatusMessage("No benchmark '" + name + "'").end();
            return;
        }
        consumer.accept(benchmark);
    }

    static {
        PHASE_COMPARATOR = Comparator.comparing(ControllerPhase::absoluteStartTime).thenComparing(p -> p.definition().name);
        LAST_RUN_OPERATOR = (r1, r2) -> r1.id.compareTo(r2.id) > 0 ? r1 : r2;
        byte[] token = new byte[48];
        new SecureRandom().nextBytes(token);
        BEARER_TOKEN = Base64.getEncoder().encodeToString(token);
    }

    private static class BasicAuthHandler
    implements Handler<RoutingContext> {
        private BasicAuthHandler() {
        }

        public void handle(RoutingContext ctx) {
            String authorization = ctx.request().getHeader(HttpHeaders.AUTHORIZATION);
            if (authorization != null && authorization.startsWith("Basic ")) {
                byte[] credentials = Base64.getDecoder().decode(authorization.substring(6).trim());
                for (int i = 0; i < credentials.length; ++i) {
                    if (credentials[i] != 58) continue;
                    String password = new String(credentials, i + 1, credentials.length - i - 1, StandardCharsets.UTF_8);
                    if (!password.equals(CONTROLLER_PASSWORD)) break;
                    ctx.next();
                    return;
                }
                ctx.response().setStatusCode(403).end();
            } else if (authorization != null && authorization.startsWith("Bearer ")) {
                if (BEARER_TOKEN.equals(authorization.substring(7))) {
                    ctx.next();
                } else {
                    ctx.response().setStatusCode(403).end();
                }
            } else {
                ctx.response().setStatusCode(401).putHeader("WWW-Authenticate", "Basic realm=\"Hyperfoil\", charset=\"UTF-8\"").end();
            }
        }
    }
}

