/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.config.RunHook;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.Deployer;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.AgentVerticle;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.clustering.ControllerServer;
import io.hyperfoil.clustering.Run;
import io.hyperfoil.clustering.messages.AgentControlMessage;
import io.hyperfoil.clustering.messages.AgentHello;
import io.hyperfoil.clustering.messages.AgentReadyMessage;
import io.hyperfoil.clustering.messages.AgentStatusMessage;
import io.hyperfoil.clustering.messages.ErrorMessage;
import io.hyperfoil.clustering.messages.PhaseChangeMessage;
import io.hyperfoil.clustering.messages.PhaseControlMessage;
import io.hyperfoil.clustering.messages.RequestStatsMessage;
import io.hyperfoil.clustering.messages.SessionStatsMessage;
import io.hyperfoil.clustering.messages.StatsMessage;
import io.hyperfoil.clustering.util.PersistenceUtil;
import io.hyperfoil.controller.CsvWriter;
import io.hyperfoil.controller.JsonWriter;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.core.hooks.ExecRunHook;
import io.hyperfoil.core.util.CountDown;
import io.hyperfoil.internal.Controller;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.core.spi.cluster.NodeListener;
import io.vertx.ext.cluster.infinispan.InfinispanClusterManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.infinispan.commons.api.BasicCacheContainer;

public class ControllerVerticle
extends AbstractVerticle
implements NodeListener {
    private static final Logger log = LoggerFactory.getLogger(ControllerVerticle.class);
    private EventBus eb;
    private ControllerServer server;
    private Deployer deployer;
    private AtomicInteger runIds = new AtomicInteger();
    private Map<String, Benchmark> benchmarks = new HashMap<String, Benchmark>();
    private long timerId = -1L;
    Map<String, Run> runs = new HashMap<String, Run>();

    public void start(Promise<Void> future) {
        log.info((Object)"Starting in directory {}...", new Object[]{Controller.ROOT_DIR});
        CountDown startCountDown = new CountDown(future, 2);
        this.server = new ControllerServer(this, startCountDown);
        this.vertx.exceptionHandler(throwable -> log.error((Object)"Uncaught error: ", throwable));
        if (Files.exists(Controller.RUN_DIR, new LinkOption[0])) {
            try {
                Files.list(Controller.RUN_DIR).forEach(this::updateRuns);
            }
            catch (IOException e) {
                log.error((Object)"Could not list run dir contents", (Throwable)e);
            }
            catch (Exception e) {
                log.error((Object)"Cannot load previous runs from {}", (Throwable)e, new Object[]{Controller.RUN_DIR});
            }
        }
        Controller.HOOKS_DIR.resolve("pre").toFile().mkdirs();
        Controller.HOOKS_DIR.resolve("post").toFile().mkdirs();
        this.eb = this.vertx.eventBus();
        this.eb.consumer("discovery-feed", message -> {
            AgentHello hello = (AgentHello)message.body();
            String runId = hello.runId();
            Run run = this.runs.get(runId);
            if (run == null) {
                log.error((Object)("Unknown run ID {}" + runId));
                message.fail(1, "Unknown run ID");
                return;
            }
            AgentInfo agentInfo = run.agents.stream().filter(a -> a.name.equals(hello.name())).findAny().orElse(null);
            if (agentInfo == null) {
                log.error((Object)"Unknown agent {} ({}/{})", new Object[]{hello.name(), hello.nodeId(), hello.deploymentId()});
                message.fail(1, "Unknown agent");
                return;
            }
            if (agentInfo.status != AgentInfo.Status.STARTING) {
                log.info((Object)"Ignoring message, {} is not starting", new Object[]{agentInfo.name});
                message.reply((Object)"Ignoring");
                return;
            }
            log.debug((Object)"Registering agent {} ({}/{})", new Object[]{hello.name(), hello.nodeId(), hello.deploymentId()});
            agentInfo.nodeId = hello.nodeId();
            agentInfo.deploymentId = hello.deploymentId();
            agentInfo.status = AgentInfo.Status.REGISTERED;
            message.reply((Object)"Registered");
            if (run.agents.stream().allMatch(a -> a.status != AgentInfo.Status.STARTING)) {
                this.handleAgentsStarted(run);
            } else {
                log.debug((Object)"Waiting for registration from agents {}", new Object[]{run.agents.stream().filter(a -> a.status == AgentInfo.Status.STARTING).collect(Collectors.toList())});
            }
        });
        this.eb.consumer("response-feed", message -> {
            AgentStatusMessage msg = (AgentStatusMessage)message.body();
            Run run = this.runs.get(msg.runId());
            if (run == null) {
                log.error((Object)"No run {}", new Object[]{msg.runId()});
                return;
            }
            AgentInfo agent = run.agents.stream().filter(a -> a.deploymentId.equals(msg.senderId())).findAny().orElse(null);
            if (agent == null) {
                log.error((Object)"No agent {} in run {}", new Object[]{msg.senderId(), run.id});
                return;
            }
            if (msg instanceof PhaseChangeMessage) {
                this.handlePhaseChange(run, agent, (PhaseChangeMessage)msg);
            } else if (msg instanceof ErrorMessage) {
                ErrorMessage errorMessage = (ErrorMessage)msg;
                run.errors.add(new Run.Error(agent, errorMessage.error()));
                if (errorMessage.isFatal()) {
                    agent.status = AgentInfo.Status.FAILED;
                    this.stopSimulation(run);
                }
            } else if (msg instanceof AgentReadyMessage) {
                agent.status = AgentInfo.Status.READY;
                if (run.agents.stream().allMatch(a -> a.status == AgentInfo.Status.READY)) {
                    this.startSimulation(run);
                }
            } else {
                log.error((Object)"Unexpected type of message: {}", new Object[]{msg});
            }
        });
        this.eb.consumer("stats-feed", message -> {
            if (!(message.body() instanceof StatsMessage)) {
                log.error((Object)("Unknown message type: " + message.body()));
                return;
            }
            StatsMessage statsMessage = (StatsMessage)message.body();
            Run run = this.runs.get(statsMessage.runId);
            if (run != null) {
                if (run.statisticsStore != null) {
                    if (statsMessage instanceof RequestStatsMessage) {
                        RequestStatsMessage requestStatsMessage = (RequestStatsMessage)statsMessage;
                        String phase = run.phase(requestStatsMessage.phaseId);
                        if (requestStatsMessage.statistics != null) {
                            log.debug((Object)"Run {}: Received stats from {}: {}/{}/{}:{} ({} requests)", new Object[]{requestStatsMessage.runId, requestStatsMessage.address, phase, requestStatsMessage.stepId, requestStatsMessage.metric, requestStatsMessage.statistics.sequenceId, requestStatsMessage.statistics.requestCount});
                            run.statisticsStore.record(requestStatsMessage.address, requestStatsMessage.phaseId, requestStatsMessage.stepId, requestStatsMessage.metric, requestStatsMessage.statistics);
                        }
                        if (requestStatsMessage.isPhaseComplete) {
                            log.debug((Object)"Run {}: Received stats completion for phase {} from {}", new Object[]{run.id, phase, requestStatsMessage.address});
                            AgentInfo agent = run.agents.stream().filter(a -> a.deploymentId.equals(requestStatsMessage.address)).findFirst().orElse(null);
                            if (agent == null) {
                                log.error((Object)"Run {}: Cannot find agent {}", new Object[]{run.id, requestStatsMessage.address});
                            } else {
                                PhaseInstance.Status prevStatus = agent.phases.put(phase, PhaseInstance.Status.STATS_COMPLETE);
                                if (prevStatus == PhaseInstance.Status.STATS_COMPLETE) {
                                    log.info((Object)"Run {}: stats for phase {} are already completed, ignoring.", new Object[]{run.id, phase});
                                } else if (run.agents.stream().map(a -> a.phases.get(phase)).allMatch(s -> s == PhaseInstance.Status.STATS_COMPLETE)) {
                                    log.info((Object)"Run {}: completed stats for phase {}", new Object[]{run.id, phase});
                                    run.statisticsStore.completePhase(phase);
                                    if (!run.statisticsStore.validateSlas()) {
                                        log.info((Object)"SLA validation failed for {}", new Object[]{phase});
                                        ControllerPhase controllerPhase = run.phases.get(phase);
                                        controllerPhase.setFailed();
                                        this.failNotStartedPhases(run, controllerPhase);
                                    }
                                }
                            }
                        }
                    } else if (statsMessage instanceof SessionStatsMessage) {
                        SessionStatsMessage sessionStatsMessage = (SessionStatsMessage)statsMessage;
                        log.trace((Object)"Run {}: Received session pool stats from {}", new Object[]{sessionStatsMessage.runId, sessionStatsMessage.address});
                        for (Map.Entry<String, SessionStatsMessage.MinMax> entry : sessionStatsMessage.sessionStats.entrySet()) {
                            run.statisticsStore.recordSessionStats(sessionStatsMessage.address, sessionStatsMessage.timestamp, entry.getKey(), entry.getValue().min, entry.getValue().max);
                        }
                    }
                }
            } else {
                log.error((Object)"Unknown run {}", new Object[]{statsMessage.runId});
            }
            message.reply((Object)"OK");
        });
        if (this.vertx.isClustered()) {
            for (Deployer.Factory deployerFactory : ServiceLoader.load(Deployer.Factory.class)) {
                log.debug((Object)"Found deployer {}", new Object[]{deployerFactory.name()});
                if (!Controller.DEPLOYER.equals(deployerFactory.name())) continue;
                this.deployer = deployerFactory.create();
                break;
            }
            if (this.deployer == null) {
                throw new IllegalStateException("Hyperfoil is running in clustered mode but it couldn't load deployer '" + Controller.DEPLOYER + "'");
            }
            if (this.vertx instanceof VertxInternal) {
                ClusterManager clusterManager = ((VertxInternal)this.vertx).getClusterManager();
                clusterManager.nodeListener((NodeListener)this);
            }
        }
        if (!Controller.BENCHMARK_DIR.toFile().exists() && !Controller.BENCHMARK_DIR.toFile().mkdirs()) {
            log.error((Object)"Failed to create benchmark directory: {}", new Object[]{Controller.BENCHMARK_DIR});
        }
        startCountDown.increment();
        this.loadBenchmarks((Handler<AsyncResult<Void>>)startCountDown);
        startCountDown.countDown();
    }

    private void handlePhaseChange(Run run, AgentInfo agent, PhaseChangeMessage phaseChange) {
        String phase = phaseChange.phase();
        log.debug((Object)"{} Received phase change from {}: {} is {} (session limit exceeded={}, errors={})", new Object[]{run.id, phaseChange.senderId(), phase, phaseChange.status(), phaseChange.sessionLimitExceeded(), phaseChange.getError()});
        agent.phases.put(phase, phaseChange.status());
        ControllerPhase controllerPhase = run.phases.get(phase);
        if (phaseChange.sessionLimitExceeded()) {
            Phase def = controllerPhase.definition();
            run.statisticsStore.addFailure(def.name, null, controllerPhase.absoluteStartTime(), System.currentTimeMillis(), "Exceeded session limit");
            if (def instanceof Phase.OpenModelPhase && ((Phase.OpenModelPhase)def).sessionLimitPolicy == Phase.SessionLimitPolicy.CONTINUE) {
                log.warn((Object)"{} Phase {} session limit exceeded, continuing due to policy {}", new Object[]{run.id, def.name, ((Phase.OpenModelPhase)def).sessionLimitPolicy});
            } else {
                log.info((Object)"{} Failing phase due to exceeded session limit.", new Object[]{run.id});
                controllerPhase.setFailed();
            }
        }
        if (phaseChange.getError() != null) {
            log.error((Object)"{} Failing phase {} as agent {} reports error: {}", new Object[]{run.id, controllerPhase.definition().name, agent.name, phaseChange.getError().getMessage()});
            controllerPhase.setFailed();
            run.errors.add(new Run.Error(agent, phaseChange.getError()));
        }
        this.tryProgressStatus(run, phase);
        this.runSimulation(run);
    }

    public void nodeAdded(String nodeID) {
    }

    public void nodeLeft(String nodeID) {
        block0: for (Run run : this.runs.values()) {
            if (run.terminateTime.future().isComplete()) continue;
            for (AgentInfo agent : run.agents) {
                if (!Objects.equals(agent.nodeId, nodeID)) continue;
                agent.status = AgentInfo.Status.FAILED;
                run.errors.add(new Run.Error(agent, (Throwable)new BenchmarkExecutionException("Agent unexpectedly left the cluster.")));
                this.kill(run, (Handler<AsyncResult<Void>>)((Handler)result -> {}));
                this.stopSimulation(run);
                continue block0;
            }
        }
    }

    private void updateRuns(Path runDir) {
        File file = runDir.toFile();
        if (!file.getName().matches("[0-9A-F][0-9A-F][0-9A-F][0-9A-F]")) {
            return;
        }
        String runId = file.getName();
        int id = Integer.parseInt(runId, 16);
        if (id >= this.runIds.get()) {
            this.runIds.set(id + 1);
        }
        Path infoFile = runDir.resolve("info.json");
        JsonObject info = new JsonObject();
        if (infoFile.toFile().exists() && infoFile.toFile().isFile()) {
            try {
                info = new JsonObject(new String(Files.readAllBytes(infoFile), StandardCharsets.UTF_8));
            }
            catch (Exception e2) {
                log.error((Object)"Cannot read info for run {}", new Object[]{runId});
                return;
            }
        }
        Benchmark benchmark = new Benchmark(info.getString("benchmark", "<unknown>"), null, Collections.emptyMap(), new Agent[0], 0, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), 0L, null, Collections.emptyList(), Collections.emptyList());
        Run run = new Run(runId, runDir, benchmark);
        run.completed = true;
        run.startTime = info.getLong("startTime", Long.valueOf(0L));
        run.terminateTime.complete((Object)info.getLong("terminateTime", Long.valueOf(0L)));
        run.description = info.getString("description");
        JsonArray errors = info.getJsonArray("errors");
        if (errors != null) {
            run.errors.addAll(errors.stream().map(JsonObject.class::cast).map(e -> new Run.Error(new AgentInfo(e.getString("agent"), -1), new Throwable(e.getString("msg")))).collect(Collectors.toList()));
        }
        run.cancelled = info.getBoolean("cancelled", Boolean.FALSE);
        this.runs.put(runId, run);
    }

    public void stop(Promise<Void> stopFuture) throws Exception {
        if (this.deployer != null) {
            this.deployer.close();
        }
        this.server.stop(stopFuture);
    }

    private void tryProgressStatus(Run run, String phase) {
        PhaseInstance.Status minStatus = null;
        for (AgentInfo a : run.agents) {
            PhaseInstance.Status status = a.phases.get(phase);
            if (status == null) {
                return;
            }
            if (minStatus != null && status.ordinal() >= minStatus.ordinal()) continue;
            minStatus = status;
        }
        ControllerPhase controllerPhase = run.phases.get(phase);
        if (controllerPhase == null) {
            log.error((Object)"Cannot find phase {} in run {}", new Object[]{phase, run.id});
            return;
        }
        switch (minStatus) {
            case RUNNING: {
                controllerPhase.status(run.id, ControllerPhase.Status.RUNNING);
                break;
            }
            case FINISHED: {
                controllerPhase.status(run.id, ControllerPhase.Status.FINISHED);
                break;
            }
            case TERMINATED: {
                controllerPhase.status(run.id, ControllerPhase.Status.TERMINATED);
                controllerPhase.absoluteCompletionTime(System.currentTimeMillis());
            }
        }
        if (controllerPhase.isFailed()) {
            this.failNotStartedPhases(run, controllerPhase);
        }
    }

    private void failNotStartedPhases(Run run, ControllerPhase controllerPhase) {
        log.info((Object)"Phase {} failed, cancelling other phases...", new Object[]{controllerPhase.definition().name()});
        for (ControllerPhase p : run.phases.values()) {
            if (p.status() != ControllerPhase.Status.NOT_STARTED) continue;
            p.status(run.id, ControllerPhase.Status.CANCELLED);
        }
    }

    Run createRun(Benchmark benchmark, String description) {
        String runId = String.format("%04X", this.runIds.getAndIncrement());
        Path runDir = Controller.RUN_DIR.resolve(runId);
        runDir.toFile().mkdirs();
        Run run = new Run(runId, runDir, benchmark);
        run.description = description;
        run.statisticsStore = new StatisticsStore(run.benchmark, failure -> log.warn((Object)"Failed verify SLA(s) for {}/{}: {}", new Object[]{failure.phase(), failure.metric(), failure.message()}));
        this.runs.put(run.id, run);
        PersistenceUtil.store(run.benchmark, run.dir);
        return run;
    }

    /*
     * WARNING - void declaration
     */
    String startBenchmark(Run run) {
        HashSet<String> activeAgents = new HashSet<String>();
        for (Run r : this.runs.values()) {
            if (r.terminateTime.future().isComplete()) continue;
            for (AgentInfo agentInfo : run.agents) {
                activeAgents.add(agentInfo.name);
            }
        }
        for (Agent agent : run.benchmark.agents()) {
            long currentTime;
            if (!activeAgents.contains(agent.name)) continue;
            run.startTime = currentTime = System.currentTimeMillis();
            run.terminateTime.complete((Object)currentTime);
            run.completed = true;
            return "Agent " + agent + " is already used; try starting the benchmark later";
        }
        if (run.benchmark.agents().length == 0) {
            if (this.vertx.isClustered()) {
                long currentTime;
                run.startTime = currentTime = System.currentTimeMillis();
                run.terminateTime.complete((Object)currentTime);
                run.completed = true;
                return "Server is started in clustered mode; benchmarks must define agents.";
            }
            run.agents.add(new AgentInfo("in-vm", 0));
            JsonObject config = new JsonObject().put("runId", run.id).put("name", "in-vm");
            this.vertx.deployVerticle(AgentVerticle.class, new DeploymentOptions().setConfig(config));
        } else {
            void var6_15;
            if (!this.vertx.isClustered()) {
                return "Server is not started as clustered and does not accept benchmarks with agents defined.";
            }
            log.info((Object)"Starting agents for run {}", new Object[]{run.id});
            int agentCounter = 0;
            Agent[] agentArray = run.benchmark.agents();
            int n = agentArray.length;
            boolean bl = false;
            while (var6_15 < n) {
                Agent agent = agentArray[var6_15];
                AgentInfo agentInfo = new AgentInfo(agent.name, agentCounter++);
                run.agents.add(agentInfo);
                log.debug((Object)"Starting agent {}", new Object[]{agent.name});
                this.vertx.executeBlocking(future -> {
                    agentInfo.deployedAgent = this.deployer.start(agent, run.id, run.benchmark, exception -> {
                        run.errors.add(new Run.Error(agentInfo, (Throwable)new BenchmarkExecutionException("Failed to deploy agent", exception)));
                        log.error((Object)"Failed to deploy agent {}", exception, new Object[]{agent.name});
                        this.vertx.runOnContext(nil -> this.stopSimulation(run));
                    });
                }, false, result -> {
                    if (result.failed()) {
                        run.errors.add(new Run.Error(agentInfo, (Throwable)new BenchmarkExecutionException("Failed to start agent", result.cause())));
                        log.error((Object)"Failed to start agent {}", result.cause(), new Object[]{agent.name});
                    }
                });
                ++var6_15;
            }
        }
        run.deployTimerId = this.vertx.setTimer(Controller.DEPLOY_TIMEOUT, id -> {
            log.error((Object)"{} Deployment timed out.", new Object[]{run.id});
            run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException("Deployment timed out.")));
            this.stopSimulation(run);
        });
        return null;
    }

    private void handleAgentsStarted(Run run) {
        this.vertx.cancelTimer(run.deployTimerId);
        log.info((Object)"Starting benchmark {} - run {}", new Object[]{run.benchmark.name(), run.id});
        for (AgentInfo agent : run.agents) {
            if (agent.status != AgentInfo.Status.REGISTERED) {
                log.error((Object)"{} Already initializing {}, status is {}!", new Object[]{run.id, agent.deploymentId, agent.status});
                continue;
            }
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(AgentControlMessage.Command.INITIALIZE, agent.id, run.benchmark), reply -> {
                if (!reply.succeeded()) {
                    agent.status = AgentInfo.Status.FAILED;
                    log.error((Object)"{} Agent {}({}) failed to initialize", reply.cause(), new Object[]{run.id, agent.name, agent.deploymentId});
                    run.errors.add(new Run.Error(agent, reply.cause()));
                    this.stopSimulation(run);
                }
            });
        }
    }

    private void startSimulation(Run run) {
        this.vertx.executeBlocking(future -> {
            List<RunHook> hooks = this.loadHooks("pre");
            hooks.addAll(run.benchmark.preHooks());
            Collections.sort(hooks);
            for (RunHook hook : hooks) {
                StringBuilder sb = new StringBuilder();
                boolean success = hook.run(this.getRunProperties(run), sb::append);
                run.hookResults.add(new Run.RunHookOutput(hook.name(), sb.toString()));
                if (success) continue;
                run.errors.add(new Run.Error(null, (Throwable)new BenchmarkExecutionException("Execution of run hook " + hook.name() + " failed.")));
                future.fail("Execution of pre-hook " + hook.name() + " failed.");
                break;
            }
            future.complete();
        }, result -> {
            if (result.succeeded()) {
                this.vertx.runOnContext(nil -> {
                    assert (run.startTime == Long.MIN_VALUE);
                    run.startTime = System.currentTimeMillis();
                    for (Phase phase : run.benchmark.phases()) {
                        run.phases.put(phase.name(), new ControllerPhase(phase));
                    }
                    this.runSimulation(run);
                });
            } else {
                log.error((Object)"{} Failed to start the simulation", new Object[]{run.id, result.cause()});
                this.stopSimulation(run);
            }
        });
    }

    private void runSimulation(Run run) {
        ControllerPhase[] availablePhases;
        if (this.timerId >= 0L) {
            this.vertx.cancelTimer(this.timerId);
            this.timerId = -1L;
        }
        long now = System.currentTimeMillis();
        for (ControllerPhase controllerPhase : run.phases.values()) {
            if (controllerPhase.status() == ControllerPhase.Status.RUNNING && controllerPhase.absoluteStartTime() + controllerPhase.definition().duration() <= now) {
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.FINISH, controllerPhase.definition().name));
                controllerPhase.status(run.id, ControllerPhase.Status.FINISHING);
            }
            if (controllerPhase.status() != ControllerPhase.Status.FINISHED) continue;
            if (controllerPhase.definition().maxDuration() >= 0L && controllerPhase.absoluteStartTime() + controllerPhase.definition().maxDuration() <= now) {
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TERMINATE, controllerPhase.definition().name));
                controllerPhase.status(run.id, ControllerPhase.Status.TERMINATING);
                continue;
            }
            if (!controllerPhase.definition().terminateAfterStrict().stream().map(run.phases::get).allMatch(p -> p.status().isTerminated())) continue;
            this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TRY_TERMINATE, controllerPhase.definition().name));
        }
        for (ControllerPhase phase3 : availablePhases = run.getAvailablePhases()) {
            this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.RUN, phase3.definition().name));
            phase3.absoluteStartTime(now);
            phase3.status(run.id, ControllerPhase.Status.STARTING);
        }
        if (run.phases.values().stream().allMatch(phase -> phase.status().isTerminated())) {
            log.info((Object)"{} All phases are terminated.", new Object[]{run.id});
            this.stopSimulation(run);
            return;
        }
        long l = run.nextTimestamp();
        long delay = l - System.currentTimeMillis();
        delay = Math.min(delay, 1000L);
        log.debug((Object)"Wait {} ms", new Object[]{delay});
        if (delay > 0L) {
            if (this.timerId >= 0L) {
                this.vertx.cancelTimer(this.timerId);
            }
            this.timerId = this.vertx.setTimer(delay, timerId -> this.runSimulation(run));
        } else {
            this.vertx.runOnContext(nil -> this.runSimulation(run));
        }
    }

    private void stopSimulation(Run run) {
        if (run.terminateTime.future().isComplete()) {
            log.warn((Object)"Run {} already completed.", new Object[]{run.id});
            return;
        }
        run.terminateTime.complete((Object)System.currentTimeMillis());
        run.completed = true;
        for (AgentInfo agent : run.agents) {
            if (agent.deploymentId == null) {
                assert (agent.status == AgentInfo.Status.STARTING);
                if (agent.deployedAgent == null) continue;
                agent.deployedAgent.stop();
                continue;
            }
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(AgentControlMessage.Command.STOP, agent.id, null), reply -> {
                if (reply.succeeded()) {
                    agent.status = AgentInfo.Status.STOPPED;
                    this.checkAgentsStopped(run);
                    log.debug((Object)"Agent {}/{} stopped.", new Object[]{agent.name, agent.deploymentId});
                } else {
                    agent.status = AgentInfo.Status.FAILED;
                    log.error((Object)"Agent {}/{} failed to stop", reply.cause(), new Object[]{agent.name, agent.deploymentId});
                }
                if (agent.deployedAgent != null) {
                    this.vertx.setTimer(3000L, timerId -> agent.deployedAgent.stop());
                }
            });
        }
        this.checkAgentsStopped(run);
    }

    private void checkAgentsStopped(Run run) {
        if (run.agents.stream().allMatch(a -> a.status.ordinal() >= AgentInfo.Status.STOPPED.ordinal())) {
            for (ControllerPhase phase : run.phases.values()) {
                run.statisticsStore.adjustPhaseTimestamps(phase.definition().name(), phase.absoluteStartTime(), phase.absoluteCompletionTime());
            }
            this.persistRun(run);
            log.info((Object)"Run {} completed", new Object[]{run.id});
        }
    }

    private void persistRun(Run run) {
        this.vertx.executeBlocking(future -> {
            try {
                CsvWriter.writeCsv(run.dir.resolve("stats"), run.statisticsStore);
            }
            catch (IOException e2) {
                log.error((Object)"Failed to persist statistics", (Throwable)e2);
                future.fail((Throwable)e2);
            }
            JsonObject info = new JsonObject().put("id", run.id).put("benchmark", run.benchmark.name()).put("startTime", Long.valueOf(run.startTime)).put("terminateTime", (Long)run.terminateTime.future().result()).put("cancelled", Boolean.valueOf(run.cancelled)).put("description", run.description).put("errors", new JsonArray(run.errors.stream().map(e -> {
                JsonObject json = new JsonObject();
                if (e.agent != null) {
                    json.put("agent", e.agent.name);
                }
                return json.put("msg", e.error.getMessage());
            }).collect(Collectors.toList())));
            try {
                Files.write(run.dir.resolve("info.json"), info.encodePrettily().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e3) {
                log.error((Object)"Cannot write info file", (Throwable)e3);
                future.fail((Throwable)e3);
            }
            try (FileOutputStream stream = new FileOutputStream(run.dir.resolve("all.json").toFile());){
                JsonFactory jfactory = new JsonFactory();
                jfactory.setCodec((ObjectCodec)new ObjectMapper());
                JsonGenerator jGenerator = jfactory.createGenerator((OutputStream)stream, JsonEncoding.UTF8);
                jGenerator.setCodec((ObjectCodec)new ObjectMapper());
                JsonWriter.writeArrayJsons(run.statisticsStore, jGenerator, info);
                jGenerator.flush();
                jGenerator.close();
            }
            catch (IOException e4) {
                log.error((Object)"Cannot write all.json file", (Throwable)e4);
                future.fail((Throwable)e4);
            }
            List<RunHook> hooks = this.loadHooks("post");
            hooks.addAll(run.benchmark.postHooks());
            Collections.sort(hooks);
            for (RunHook hook : hooks) {
                StringBuilder sb = new StringBuilder();
                boolean success = hook.run(this.getRunProperties(run), sb::append);
                run.hookResults.add(new Run.RunHookOutput(hook.name(), sb.toString()));
                if (success) continue;
                log.error((Object)("Execution of post-hook " + hook.name() + " failed."));
                break;
            }
            JsonArray hookResults = new JsonArray(run.hookResults.stream().map(r -> new JsonObject().put("name", r.name).put("output", r.output)).collect(Collectors.toList()));
            try {
                Files.write(run.dir.resolve("hooks.json"), hookResults.encodePrettily().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e5) {
                log.error((Object)"Cannot write hook results", (Throwable)e5);
                future.fail((Throwable)e5);
            }
            future.tryComplete();
        }, result -> {
            run.completed = true;
            if (result.failed()) {
                log.error((Object)"Failed to persist run {}", result.cause(), new Object[]{run.id});
            } else {
                log.info((Object)"Successfully persisted run {}", new Object[]{run.id});
            }
        });
    }

    private Map<String, String> getRunProperties(Run run) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("RUN_ID", run.id);
        properties.put("RUN_DIR", Controller.RUN_DIR.resolve(run.id).toAbsolutePath().toString());
        if (run.description != null) {
            properties.put("RUN_DESCRIPTION", run.description);
        }
        properties.put("BENCHMARK", run.benchmark.name());
        File benchmarkFile = Controller.BENCHMARK_DIR.resolve(run.benchmark.name() + ".yaml").toFile();
        if (benchmarkFile.exists()) {
            properties.put("BENCHMARK_PATH", benchmarkFile.getAbsolutePath());
        }
        return properties;
    }

    public Run run(String runId) {
        return this.runs.get(runId);
    }

    public Collection<Run> runs() {
        return this.runs.values();
    }

    public void kill(Run run, Handler<AsyncResult<Void>> handler) {
        log.info((Object)"{} Killing run", new Object[]{run.id});
        try {
            run.cancelled = true;
            for (Map.Entry<String, ControllerPhase> entry : run.phases.entrySet()) {
                ControllerPhase.Status status = entry.getValue().status();
                if (status.isTerminated()) continue;
                if (status == ControllerPhase.Status.NOT_STARTED) {
                    entry.getValue().status(run.id, ControllerPhase.Status.CANCELLED);
                    continue;
                }
                entry.getValue().status(run.id, ControllerPhase.Status.TERMINATING);
                this.eb.publish("control-feed", (Object)new PhaseControlMessage(PhaseControlMessage.Command.TERMINATE, entry.getKey()));
            }
            run.terminateTime.future().onComplete(result -> handler.handle((Object)result.mapEmpty()));
        }
        catch (Throwable e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    public boolean addBenchmark(Benchmark benchmark, String prevVersion, Handler<AsyncResult<Void>> handler) {
        Benchmark prev;
        if (!(prevVersion == null || (prev = this.benchmarks.get(benchmark.name())) != null && prevVersion.equals(prev.version()))) {
            log.info((Object)"Updating benchmark {}, version {} but current version is {}", new Object[]{benchmark.name(), prevVersion, prev != null ? prev.version() : "<non-existent>"});
            return false;
        }
        this.benchmarks.put(benchmark.name(), benchmark);
        this.vertx.executeBlocking(future -> {
            PersistenceUtil.store(benchmark, Controller.BENCHMARK_DIR);
            future.complete();
        }, handler);
        return true;
    }

    public Collection<String> getBenchmarks() {
        return this.benchmarks.keySet();
    }

    public Benchmark getBenchmark(String name) {
        return this.benchmarks.get(name);
    }

    private void loadBenchmarks(Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> {
            try {
                Files.list(Controller.BENCHMARK_DIR).forEach(file -> {
                    try {
                        Benchmark benchmark = PersistenceUtil.load(file);
                        if (benchmark != null) {
                            this.benchmarks.put(benchmark.name(), benchmark);
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to load a benchmark from {}", (Throwable)e, new Object[]{file});
                    }
                });
            }
            catch (IOException e) {
                log.error((Object)"Failed to list benchmark dir {}", (Throwable)e, new Object[]{Controller.BENCHMARK_DIR});
            }
            future.complete();
        }, handler);
    }

    private List<RunHook> loadHooks(String subdir) {
        try {
            File hookDir = Controller.HOOKS_DIR.resolve(subdir).toFile();
            if (hookDir.exists() && hookDir.isDirectory()) {
                return Files.list(hookDir.toPath()).map(Path::toFile).filter(file -> !file.isDirectory() && !file.isHidden()).map(file -> new ExecRunHook(file.getName(), file.getAbsolutePath())).collect(Collectors.toList());
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to list hooks.", (Throwable)e);
        }
        return Collections.emptyList();
    }

    public void listSessions(Run run, boolean includeInactive, BiConsumer<AgentInfo, String> sessionStateHandler, Handler<AsyncResult<Void>> completionHandler) {
        this.invokeOnAgents(run, AgentControlMessage.Command.LIST_SESSIONS, includeInactive, completionHandler, (agent, result) -> {
            List sessions = (List)((Message)result.result()).body();
            for (String state : sessions) {
                sessionStateHandler.accept((AgentInfo)agent, state);
            }
        });
    }

    public void listConnections(Run run, BiConsumer<AgentInfo, String> connectionHandler, Handler<AsyncResult<Void>> completionHandler) {
        this.invokeOnAgents(run, AgentControlMessage.Command.LIST_CONNECTIONS, null, completionHandler, (agent, result) -> {
            List connections = (List)((Message)result.result()).body();
            for (String state : connections) {
                connectionHandler.accept((AgentInfo)agent, state);
            }
        });
    }

    private void invokeOnAgents(Run run, AgentControlMessage.Command command, Object param, Handler<AsyncResult<Void>> completionHandler, BiConsumer<AgentInfo, AsyncResult<Message<Object>>> handler) {
        AtomicInteger agentCounter = new AtomicInteger(1);
        for (AgentInfo agent : run.agents) {
            if (agent.status.ordinal() >= AgentInfo.Status.STOPPED.ordinal()) {
                log.debug((Object)"Cannot invoke command on {}, status: {}", new Object[]{agent.name, agent.status});
                continue;
            }
            agentCounter.incrementAndGet();
            this.eb.request(agent.deploymentId, (Object)new AgentControlMessage(command, agent.id, param), result -> {
                if (result.failed()) {
                    log.error((Object)"Failed to connect to agent {}", result.cause(), new Object[]{agent.name});
                    completionHandler.handle((Object)Future.failedFuture((Throwable)result.cause()));
                } else {
                    handler.accept(agent, (AsyncResult<Message<Object>>)result);
                    if (agentCounter.decrementAndGet() == 0) {
                        completionHandler.handle((Object)Future.succeededFuture());
                    }
                }
            });
        }
        if (agentCounter.decrementAndGet() == 0) {
            completionHandler.handle((Object)Future.succeededFuture());
        }
    }

    public boolean hasControllerLog() {
        return this.deployer != null && this.deployer.hasControllerLog();
    }

    public void downloadControllerLog(long offset, File tempFile, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> this.deployer.downloadControllerLog(offset, tempFile.toString(), handler), result -> {
            if (result.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        });
    }

    public void downloadAgentLog(DeployedAgent deployedAgent, long offset, File tempFile, Handler<AsyncResult<Void>> handler) {
        this.vertx.executeBlocking(future -> this.deployer.downloadAgentLog(deployedAgent, offset, tempFile.toString(), handler), result -> {
            if (result.failed()) {
                handler.handle((Object)Future.failedFuture((Throwable)result.cause()));
            }
        });
    }

    public Benchmark ensureBenchmark(Run run) {
        if (run.benchmark.source() == null) {
            File serializedSource = Controller.RUN_DIR.resolve(run.id).resolve(run.benchmark.name() + ".serialized").toFile();
            if (serializedSource.exists() && serializedSource.isFile()) {
                run.benchmark = PersistenceUtil.load(serializedSource.toPath());
                return run.benchmark;
            }
            File yamlSource = Controller.RUN_DIR.resolve(run.id).resolve(run.benchmark.name() + ".yaml").toFile();
            if (yamlSource.exists() && yamlSource.isFile()) {
                run.benchmark = PersistenceUtil.load(yamlSource.toPath());
                return run.benchmark;
            }
            log.warn((Object)("Cannot find benchmark source for run " + run.id + ", benchmark " + run.benchmark.name()));
        }
        return run.benchmark;
    }

    public void shutdown() {
        InfinispanClusterManager clusterManager = (InfinispanClusterManager)((VertxInternal)this.vertx).getClusterManager();
        if (clusterManager != null) {
            BasicCacheContainer cacheManager = clusterManager.getCacheContainer();
            this.vertx.close(ar -> cacheManager.stop());
        } else {
            this.vertx.close();
        }
    }

    public int actualPort() {
        return this.server.httpServer.actualPort();
    }

    public Path getRunDir(Run run) {
        return Controller.RUN_DIR.resolve(run.id);
    }

    public JsonObject getConfig() {
        return this.context.config();
    }
}

