/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.clustering.messages.RequestStatsMessage;
import io.hyperfoil.core.impl.statistics.StatisticsCollector;
import io.hyperfoil.core.util.CountDown;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Iterator;

public class RequestStatsSender
extends StatisticsCollector {
    private static final Logger log = LoggerFactory.getLogger(RequestStatsSender.class);
    private final String address;
    private final String runId;
    private final EventBus eb;
    private final StatisticsCollector.StatisticsConsumer sendStats = this::sendStats;

    public RequestStatsSender(Benchmark benchmark, EventBus eb, String address, String runId) {
        super(benchmark);
        this.eb = eb;
        this.address = address;
        this.runId = runId;
    }

    public void send(CountDown completion) {
        this.visitStatistics(this.sendStats, completion);
    }

    private void sendStats(Phase phase, int stepId, String metric, StatisticsSnapshot statistics, CountDown countDown) {
        if (statistics.histogram.getEndTimeStamp() >= statistics.histogram.getStartTimeStamp()) {
            log.debug((Object)"Sending stats for {} {}/{}, id {}: {} requests, {} responses", new Object[]{phase.name(), stepId, metric, statistics.sequenceId, statistics.requestCount, statistics.responseCount});
            StatisticsSnapshot copy = new StatisticsSnapshot();
            statistics.copyInto(copy);
            countDown.increment();
            this.eb.request("stats-feed", (Object)new RequestStatsMessage(this.address, this.runId, phase.id(), false, stepId, metric, copy), reply -> countDown.countDown());
        }
    }

    public void sendPhaseComplete(Phase phase, CountDown countDown) {
        Iterator iterator = this.aggregated.keySet().iterator();
        while (iterator.hasNext()) {
            int phaseAndStepId = (Integer)iterator.next();
            if (phase != null && phase != this.phases[phaseAndStepId >> 16]) continue;
            countDown.increment();
            this.eb.request("stats-feed", (Object)new RequestStatsMessage(this.address, this.runId, phaseAndStepId >> 16, true, -1, null, null), reply -> countDown.countDown());
        }
    }
}

