/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.clustering.AgentInfo;
import io.hyperfoil.clustering.ControllerPhase;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.core.util.Util;
import io.vertx.core.Promise;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class Run {
    final String id;
    final Path dir;
    Benchmark benchmark;
    final Map<String, ControllerPhase> phases = new HashMap<String, ControllerPhase>();
    final List<AgentInfo> agents = new ArrayList<AgentInfo>();
    final Phase[] phasesById;
    final List<Error> errors = new ArrayList<Error>();
    final List<RunHookOutput> hookResults = new ArrayList<RunHookOutput>();
    long deployTimerId;
    String description;
    long startTime = Long.MIN_VALUE;
    Promise<Long> terminateTime = Promise.promise();
    boolean cancelled;
    boolean completed;
    StatisticsStore statisticsStore;

    Run(String id, Path dir, Benchmark benchmark) {
        this.id = id;
        this.dir = dir;
        this.benchmark = benchmark;
        this.phasesById = benchmark.phasesById();
    }

    long nextTimestamp() {
        long nextPhaseStart = this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.NOT_STARTED && phase.definition().startTime() >= 0L).mapToLong(phase -> this.startTime + phase.definition().startTime()).min().orElse(Long.MAX_VALUE);
        long nextPhaseFinish = this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.RUNNING).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().duration()).min().orElse(Long.MAX_VALUE);
        long nextPhaseTerminate = this.phases.values().stream().filter(phase -> (phase.status() == ControllerPhase.Status.RUNNING || phase.status() == ControllerPhase.Status.FINISHED) && phase.definition().maxDuration() >= 0L).mapToLong(phase -> phase.absoluteStartTime() + phase.definition().maxDuration()).min().orElse(Long.MAX_VALUE);
        return Math.min(Math.min(nextPhaseStart, nextPhaseFinish), nextPhaseTerminate);
    }

    ControllerPhase[] getAvailablePhases() {
        return (ControllerPhase[])this.phases.values().stream().filter(phase -> phase.status() == ControllerPhase.Status.NOT_STARTED && this.startTime + phase.definition().startTime() <= System.currentTimeMillis() && phase.definition().startAfter().stream().allMatch(dep -> this.phases.get(dep).status().isFinished()) && phase.definition().startAfterStrict().stream().allMatch(dep -> this.phases.get(dep).status().isTerminated())).toArray(ControllerPhase[]::new);
    }

    public String phase(int phaseId) {
        return this.phasesById[phaseId].name();
    }

    public static class RunHookOutput {
        public final String name;
        public final String output;

        public RunHookOutput(String name, String output) {
            this.name = name;
            this.output = output;
        }
    }

    public static class Error {
        public final AgentInfo agent;
        public final Throwable error;

        public Error(AgentInfo agent, Throwable error) {
            this.agent = agent;
            this.error = error;
        }

        public String toString() {
            return (String)(this.agent == null ? "" : this.agent.name + ": ") + Util.explainCauses((Throwable)this.error);
        }
    }
}

