/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering;

import io.hyperfoil.clustering.messages.SessionStatsMessage;
import io.hyperfoil.core.impl.SessionStatsConsumer;
import io.vertx.core.eventbus.EventBus;
import java.util.HashMap;
import java.util.Map;

public class SessionStatsSender
implements SessionStatsConsumer {
    private final String address;
    private final String runId;
    private final EventBus eb;
    private Map<String, SessionStatsMessage.MinMax> sessionStats;

    public SessionStatsSender(EventBus eb, String address, String runId) {
        this.address = address;
        this.runId = runId;
        this.eb = eb;
    }

    public void send() {
        if (this.sessionStats != null) {
            this.eb.send("stats-feed", (Object)new SessionStatsMessage(this.address, this.runId, System.currentTimeMillis(), this.sessionStats));
            this.sessionStats = null;
        }
    }

    public void accept(String phase, int minSessions, int maxSessions) {
        if (this.sessionStats == null) {
            this.sessionStats = new HashMap<String, SessionStatsMessage.MinMax>();
        }
        this.sessionStats.put(phase, new SessionStatsMessage.MinMax(minSessions, maxSessions));
    }
}

