/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.util;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class PersistedBenchmarkData
implements BenchmarkData {
    private static final Logger log = LoggerFactory.getLogger(PersistedBenchmarkData.class);
    private final Path dir;

    public static void store(Map<String, byte[]> files, Path dir) throws IOException {
        for (Map.Entry<String, byte[]> entry : files.entrySet()) {
            Files.write(dir.resolve(PersistedBenchmarkData.sanitize(entry.getKey())), entry.getValue(), new OpenOption[0]);
        }
    }

    public PersistedBenchmarkData(Path dir) {
        this.dir = dir;
    }

    public InputStream readFile(String file) {
        String sanitized = PersistedBenchmarkData.sanitize(file);
        try {
            return new FileInputStream(this.dir.resolve(sanitized).toFile());
        }
        catch (FileNotFoundException e) {
            throw new BenchmarkDefinitionException("Cannot load file " + file + "(" + sanitized + ") from directory " + this.dir, (Throwable)e);
        }
    }

    public Map<String, byte[]> files() {
        if (!this.dir.toFile().exists() || !this.dir.toFile().isDirectory()) {
            return Collections.emptyMap();
        }
        try {
            return Files.list(this.dir).collect(Collectors.toMap(path -> path.getFileName().toString(), path -> {
                try {
                    return Files.readAllBytes(path);
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read file {}", (Throwable)e, new Object[]{path});
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot list directory " + this.dir, e);
        }
    }

    public static String sanitize(String file) {
        return file.replace(File.separatorChar, '_').replace(File.pathSeparatorChar, '_');
    }
}

