/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.util;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.clustering.util.PersistedBenchmarkData;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.util.Util;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class PersistenceUtil {
    private static final Logger log = LoggerFactory.getLogger(PersistenceUtil.class);

    public static void store(Benchmark benchmark, Path dir) {
        try {
            byte[] bytes = Util.serialize((Benchmark)benchmark);
            if (bytes != null) {
                Path path = dir.resolve(benchmark.name() + ".serialized");
                try {
                    Files.write(path, bytes, new OpenOption[0]);
                    log.info((Object)"Stored benchmark '{}' in {}", new Object[]{benchmark.name(), path});
                }
                catch (IOException e) {
                    log.error((Object)"Failed to persist benchmark {} to {}", (Throwable)e, new Object[]{benchmark.name(), path});
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed to serialize", (Throwable)e);
        }
        if (benchmark.source() != null) {
            if (!dir.toFile().exists() && !dir.toFile().mkdirs()) {
                log.error((Object)"Failed to create directory {}", new Object[]{dir});
            }
            Path path = dir.resolve(benchmark.name() + ".yaml");
            try {
                Files.write(path, benchmark.source().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                log.info((Object)"Stored benchmark '{}' in {}", new Object[]{benchmark.name(), path});
            }
            catch (IOException e) {
                log.error((Object)"Failed to persist benchmark {} to {}", (Throwable)e, new Object[]{benchmark.name(), path});
            }
            Path dataDirPath = dir.resolve(benchmark.name() + ".data");
            File dataDir = dataDirPath.toFile();
            if (dataDir.exists()) {
                for (File file : dataDir.listFiles()) {
                    if (!file.delete()) continue;
                    log.warn((Object)"Could not delete old file {}", new Object[]{file});
                }
                if (benchmark.files().isEmpty()) {
                    dataDir.delete();
                }
            } else if (!(dataDir.exists() || benchmark.files().isEmpty() || dataDir.mkdir())) {
                log.error((Object)"Couldn't create data dir {}", new Object[]{dataDir});
                return;
            }
            try {
                PersistedBenchmarkData.store(benchmark.files(), dataDirPath);
            }
            catch (IOException e) {
                log.error((Object)"Couldn't persist files for benchmark {}", (Throwable)e, new Object[]{benchmark.name()});
            }
        }
    }

    public static Benchmark load(Path file) {
        block14: {
            String filename = file.getFileName().toString();
            if (filename.endsWith(".yaml")) {
                BenchmarkData data = BenchmarkData.EMPTY;
                String dataDirName = filename.substring(0, filename.length() - 5) + ".data";
                Path dataDirPath = file.getParent().resolve(dataDirName);
                File dataDir = dataDirPath.toFile();
                if (dataDir.exists()) {
                    if (dataDir.isDirectory()) {
                        data = new PersistedBenchmarkData(dataDirPath);
                    } else {
                        log.error((Object)"Expected data dir {} to be a directory!", new Object[]{dataDirName});
                    }
                }
                try {
                    String source = new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
                    Benchmark benchmark = BenchmarkParser.instance().buildBenchmark(source, data);
                    log.info((Object)"Loaded benchmark '{}' from {}", new Object[]{benchmark.name(), file});
                    return benchmark;
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read file {}", (Throwable)e, new Object[]{file});
                }
                catch (ParserException e) {
                    log.error((Object)"Cannot parser file {}", (Throwable)e, new Object[]{file});
                }
            } else {
                if (filename.endsWith(".serialized")) {
                    try {
                        Benchmark benchmark = Util.deserialize((byte[])Files.readAllBytes(file));
                        if (benchmark != null) {
                            log.info((Object)"Loaded benchmark '{}' from {}", new Object[]{benchmark.name(), file});
                            return benchmark;
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        log.info((Object)"Cannot load serialized benchmark from {} (likely a serialization issue, see traces for details)", new Object[]{file});
                        log.trace((Object)"Cannot read file {}", (Throwable)e, new Object[]{file});
                        return null;
                    }
                }
                if (file.toFile().isDirectory() && filename.endsWith(".data")) {
                    log.debug((Object)"Ignoring directory {}", new Object[]{filename});
                } else {
                    log.warn((Object)"Unknown benchmark file format: {}", new Object[]{file});
                }
            }
        }
        return null;
    }
}

