/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.cli.commands.BaseEditCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.clustering.webcli.WebBenchmarkData;
import io.hyperfoil.clustering.webcli.WebCliContext;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import java.util.concurrent.CountDownLatch;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;

@CommandDefinition(name="edit", description="Edit benchmark definition.")
public class WebEdit
extends BaseEditCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        CountDownLatch latch;
        Benchmark updated;
        Client.BenchmarkRef benchmarkRef = this.ensureBenchmark(invocation);
        Client.BenchmarkSource source = this.ensureSource(invocation, benchmarkRef);
        WebCliContext context = (WebCliContext)invocation.context();
        WebBenchmarkData filesData = new WebBenchmarkData();
        String updatedSource = source.source;
        while (true) {
            CountDownLatch latch2;
            WebCliContext webCliContext = context;
            synchronized (webCliContext) {
                latch2 = context.latch = new CountDownLatch(1);
            }
            invocation.println("__HYPERFOIL_EDIT_MAGIC__");
            invocation.println(updatedSource);
            try {
                latch2.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            webCliContext = context;
            synchronized (webCliContext) {
                context.latch = null;
                if (context.editBenchmark == null) {
                    invocation.println("Edits cancelled.");
                    return CommandResult.SUCCESS;
                }
                updatedSource = context.editBenchmark.toString();
                context.editBenchmark = null;
            }
            try {
                updated = BenchmarkParser.instance().buildBenchmark(updatedSource, (BenchmarkData)filesData);
                break;
            }
            catch (BenchmarkDefinitionException | ParserException e) {
                invocation.error(e);
                invocation.print("Retry edits? [Y/n] ");
                try {
                    switch (invocation.inputLine().trim().toLowerCase()) {
                        case "n": 
                        case "no": {
                            return CommandResult.FAILURE;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    invocation.println("Edits cancelled.");
                    return CommandResult.FAILURE;
                }
            }
        }
        String prevVersion = source.version;
        if (!updated.name().equals(benchmarkRef.name())) {
            invocation.println("NOTE: Renamed benchmark " + benchmarkRef.name() + " to " + updated.name() + "; old benchmark won't be deleted.");
            prevVersion = null;
        }
        Object object = context;
        synchronized (object) {
            latch = context.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_FILE_LIST__");
        invocation.println(this.benchmark);
        invocation.println(prevVersion == null ? "" : prevVersion);
        for (String file : filesData.files) {
            invocation.println(file);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_END_OF_FILES__");
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return CommandResult.SUCCESS;
    }
}

