/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.clustering.webcli;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.clustering.webcli.WebBenchmarkData;
import io.hyperfoil.clustering.webcli.WebCliContext;
import io.hyperfoil.core.parser.BenchmarkParser;
import io.hyperfoil.core.parser.ParserException;
import java.util.concurrent.CountDownLatch;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;

@CommandDefinition(name="upload", description="Uploads benchmark definition to Hyperfoil Controller server")
public class WebUpload
implements Command<HyperfoilCommandInvocation> {
    @Argument(description="Argument ignored (provided only for compatibility).")
    String dummy;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(HyperfoilCommandInvocation invocation) {
        Benchmark benchmark;
        String updatedSource;
        CountDownLatch latch;
        WebCliContext context;
        WebCliContext webCliContext = context = (WebCliContext)invocation.context();
        synchronized (webCliContext) {
            latch = context.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_UPLOAD_MAGIC__");
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        WebCliContext webCliContext2 = context;
        synchronized (webCliContext2) {
            context.latch = null;
            if (context.editBenchmark == null) {
                invocation.println("Edits cancelled.");
                return CommandResult.SUCCESS;
            }
            updatedSource = context.editBenchmark.toString();
            context.editBenchmark = null;
        }
        WebBenchmarkData filesData = new WebBenchmarkData();
        try {
            benchmark = BenchmarkParser.instance().buildBenchmark(updatedSource, (BenchmarkData)filesData);
        }
        catch (BenchmarkDefinitionException | ParserException e) {
            invocation.error(e);
            return CommandResult.FAILURE;
        }
        WebCliContext webCliContext3 = context;
        synchronized (webCliContext3) {
            latch = context.latch = new CountDownLatch(1);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_FILE_LIST__");
        invocation.println(benchmark.name());
        invocation.println("");
        for (String file : filesData.files) {
            invocation.println(file);
        }
        invocation.println("__HYPERFOIL_BENCHMARK_END_OF_FILES__");
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return CommandResult.SUCCESS;
    }
}

