/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.Data;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.core.builders.SLA;
import io.hyperfoil.core.util.LowHigh;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class CsvWriter {
    private static final Logger log = LoggerFactory.getLogger(CsvWriter.class);

    /*
     * WARNING - void declaration
     */
    public static void writeCsv(Path dir, StatisticsStore store) throws IOException {
        void var7_13;
        File statsDir;
        Optional<Data> incomplete = store.data.values().stream().flatMap(m -> m.values().stream()).filter(d -> !d.isCompleted()).findAny();
        if (incomplete.isPresent()) {
            log.error((Object)"Phase {} metric {} was not completed!", new Object[]{incomplete.get().phase, incomplete.get().metric});
        }
        if (!(statsDir = dir.toFile()).exists() && !statsDir.mkdirs()) {
            throw new IOException("Cannot create directory " + dir);
        }
        Data[] sorted = (Data[])store.data.values().stream().flatMap(map -> map.values().stream()).toArray(Data[]::new);
        Arrays.sort(sorted, Comparator.comparing(d -> d.phase).thenComparing(d -> d.metric).thenComparingInt(d -> d.stepId));
        try (Data[] writer = new PrintWriter(dir + File.separator + "total.csv");){
            writer.print("Phase,Metric,Start,End,");
            StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
            writer.println(",MinSessions,MaxSessions");
            for (Data data2 : sorted) {
                writer.print(data2.phase);
                writer.print(',');
                writer.print(data2.metric);
                writer.print(',');
                writer.print(data2.total.histogram.getStartTimeStamp());
                writer.print(',');
                writer.print(data2.total.histogram.getEndTimeStamp());
                writer.print(',');
                data2.total.summary(StatisticsStore.PERCENTILES).printTo((PrintWriter)writer);
                StatisticsStore.SessionPoolStats sps = store.sessionPoolStats.get(data2.phase);
                if (sps == null) {
                    writer.print(",,");
                } else {
                    LowHigh minMax = sps.findMinMax();
                    writer.print(',');
                    writer.print(minMax.low);
                    writer.print(',');
                    writer.print(minMax.high);
                }
                writer.println();
            }
        }
        writer = sorted;
        int n = writer.length;
        boolean bl = false;
        while (var7_13 < n) {
            Data data3 = writer[var7_13];
            String filePrefix = dir + File.separator + CsvWriter.sanitize(data3.phase) + "." + CsvWriter.sanitize(data3.metric) + "." + data3.stepId;
            CsvWriter.writeHistogramAndSeries(filePrefix, data3.total, data3.series);
            ++var7_13;
        }
        CsvWriter.writeCustomStats(sorted, data -> data.total, dir + File.separator + "custom.csv");
        String[] agents = (String[])store.data.values().stream().flatMap(m -> m.values().stream()).flatMap(d -> d.perAgent.keySet().stream()).distinct().sorted().toArray(String[]::new);
        for (String agent : agents) {
            try (Data[] writer = new PrintWriter(dir + File.separator + "agent." + CsvWriter.sanitize(agent) + ".csv");){
                writer.print("Phase,Metric,Start,End,");
                StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
                writer.println(",MinSessions,MaxSessions");
                Data[] minMax = sorted;
                int n2 = minMax.length;
                for (int i = 0; i < n2; ++i) {
                    Data data4 = minMax[i];
                    StatisticsSnapshot agentStats = data4.perAgent.get(agent);
                    if (agentStats == null) continue;
                    writer.print(data4.phase);
                    writer.print(',');
                    writer.print(data4.metric);
                    writer.print(',');
                    writer.print(data4.total.histogram.getStartTimeStamp());
                    writer.print(',');
                    writer.print(data4.total.histogram.getEndTimeStamp());
                    writer.print(',');
                    agentStats.summary(StatisticsStore.PERCENTILES).printTo((PrintWriter)writer);
                    StatisticsStore.SessionPoolStats sps = store.sessionPoolStats.get(data4.phase);
                    if (sps == null || sps.records.get(agent) == null) {
                        writer.print(",,");
                    } else {
                        LowHigh lohi = sps.records.get(agent).stream().map(LowHigh.class::cast).reduce(LowHigh::combine).orElse(new LowHigh(0, 0));
                        writer.print(',');
                        writer.print(lohi.low);
                        writer.print(',');
                        writer.print(lohi.high);
                    }
                    writer.println();
                }
            }
            for (Data data5 : sorted) {
                String filePrefix = dir + File.separator + CsvWriter.sanitize(data5.phase) + "." + CsvWriter.sanitize(data5.metric) + "." + data5.stepId + ".agent." + agent;
                CsvWriter.writeHistogramAndSeries(filePrefix, data5.perAgent.get(agent), data5.agentSeries.get(agent));
            }
            CsvWriter.writeCustomStats(sorted, data -> data.perAgent.get(agent), dir + File.separator + "agent." + CsvWriter.sanitize(agent) + ".custom.csv");
        }
        try (PrintWriter writer = new PrintWriter(dir + File.separator + "failures.csv");){
            writer.print("Phase,Metric,Message,Start,End,");
            StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
            writer.println();
            for (SLA.Failure failure : store.failures) {
                writer.print(failure.phase());
                writer.print(',');
                writer.print(failure.metric());
                writer.print(",\"");
                writer.print(failure.message());
                writer.print("\",");
                StatisticsSummary summary = failure.statistics().summary(StatisticsStore.PERCENTILES);
                writer.print(summary.startTime);
                writer.print(',');
                writer.print(summary.endTime);
                writer.print(',');
                summary.printTo(writer);
                writer.println();
            }
        }
        for (Map.Entry entry : store.sessionPoolStats.entrySet()) {
            try (PrintWriter writer = new PrintWriter(dir + File.separator + CsvWriter.sanitize((String)entry.getKey()) + ".sessions.csv");){
                boolean hadNext;
                StatisticsStore.SessionPoolStats sps = (StatisticsStore.SessionPoolStats)entry.getValue();
                writer.println("Timestamp,Address,MinSessions,MaxSessions");
                String[] addresses = new String[sps.records.size()];
                Iterator[] iterators = new Iterator[sps.records.size()];
                int counter = 0;
                for (Map.Entry<String, List<StatisticsStore.SessionPoolRecord>> byAddress : sps.records.entrySet()) {
                    addresses[counter] = byAddress.getKey();
                    iterators[counter] = byAddress.getValue().iterator();
                    ++counter;
                }
                do {
                    hadNext = false;
                    for (int i = 0; i < addresses.length; ++i) {
                        if (!iterators[i].hasNext()) continue;
                        StatisticsStore.SessionPoolRecord record = (StatisticsStore.SessionPoolRecord)((Object)iterators[i].next());
                        writer.print(record.timestamp);
                        writer.print(',');
                        writer.print(addresses[i]);
                        writer.print(',');
                        writer.print(record.low);
                        writer.print(',');
                        writer.println(record.high);
                        hadNext = true;
                    }
                } while (hadNext);
            }
        }
    }

    private static void writeCustomStats(Data[] sorted, Function<Data, StatisticsSnapshot> selector, String fileName) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(fileName);){
            writer.println("Phase,Metric,Custom,Value");
            for (Data data : sorted) {
                StatisticsSnapshot snapshot = selector.apply(data);
                if (snapshot == null) {
                    log.error((Object)"Missing statistics for {}/{} -> {}", new Object[]{data.phase, data.metric, fileName});
                    continue;
                }
                for (Map.Entry entry : snapshot.custom.entrySet()) {
                    writer.print(data.phase);
                    writer.print(',');
                    writer.print(data.metric);
                    writer.print(',');
                    writer.print(entry.getKey());
                    writer.print(',');
                    writer.println(entry.getValue());
                }
            }
        }
    }

    private static String sanitize(String phase) {
        return phase.replaceAll(File.separator, "_");
    }

    private static void writeHistogramAndSeries(String filePrefix, StatisticsSnapshot total, List<StatisticsSummary> series) throws FileNotFoundException {
        if (total != null) {
            try (PrintStream stream = new PrintStream(new FileOutputStream(filePrefix + ".histogram.csv"));){
                total.histogram.outputPercentileDistribution(stream, 5, Double.valueOf(1000000.0), true);
            }
        }
        if (series != null) {
            try (PrintWriter writer = new PrintWriter(filePrefix + ".series.csv");){
                writer.print("Start,End,");
                StatisticsSummary.printHeader((PrintWriter)writer, (double[])StatisticsStore.PERCENTILES);
                writer.println();
                for (StatisticsSummary summary : series) {
                    writer.print(summary.startTime);
                    writer.print(',');
                    writer.print(summary.endTime);
                    writer.print(',');
                    summary.printTo(writer);
                    writer.println();
                }
            }
        }
    }
}

