/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.StatisticsStore;
import io.hyperfoil.core.builders.SLA;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Data {
    private static final Logger log = LoggerFactory.getLogger(Data.class);
    private static final int MERGE_DELAY = 60;
    private final StatisticsStore statisticsStore;
    final String phase;
    final int stepId;
    final String metric;
    final StatisticsSnapshot total = new StatisticsSnapshot();
    final Map<String, StatisticsSnapshot> perAgent = new HashMap<String, StatisticsSnapshot>();
    final Map<String, IntObjectMap<StatisticsSnapshot>> lastStats = new HashMap<String, IntObjectMap<StatisticsSnapshot>>();
    final List<StatisticsSummary> series = new ArrayList<StatisticsSummary>();
    final Map<String, List<StatisticsSummary>> agentSeries = new HashMap<String, List<StatisticsSummary>>();
    private final Map<SLA, StatisticsStore.Window> windowSlas;
    private final SLA[] totalSlas;
    private int highestSequenceId = 0;
    private boolean completed;

    Data(StatisticsStore statisticsStore, String phase, int stepId, String metric, Map<SLA, StatisticsStore.Window> periodSlas, SLA[] totalSlas) {
        this.statisticsStore = statisticsStore;
        this.phase = phase;
        this.stepId = stepId;
        this.metric = metric;
        this.windowSlas = periodSlas;
        this.totalSlas = totalSlas;
    }

    void record(String address, StatisticsSnapshot stats) {
        stats.addInto(this.total);
        stats.addInto(this.perAgent.computeIfAbsent(address, a -> new StatisticsSnapshot()));
        IntObjectMap partialSnapshots = this.lastStats.computeIfAbsent(address, a -> new IntObjectHashMap());
        StatisticsSnapshot partialSnapshot = (StatisticsSnapshot)partialSnapshots.get(stats.sequenceId);
        if (partialSnapshot == null) {
            partialSnapshots.put(stats.sequenceId, (Object)stats);
        } else {
            stats.addInto(partialSnapshot);
        }
        while (stats.sequenceId > this.highestSequenceId) {
            ++this.highestSequenceId;
            int mergedSequenceId = this.highestSequenceId - 60;
            if (mergedSequenceId < 0) continue;
            this.mergeSnapshots(mergedSequenceId);
        }
    }

    private void mergeSnapshots(int sequenceId) {
        StatisticsSnapshot sum = new StatisticsSnapshot();
        for (Map.Entry<String, IntObjectMap<StatisticsSnapshot>> entry : this.lastStats.entrySet()) {
            StatisticsSnapshot snapshot = (StatisticsSnapshot)entry.getValue().remove(sequenceId);
            if (snapshot == null) continue;
            snapshot.addInto(sum);
            this.agentSeries.computeIfAbsent(entry.getKey(), a -> new ArrayList()).add(snapshot.summary(StatisticsStore.PERCENTILES));
        }
        if (!sum.isEmpty()) {
            this.series.add(sum.summary(StatisticsStore.PERCENTILES));
        }
        for (Map.Entry<String, Object> entry : this.windowSlas.entrySet()) {
            SLA sla = (SLA)entry.getKey();
            StatisticsStore.Window window = (StatisticsStore.Window)entry.getValue();
            window.add(sum);
            SLA.Failure failure = sla.validate(this.phase, this.metric, window.current());
            if (!window.isFull() || failure == null) continue;
            this.statisticsStore.addFailure(failure);
        }
    }

    void completePhase() {
        for (int i = Math.max(0, this.highestSequenceId - 60); i <= this.highestSequenceId; ++i) {
            this.mergeSnapshots(i);
        }
        if (this.series.stream().mapToLong(ss -> ss.requestCount).sum() != (long)this.total.requestCount) {
            log.error((Object)"We lost some data (series) in phase {} metric {}", new Object[]{this.phase, this.metric});
        }
        if (this.agentSeries.values().stream().flatMap(Collection::stream).mapToLong(ss -> ss.requestCount).sum() != (long)this.total.requestCount) {
            log.error((Object)"We lost some data (agent series) in phase {} metric {}", new Object[]{this.phase, this.metric});
        }
        if (this.perAgent.values().stream().mapToLong(ss -> ss.requestCount).sum() != (long)this.total.requestCount) {
            log.error((Object)"We lost some data (per agent) in phase {} metric {}", new Object[]{this.phase, this.metric});
        }
        log.trace((Object)("Validating failures for " + this.phase + "/" + this.metric));
        for (SLA sla : this.totalSlas) {
            SLA.Failure failure = sla.validate(this.phase, this.metric, this.total);
            if (failure == null) continue;
            this.statisticsStore.addFailure(failure);
        }
        this.completed = true;
    }

    boolean isCompleted() {
        return this.completed;
    }
}

