/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.controller;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.statistics.CustomValue;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.controller.Data;
import io.hyperfoil.controller.HistogramConverter;
import io.hyperfoil.controller.model.CustomStats;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStats;
import io.hyperfoil.core.builders.SLA;
import io.hyperfoil.core.util.LowHigh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.HdrHistogram.AbstractHistogram;

public class StatisticsStore {
    static final double[] PERCENTILES = new double[]{0.5, 0.9, 0.99, 0.999, 0.9999};
    private static final Comparator<RequestStats> REQUEST_STATS_COMPARATOR = Comparator.comparing(rs -> rs.summary.startTime).thenComparing(rs -> rs.phase).thenComparing(rs -> rs.metric);
    private final Benchmark benchmark;
    final Map<Integer, Map<String, Data>> data = new HashMap<Integer, Map<String, Data>>();
    private final Consumer<SLA.Failure> failureHandler;
    final List<SLA.Failure> failures = new ArrayList<SLA.Failure>();
    private final int maxFailures = 100;
    private final Map<Integer, SLA.Provider> slaProviders;
    final Map<String, SessionPoolStats> sessionPoolStats = new HashMap<String, SessionPoolStats>();

    public StatisticsStore(Benchmark benchmark, Consumer<SLA.Failure> failureHandler) {
        this.benchmark = benchmark;
        this.failureHandler = failureHandler;
        this.slaProviders = benchmark.steps().filter(SLA.Provider.class::isInstance).map(SLA.Provider.class::cast).collect(Collectors.toMap(SLA.Provider::id, Function.identity(), (s1, s2) -> {
            if (s1 != s2) {
                throw new IllegalStateException();
            }
            return s1;
        }));
    }

    public void record(String address, int phaseId, int stepId, String metric, StatisticsSnapshot stats) {
        Map map = this.data.computeIfAbsent((phaseId << 16) + stepId, phaseStep -> new HashMap());
        Data data = (Data)map.get(metric);
        if (data == null) {
            long collectionPeriod = this.benchmark.statisticsCollectionPeriod();
            SLA.Provider slaProvider = this.slaProviders.get(stepId);
            Map<SLA, Window> rings = slaProvider == null || slaProvider.sla() == null ? Collections.emptyMap() : Stream.of(slaProvider.sla()).filter(sla -> sla.window() > 0L).collect(Collectors.toMap(Function.identity(), sla -> new Window((int)(sla.window() / collectionPeriod))));
            SLA[] total = slaProvider == null || slaProvider.sla() == null ? new SLA[]{} : (SLA[])Stream.of(slaProvider.sla()).filter(sla -> sla.window() <= 0L).toArray(SLA[]::new);
            String phase = this.benchmark.phases().stream().filter(p -> p.id() == phaseId).findFirst().get().name();
            data = new Data(this, phase, stepId, metric, rings, total);
            map.put(metric, data);
        }
        data.record(address, stats);
    }

    public void addFailure(String phase, String metric, long startTimestamp, long endTimestamp, String cause) {
        StatisticsSnapshot statistics = new StatisticsSnapshot();
        statistics.histogram.setStartTimeStamp(startTimestamp);
        statistics.histogram.setEndTimeStamp(endTimestamp);
        this.failures.add(new SLA.Failure(null, phase, metric, statistics, cause));
    }

    public void completePhase(String phase) {
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                if (!data.phase.equals(phase)) continue;
                data.completePhase();
            }
        }
    }

    public void adjustPhaseTimestamps(String phase, long start, long completion) {
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                if (!data.phase.equals(phase)) continue;
                data.total.histogram.setStartTimeStamp(Math.min(start, data.total.histogram.getStartTimeStamp()));
                data.total.histogram.setEndTimeStamp(Math.max(completion, data.total.histogram.getEndTimeStamp()));
            }
        }
    }

    public boolean validateSlas() {
        return this.failures.isEmpty();
    }

    public List<RequestStats> recentSummary(long minValidTimestamp) {
        ArrayList<RequestStats> result = new ArrayList<RequestStats>();
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                OptionalInt lastSequenceId = data.lastStats.values().stream().flatMapToInt(map -> map.keySet().stream().mapToInt(Integer::intValue)).max();
                if (!lastSequenceId.isPresent()) continue;
                int penultimateId = lastSequenceId.getAsInt() - 1;
                StatisticsSnapshot sum = new StatisticsSnapshot();
                data.lastStats.values().stream().map(map -> (StatisticsSnapshot)map.get(penultimateId)).filter(snapshot -> snapshot != null).forEach(snapshot -> snapshot.addInto(sum));
                if (sum.isEmpty() || sum.histogram.getStartTimeStamp() < minValidTimestamp) continue;
                List failures = this.failures.stream().filter(f -> f.phase().equals(data.phase) && (f.metric() == null || f.metric().equals(data.metric))).map(f -> f.message()).collect(Collectors.toList());
                result.add(new RequestStats(data.phase, data.stepId, data.metric, sum.summary(PERCENTILES), failures));
            }
        }
        result.sort(REQUEST_STATS_COMPARATOR);
        return result;
    }

    public List<RequestStats> totalSummary() {
        ArrayList<RequestStats> result = new ArrayList<RequestStats>();
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                StatisticsSummary last = data.total.summary(PERCENTILES);
                List failures = this.failures.stream().filter(f -> f.phase().equals(data.phase) && (f.metric() == null || f.metric().equals(data.metric))).map(f -> f.message()).collect(Collectors.toList());
                result.add(new RequestStats(data.phase, data.stepId, data.metric, last, failures));
            }
        }
        result.sort(REQUEST_STATS_COMPARATOR);
        return result;
    }

    public List<CustomStats> customStats() {
        ArrayList<CustomStats> list = new ArrayList<CustomStats>();
        for (Map<String, Data> m : this.data.values()) {
            for (Data data : m.values()) {
                for (Map.Entry entry : data.total.custom.entrySet()) {
                    list.add(new CustomStats(data.phase, data.stepId, data.metric, entry.getKey().toString(), ((CustomValue)entry.getValue()).toString()));
                }
            }
        }
        Comparator<CustomStats> c = Comparator.comparing(s -> s.phase);
        c = c.thenComparing(s -> s.stepId).thenComparing(s -> s.metric).thenComparing(s -> s.customName);
        Collections.sort(list, c);
        return list;
    }

    public Histogram histogram(String phase, int stepId, String metric) {
        int phaseId = this.benchmark.phases().stream().filter(p -> p.name.equals(phase)).mapToInt(p -> p.id).findFirst().orElse(-1);
        Map<String, Data> phaseStepData = this.data.get((phaseId << 16) + stepId);
        if (phaseStepData == null) {
            return null;
        }
        Data data = phaseStepData.get(metric);
        if (data == null) {
            return null;
        }
        return HistogramConverter.convert((String)phase, (String)metric, (AbstractHistogram)data.total.histogram);
    }

    public void recordSessionStats(String address, long timestamp, String phase, int minSessions, int maxSessions) {
        SessionPoolStats sps = this.sessionPoolStats.computeIfAbsent(phase, p -> new SessionPoolStats());
        sps.records.computeIfAbsent(address, a -> new ArrayList()).add(new SessionPoolRecord(timestamp, minSessions, maxSessions));
    }

    public Map<String, Map<String, LowHigh>> recentSessionPoolSummary(long minValidTimestamp) {
        return this.sessionPoolSummary(records -> {
            SessionPoolRecord record = (SessionPoolRecord)((Object)((Object)records.get(records.size() - 1)));
            return record.timestamp >= minValidTimestamp ? record : null;
        });
    }

    public Map<String, Map<String, LowHigh>> totalSessionPoolSummary() {
        return this.sessionPoolSummary(records -> {
            int low = records.stream().mapToInt(r -> r.low).min().orElse(0);
            int high = records.stream().mapToInt(r -> r.high).max().orElse(0);
            return new LowHigh(low, high);
        });
    }

    private Map<String, Map<String, LowHigh>> sessionPoolSummary(Function<List<SessionPoolRecord>, LowHigh> function) {
        HashMap<String, Map<String, LowHigh>> result = new HashMap<String, Map<String, LowHigh>>();
        for (Map.Entry<String, SessionPoolStats> phaseEntry : this.sessionPoolStats.entrySet()) {
            HashMap<String, LowHigh> addressSummary = new HashMap<String, LowHigh>();
            for (Map.Entry<String, List<SessionPoolRecord>> addressEntry : phaseEntry.getValue().records.entrySet()) {
                LowHigh lohi;
                List<SessionPoolRecord> records = addressEntry.getValue();
                if (records.isEmpty() || (lohi = function.apply(records)) == null) continue;
                addressSummary.put(addressEntry.getKey(), lohi);
            }
            if (addressSummary.isEmpty()) continue;
            result.put(phaseEntry.getKey(), addressSummary);
        }
        return result;
    }

    void addFailure(SLA.Failure failure) {
        if (this.failures.size() < 100) {
            this.failures.add(failure);
        }
        this.failureHandler.accept(failure);
    }

    public List<Data> getData() {
        Data[] rtrn = (Data[])this.data.values().stream().flatMap(map -> map.values().stream()).toArray(Data[]::new);
        Arrays.sort(rtrn, Comparator.comparing(data -> data.phase).thenComparing(d -> d.metric).thenComparingInt(d -> d.stepId));
        return Arrays.asList(rtrn);
    }

    public List<SLA.Failure> getFailures() {
        return this.failures;
    }

    static class SessionPoolRecord
    extends LowHigh {
        final long timestamp;

        private SessionPoolRecord(long timestamp, int min, int max) {
            super(min, max);
            this.timestamp = timestamp;
        }
    }

    static class SessionPoolStats {
        Map<String, List<SessionPoolRecord>> records = new HashMap<String, List<SessionPoolRecord>>();

        SessionPoolStats() {
        }

        LowHigh findMinMax() {
            LowHigh combined;
            int min = Integer.MAX_VALUE;
            int max = 0;
            List iterators = this.records.values().stream().map(List::iterator).collect(Collectors.toList());
            while ((combined = (LowHigh)iterators.stream().filter(Iterator::hasNext).map(Iterator::next).map(LowHigh.class::cast).reduce(LowHigh::sum).orElse(null)) != null) {
                min = Math.min(min, combined.low);
                max = Math.max(max, combined.high);
            }
            return new LowHigh(min, max);
        }
    }

    static final class Window {
        private final StatisticsSnapshot[] ring;
        private final StatisticsSnapshot sum = new StatisticsSnapshot();
        private int ptr = 0;

        Window(int size) {
            assert (size > 0);
            this.ring = new StatisticsSnapshot[size];
        }

        void add(StatisticsSnapshot stats) {
            if (this.ring[this.ptr] != null) {
                this.ring[this.ptr].subtractFrom(this.sum);
            }
            this.ring[this.ptr] = stats;
            stats.addInto(this.sum);
            this.ptr = (this.ptr + 1) % this.ring.length;
        }

        public boolean isFull() {
            return this.ring[this.ptr] != null;
        }

        public StatisticsSnapshot current() {
            return this.sum;
        }
    }
}

