/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.ssh;

import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.DeploymentException;
import io.hyperfoil.internal.Properties;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.scp.ScpClientCreator;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.SftpClientFactory;
import org.apache.sshd.common.util.io.NullOutputStream;

public class SshDeployedAgent
implements DeployedAgent {
    private static final Logger log = LoggerFactory.getLogger(SshDeployedAgent.class);
    private static final String PROMPT = "<_#%@_hyperfoil_@%#_>";
    private static final String DEBUG_ADDRESS = Properties.get((String)"io.hyperfoil.agent.debug.port", null);
    private static final String DEBUG_SUSPEND = Properties.get((String)"io.hyperfoil.agent.debug.suspend", (String)"n");
    private static final String AGENTLIB = "/agentlib";
    final String name;
    final String runId;
    final String username;
    final String hostname;
    final int port;
    final String dir;
    final String extras;
    private ClientSession session;
    private ChannelShell shellChannel;
    private Consumer<Throwable> exceptionHandler;
    private ScpClient scpClient;
    private PrintStream commandStream;
    private BufferedReader reader;

    public SshDeployedAgent(String name, String runId, String username, String hostname, int port, String dir, String extras) {
        this.name = name;
        this.runId = runId;
        this.username = username;
        this.hostname = hostname;
        this.port = port;
        this.dir = dir;
        this.extras = extras;
    }

    public void stop() {
        log.info((Object)("Stopping agent " + this.name));
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed closing output reader", (Throwable)e);
        }
        if (this.commandStream != null) {
            this.commandStream.close();
        }
        try {
            if (this.shellChannel != null) {
                this.shellChannel.close();
            }
        }
        catch (IOException e) {
            log.error((Object)"Failed closing shell", (Throwable)e);
        }
        try {
            this.session.close();
        }
        catch (IOException e) {
            log.error((Object)"Failed closing SSH session", (Throwable)e);
        }
    }

    public void deploy(ClientSession session, Consumer<Throwable> exceptionHandler) {
        String log4jConfigurationFile;
        this.session = session;
        this.exceptionHandler = exceptionHandler;
        this.scpClient = ScpClientCreator.instance().createScpClient(session);
        try {
            this.shellChannel = session.createShellChannel();
            this.shellChannel.setErr((OutputStream)new NullOutputStream());
            OpenFuture open = this.shellChannel.open();
            if (!open.await(10000L)) {
                exceptionHandler.accept(new DeploymentException("Shell not opened within timeout", null));
            }
            if (!open.isOpened()) {
                exceptionHandler.accept(new DeploymentException("Could not open shell", open.getException()));
            }
        }
        catch (IOException e) {
            exceptionHandler.accept(new DeploymentException("Failed to open shell", (Throwable)e));
        }
        this.reader = new BufferedReader(new InputStreamReader(this.shellChannel.getInvertedOut()));
        this.commandStream = new PrintStream(this.shellChannel.getInvertedIn());
        this.runCommand("unset PROMPT_COMMAND; export PS1='<_#%@_hyperfoil_@%#_>'", true);
        this.runCommand("mkdir -p " + this.dir + AGENTLIB, true);
        Map<String, String> remoteMd5 = this.getRemoteMd5();
        Map<String, String> localMd5 = this.getLocalMd5();
        if (localMd5 == null) {
            return;
        }
        String java = Properties.get((String)"io.hyperfoil.agent.java.executable", (String)"java");
        StringBuilder startAgentCommmand = new StringBuilder().append(java).append(" -cp ");
        for (Map.Entry<String, String> entry : localMd5.entrySet()) {
            int n = entry.getKey().lastIndexOf("/");
            String filename = n < 0 ? entry.getKey() : entry.getKey().substring(n + 1);
            String remoteChecksum = remoteMd5.remove(filename);
            if (!((String)entry.getValue()).equals(remoteChecksum)) {
                log.debug((Object)"MD5 mismatch {}/{}, copying {}", new Object[]{entry.getValue(), remoteChecksum, entry.getKey()});
                try {
                    this.scpClient.upload((String)entry.getKey(), this.dir + "/agentlib/" + filename, new ScpClient.Option[]{ScpClient.Option.PreserveAttributes});
                }
                catch (IOException e) {
                    exceptionHandler.accept(e);
                    return;
                }
            }
            startAgentCommmand.append(this.dir).append(AGENTLIB).append('/').append(filename).append(':');
        }
        if (!remoteMd5.isEmpty()) {
            StringBuilder rmCommand = new StringBuilder();
            rmCommand.append("rm --interactive=never ");
            for (Map.Entry entry : remoteMd5.entrySet()) {
                rmCommand.append(" " + this.dir + "/agentlib/" + (String)entry.getKey());
            }
            this.runCommand(rmCommand.toString(), true);
        }
        if ((log4jConfigurationFile = Properties.get((String)"log4j.configurationFile", null)) != null) {
            if (log4jConfigurationFile.startsWith("file://")) {
                log4jConfigurationFile = log4jConfigurationFile.substring("file://".length());
            }
            String filename = log4jConfigurationFile.substring(log4jConfigurationFile.lastIndexOf(File.separatorChar) + 1);
            try {
                String string = this.dir + "/agentlib/" + filename;
                this.scpClient.upload(log4jConfigurationFile, string, new ScpClient.Option[]{ScpClient.Option.PreserveAttributes});
                startAgentCommmand.append(" -D").append("log4j.configurationFile").append("=file://").append(string);
            }
            catch (IOException iOException) {
                log.error((Object)"Cannot copy log4j2 configuration file.", (Throwable)iOException);
            }
        }
        startAgentCommmand.append(" -Djava.net.preferIPv4Stack=true");
        startAgentCommmand.append(" -Dvertx.logger-delegate-factory-class-name=io.vertx.core.logging.Log4j2LogDelegateFactory");
        startAgentCommmand.append(" -D").append("io.hyperfoil.agent.name").append('=').append(this.name);
        startAgentCommmand.append(" -D").append("io.hyperfoil.runid").append('=').append(this.runId);
        startAgentCommmand.append(" -D").append("io.hyperfoil.controller.cluster.ip").append('=').append(Properties.get((String)"io.hyperfoil.controller.cluster.ip", (String)""));
        startAgentCommmand.append(" -D").append("io.hyperfoil.controller.cluster.port").append('=').append(Properties.get((String)"io.hyperfoil.controller.cluster.port", (String)""));
        if (DEBUG_ADDRESS != null) {
            startAgentCommmand.append(" -agentlib:jdwp=transport=dt_socket,server=y,suspend=").append(DEBUG_SUSPEND).append(",address=").append(DEBUG_ADDRESS);
        }
        if (this.extras != null) {
            startAgentCommmand.append(" ").append(this.extras);
        }
        startAgentCommmand.append(" io.hyperfoil.Hyperfoil\\$Agent &> ").append(this.dir).append(File.separatorChar).append("agent.").append(this.name).append(".log");
        String startAgent = startAgentCommmand.toString();
        log.debug((Object)"Starting agent {}: {}", new Object[]{this.name, startAgent});
        this.runCommand(startAgent, false);
    }

    private List<String> runCommand(String cmd, boolean wait) {
        log.trace((Object)"Running command {}", new Object[]{cmd});
        this.commandStream.println(cmd);
        this.commandStream.println();
        this.commandStream.flush();
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            String ignored = this.reader.readLine();
            if (!wait) {
                return null;
            }
            while ((line = this.reader.readLine()) != null && !PROMPT.equals(line)) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            this.exceptionHandler.accept(new DeploymentException("Error reading from shell", (Throwable)e));
            return null;
        }
        return lines;
    }

    private Map<String, String> getLocalMd5() {
        String classpath = System.getProperty("java.class.path");
        HashMap<String, String> md5map = new HashMap<String, String>();
        for (String file : classpath.split(":")) {
            if (!file.endsWith(".jar")) continue;
            try {
                Process process = new ProcessBuilder("md5sum", file).start();
                process.waitFor();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line = reader.readLine();
                    if (line == null) {
                        log.warn((Object)("No output for md5sum " + file));
                        continue;
                    }
                    int space = line.indexOf(32);
                    if (space < 0) {
                        log.warn((Object)("Wrong output for md5sum " + file + ": " + line));
                        continue;
                    }
                    String checksum = line.substring(0, space);
                    md5map.put(file, checksum);
                }
            }
            catch (IOException e) {
                log.info((Object)("Cannot get md5sum for " + file), (Throwable)e);
            }
            catch (InterruptedException e) {
                log.info((Object)("Interrupted waiting for md5sum" + file));
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return md5map;
    }

    private Map<String, String> getRemoteMd5() {
        List<String> lines = this.runCommand("md5sum " + this.dir + "/agentlib/*", true);
        HashMap<String, String> md5map = new HashMap<String, String>();
        for (String line : lines) {
            int space;
            if (line.endsWith("No such file or directory") || (space = line.indexOf(32)) < 0) break;
            String checksum = line.substring(0, space);
            int fileIndex = line.lastIndexOf(47);
            if (fileIndex < 0) {
                fileIndex = space;
            }
            String file = line.substring(fileIndex + 1).trim();
            md5map.put(file, checksum);
        }
        return md5map;
    }

    public void downloadLog(ClientSession session, long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        try (SftpClient sftpClient = SftpClientFactory.instance().createSftpClient(session);){
            try (SftpClient.CloseableHandle handle = sftpClient.open(this.dir + File.separatorChar + "agent." + this.name + ".log");){
                byte[] buffer = new byte[65536];
                try (FileOutputStream output = new FileOutputStream(destinationFile);){
                    int nread;
                    long readOffset = offset;
                    while ((nread = sftpClient.read((SftpClient.Handle)handle, readOffset, buffer)) >= 0) {
                        output.write(buffer, 0, nread);
                        readOffset += (long)nread;
                    }
                }
            }
            handler.handle((Object)Future.succeededFuture());
        }
        catch (IOException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

