/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.deploy.ssh;

import io.hyperfoil.api.config.Agent;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.deployment.DeployedAgent;
import io.hyperfoil.api.deployment.Deployer;
import io.hyperfoil.api.deployment.DeploymentException;
import io.hyperfoil.deploy.ssh.SshDeployedAgent;
import io.hyperfoil.internal.Controller;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.function.Consumer;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.resource.URLResource;
import org.apache.sshd.common.util.security.SecurityUtils;

public class SshDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(SshDeployer.class);
    static final long TIMEOUT = 10000L;
    private final SshClient client = SshClient.setUpDefaultClient();

    private SshDeployer() {
        PropertyResolverUtils.updateProperty((PropertyResolver)this.client, (String)"idle-timeout", (long)Long.MAX_VALUE);
        PropertyResolverUtils.updateProperty((PropertyResolver)this.client, (String)"nio2-read-timeout", (long)Long.MAX_VALUE);
        PropertyResolverUtils.updateProperty((PropertyResolver)this.client, (String)"nio-workers", (int)1);
        this.client.start();
        this.client.setServerKeyVerifier((clientSession1, remoteAddress, serverKey) -> true);
    }

    public DeployedAgent start(Agent agent, String runId, Benchmark benchmark, Consumer<Throwable> exceptionHandler) {
        String hostname = null;
        String username = null;
        int port = -1;
        String dir = null;
        String extras = null;
        if (agent.inlineConfig != null) {
            URL url;
            try {
                url = new URL("http://" + agent.inlineConfig);
            }
            catch (MalformedURLException e) {
                throw new BenchmarkDefinitionException("Failed to parse host:port", (Throwable)e);
            }
            hostname = url.getHost();
            port = url.getPort();
            username = url.getUserInfo();
        }
        if (agent.properties != null) {
            hostname = agent.properties.getOrDefault("host", hostname);
            username = agent.properties.getOrDefault("user", username);
            String portString = (String)agent.properties.get("port");
            if (portString != null) {
                try {
                    port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Failed to parse port number for " + agent.name + ": " + portString));
                }
            }
            dir = (String)agent.properties.get("dir");
            extras = (String)agent.properties.get("extras");
        }
        if (hostname == null) {
            hostname = agent.name;
        }
        if (port < 0) {
            port = 22;
        }
        if (username == null) {
            username = System.getProperty("user.name");
        }
        if (dir == null) {
            dir = Controller.ROOT_DIR.toString();
        }
        try {
            SshDeployedAgent deployedAgent = new SshDeployedAgent(agent.name, runId, username, hostname, port, dir, extras);
            ClientSession session = this.connectAndLogin(username, hostname, port);
            deployedAgent.deploy(session, exceptionHandler);
            return deployedAgent;
        }
        catch (IOException | GeneralSecurityException e) {
            exceptionHandler.accept(new DeploymentException("Cannot connect to agent " + agent.name + " at " + username + "@" + hostname + ":" + port, (Throwable)e));
            return null;
        }
        catch (DeploymentException e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public boolean hasControllerLog() {
        return false;
    }

    public void downloadControllerLog(long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        throw new UnsupportedOperationException();
    }

    public void downloadAgentLog(DeployedAgent deployedAgent, long offset, String destinationFile, Handler<AsyncResult<Void>> handler) {
        SshDeployedAgent sshAgent = (SshDeployedAgent)deployedAgent;
        try {
            ClientSession session = this.connectAndLogin(sshAgent.username, sshAgent.hostname, sshAgent.port);
            sshAgent.downloadLog(session, offset, destinationFile, handler);
        }
        catch (DeploymentException | IOException | GeneralSecurityException e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }

    private ClientSession connectAndLogin(String username, String hostname, int port) throws IOException, GeneralSecurityException, DeploymentException {
        ConnectFuture connect = (ConnectFuture)this.client.connect(username, hostname, port).verify(15000L);
        ClientSession session = connect.getSession();
        String userHome = System.getProperty("user.home");
        URLResource identity = new URLResource(Paths.get(userHome, ".ssh", "id_rsa").toUri().toURL());
        try (InputStream inputStream = identity.openInputStream();){
            session.addPublicKeyIdentity((KeyPair)GenericUtils.head((Iterable)SecurityUtils.loadKeyPairIdentities((SessionContext)session, (NamedResource)identity, (InputStream)inputStream, (s, resourceKey, retryIndex) -> null)));
        }
        AuthFuture auth = session.auth();
        if (!auth.await(10000L)) {
            throw new DeploymentException("Not authenticated within timeout", null);
        }
        if (!auth.isSuccess()) {
            throw new DeploymentException("Failed to authenticate", auth.getException());
        }
        return session;
    }

    public void close() {
        this.client.stop();
    }

    public static class Factory
    implements Deployer.Factory {
        public String name() {
            return "ssh";
        }

        public SshDeployer create() {
            return new SshDeployer();
        }
    }
}

