/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public class Agent
implements Serializable {
    private static final String THREADS = "threads";
    public final String name;
    public final String inlineConfig;
    public final Map<String, String> properties;

    public Agent(String name, String inlineConfig, Map<String, String> properties) {
        this.name = name;
        this.inlineConfig = inlineConfig;
        this.properties = properties == null ? Collections.emptyMap() : properties;
    }

    public int threads() {
        String threadsProperty = this.properties.get(THREADS);
        if (threadsProperty == null || threadsProperty.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt(threadsProperty);
        }
        catch (NumberFormatException e) {
            throw new BenchmarkDefinitionException("Cannot parse number of threads for agent " + this.name + ": " + threadsProperty);
        }
    }
}

