/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Rewritable;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.SequenceBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.impl.StepCatalogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class BaseSequenceBuilder
implements Rewritable<BaseSequenceBuilder> {
    private static final Map<Class<? extends Step.Catalog>, StepCatalogFactory> factories = new HashMap<Class<? extends Step.Catalog>, StepCatalogFactory>();
    protected final BaseSequenceBuilder parent;
    protected final List<StepBuilder<?>> steps = new ArrayList();

    public BaseSequenceBuilder(BaseSequenceBuilder parent) {
        this.parent = parent;
    }

    public <D extends Step.Catalog> D step(Class<D> catalogClass) {
        StepCatalogFactory factory = factories.get(catalogClass);
        if (factory == null) {
            throw new IllegalStateException("Cannot load step catalog");
        }
        Step.Catalog catalog = factory.create(this);
        if (catalogClass.isInstance(catalog)) {
            return (D)((Step.Catalog)catalogClass.cast(catalog));
        }
        throw new IllegalStateException("Unknown step catalog " + catalog + ", want: " + catalogClass);
    }

    public BaseSequenceBuilder step(Step step) {
        this.steps.add(new ProvidedStepBuilder(step));
        return this;
    }

    public BaseSequenceBuilder step(SimpleBuilder builder) {
        this.steps.add(new SimpleAdapter(builder));
        return this;
    }

    public BaseSequenceBuilder stepBuilder(StepBuilder<?> stepBuilder) {
        this.steps.add(stepBuilder);
        return this;
    }

    public BaseSequenceBuilder end() {
        return this.parent;
    }

    public SequenceBuilder rootSequence() {
        return this.parent.rootSequence();
    }

    public ScenarioBuilder endSequence() {
        return this.rootSequence().endSequence();
    }

    @Override
    public void readFrom(BaseSequenceBuilder other) {
        assert (this.steps.isEmpty());
        other.steps.forEach(s -> this.stepBuilder((StepBuilder)s.copy()));
    }

    public String name() {
        return this.parent.name();
    }

    public BaseSequenceBuilder insertBefore(Locator locator) {
        return this.insertWithOffset(locator, 0);
    }

    public BaseSequenceBuilder insertAfter(Locator locator) {
        return this.insertWithOffset(locator, 1);
    }

    private BaseSequenceBuilder insertWithOffset(Locator locator, int offset) {
        for (int i = 0; i < this.steps.size(); ++i) {
            if (this.steps.get(i) != locator.step()) continue;
            StepInserter inserter = new StepInserter(this);
            this.steps.add(i + offset, inserter);
            return inserter;
        }
        throw new NoSuchElementException("Not found: " + locator.step());
    }

    public void prepareBuild() {
        new ArrayList(this.steps).forEach((Consumer<StepBuilder<?>>)((Consumer<StepBuilder>)stepBuilder -> {
            Locator.push(stepBuilder, this);
            stepBuilder.prepareBuild();
            Locator.pop();
        }));
    }

    public List<Step> buildSteps() {
        return this.steps.stream().map(stepBuilder -> {
            Locator.push(stepBuilder, this);
            List<Step> steps = stepBuilder.build();
            Locator.pop();
            return steps;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public int indexOf(StepBuilder<?> builder) {
        return this.steps.indexOf(builder);
    }

    public boolean isEmpty() {
        return this.steps.isEmpty();
    }

    static {
        ServiceLoader.load(StepCatalogFactory.class).forEach(factory -> factories.put(factory.clazz(), (StepCatalogFactory)factory));
    }

    public static class SimpleAdapter
    implements StepBuilder<SimpleAdapter> {
        private final SimpleBuilder builder;

        public SimpleAdapter(SimpleBuilder builder) {
            this.builder = builder;
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(this.builder.build());
        }
    }

    private static class ProvidedStepBuilder
    implements StepBuilder<ProvidedStepBuilder> {
        private final Step step;

        public ProvidedStepBuilder(Step step) {
            this.step = step;
        }

        @Override
        public List<Step> build() {
            return Collections.singletonList(this.step);
        }

        @Override
        public ProvidedStepBuilder copy() {
            return this;
        }
    }

    private static class StepInserter
    extends BaseSequenceBuilder
    implements StepBuilder<StepInserter> {
        private StepInserter(BaseSequenceBuilder parent) {
            super(parent);
        }

        @Override
        public List<Step> build() {
            return this.buildSteps();
        }
    }

    @FunctionalInterface
    public static interface SimpleBuilder {
        public Step build();
    }
}

