/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Rewritable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface BuilderBase<S extends BuilderBase<S>> {
    default public void prepareBuild() {
        for (Class<?> clz = this.getClass(); clz != null && clz != Object.class; clz = clz.getSuperclass()) {
            for (Field f : clz.getDeclaredFields()) {
                if (f.isSynthetic() || Modifier.isStatic(f.getModifiers()) || "parent".equals(f.getName())) continue;
                f.setAccessible(true);
                try {
                    Object value;
                    if (BuilderBase.class.isAssignableFrom(f.getType())) {
                        value = f.get(this);
                        if (value != null) {
                            ((BuilderBase)value).prepareBuild();
                        }
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(f.getType())) {
                        value = f.get(this);
                        if (value != null) {
                            for (Object item : (Collection)value) {
                                if (!(item instanceof BuilderBase)) continue;
                                ((BuilderBase)item).prepareBuild();
                            }
                        }
                        continue;
                    }
                    if (BaseSequenceBuilder.class.isAssignableFrom(f.getType())) {
                        value = f.get(this);
                        if (value != null) {
                            ((BaseSequenceBuilder)value).prepareBuild();
                        }
                        continue;
                    }
                    if (!f.getType().isArray()) continue;
                    throw new UnsupportedOperationException(clz.getName() + "." + f.getName() + " is an array (actual instance: " + this + ")");
                }
                catch (IllegalAccessException e) {
                    throw new UnsupportedOperationException("Cannot get value of " + clz.getName() + "." + f.getName() + " (actual instance: " + this + ")");
                }
            }
        }
    }

    default public S copy() {
        if (this.getClass().isSynthetic()) {
            if (!1.$assertionsDisabled && !this.getClass().getSimpleName().contains("$$Lambda$")) {
                throw new AssertionError();
            }
            return (S)this;
        }
        try {
            BuilderBase copy = null;
            for (Constructor<?> ctor : this.getClass().getConstructors()) {
                if (ctor.getParameterCount() == 0) {
                    copy = (BuilderBase)ctor.newInstance(new Object[0]);
                    break;
                }
                if (ctor.getParameterCount() != 1 || ctor.getParameterTypes()[0] != this.getClass()) continue;
                copy = (BuilderBase)ctor.newInstance(this);
                break;
            }
            if (copy == null) {
                throw new NoSuchMethodException("No constructor for " + this.getClass().getName());
            }
            for (Class<?> cls = this.getClass(); cls != null && cls != BuilderBase.class; cls = cls.getSuperclass()) {
                for (Field f : cls.getDeclaredFields()) {
                    f.setAccessible(true);
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (Rewritable.class.isAssignableFrom(f.getType())) {
                        Object thisRewritable = f.get(this);
                        if (thisRewritable == null) continue;
                        Rewritable copyRewritable = (Rewritable)f.get(copy);
                        if (copyRewritable == null) {
                            copyRewritable = (Rewritable)thisRewritable.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                            f.set(copy, copyRewritable);
                        }
                        copyRewritable.readFrom(thisRewritable);
                        continue;
                    }
                    if (Modifier.isFinal(f.getModifiers())) {
                        Object copyValue;
                        Object thisValue = f.get(this);
                        if (thisValue == (copyValue = f.get(copy))) continue;
                        if (copyValue instanceof Collection) {
                            Collection copyCollection = (Collection)copyValue;
                            copyCollection.clear();
                            copyCollection.addAll((Collection)CopyUtil.deepCopy(thisValue));
                            continue;
                        }
                        if (f.getName().equals("parent")) continue;
                        throw new UnsupportedOperationException(cls.getName() + "." + f.getName() + " is final (actual instance: " + this + ")");
                    }
                    if (f.getType().isPrimitive()) {
                        if (f.getType() == Boolean.TYPE) {
                            f.setBoolean(copy, f.getBoolean(this));
                            continue;
                        }
                        if (f.getType() == Integer.TYPE) {
                            f.setInt(copy, f.getInt(this));
                            continue;
                        }
                        if (f.getType() == Long.TYPE) {
                            f.setLong(copy, f.getLong(this));
                            continue;
                        }
                        if (f.getType() == Double.TYPE) {
                            f.setDouble(copy, f.getDouble(this));
                            continue;
                        }
                        if (f.getType() == Float.TYPE) {
                            f.setFloat(copy, f.getFloat(this));
                            continue;
                        }
                        if (f.getType() == Byte.TYPE) {
                            f.setByte(copy, f.getByte(this));
                            continue;
                        }
                        if (f.getType() == Character.TYPE) {
                            f.setChar(copy, f.getChar(this));
                            continue;
                        }
                        if (f.getType() == Short.TYPE) {
                            f.setShort(copy, f.getShort(this));
                            continue;
                        }
                        throw new UnsupportedOperationException("Unknown primitive: " + f.getType());
                    }
                    if (f.getType().isArray()) {
                        throw new UnsupportedOperationException(cls.getName() + "." + f.getName() + " is an array (actual instance: " + this + ")");
                    }
                    f.set(copy, CopyUtil.deepCopy(f.get(this)));
                }
            }
            return (S)copy;
        }
        catch (ReflectiveOperationException e) {
            throw new BenchmarkDefinitionException("Default deep copy failed", e);
        }
    }

    public static <T extends BuilderBase<T>> List<T> copy(Collection<T> builders) {
        return builders.stream().map(b -> b.copy()).collect(Collectors.toList());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class CopyUtil {
        private static Object deepCopy(Object o) throws ReflectiveOperationException {
            if (o == null) {
                return null;
            }
            if (BuilderBase.class.isAssignableFrom(o.getClass())) {
                return ((BuilderBase)o).copy();
            }
            if (Collection.class.isAssignableFrom(o.getClass())) {
                Collection thisCollection = (Collection)o;
                Collection newCollection = (Collection)thisCollection.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Object item : thisCollection) {
                    newCollection.add(CopyUtil.deepCopy(item));
                }
                return newCollection;
            }
            if (Map.class.isAssignableFrom(o.getClass())) {
                Map thisMap = (Map)o;
                Map newMap = (Map)thisMap.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                for (Map.Entry entry : thisMap.entrySet()) {
                    newMap.put(CopyUtil.deepCopy(entry.getKey()), CopyUtil.deepCopy(entry.getValue()));
                }
                return newMap;
            }
            return o;
        }
    }
}

