/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.BaseSequenceBuilder;
import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.api.config.StepBuilder;
import java.util.Stack;

public interface Locator {
    public StepBuilder<?> step();

    public BaseSequenceBuilder sequence();

    public ScenarioBuilder scenario();

    default public BenchmarkBuilder benchmark() {
        return this.scenario().endScenario().endPhase();
    }

    public static Locator current() {
        Stack<Locator> stack = Holder.CURRENT.get();
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Locator is not set. This method must be invoked within the prepareBuild() or build() phase of scenario.");
        }
        return stack.peek();
    }

    public static void push(Locator locator) {
        Holder.CURRENT.get().push(locator);
    }

    public static void push(StepBuilder<?> stepBuilder, BaseSequenceBuilder sequenceBuilder) {
        Stack<Locator> stack = Holder.CURRENT.get();
        stack.push(new Impl(stepBuilder, sequenceBuilder));
    }

    public static void pop() {
        Holder.CURRENT.get().pop();
    }

    public static class Impl
    implements Locator {
        private final StepBuilder<?> step;
        private final BaseSequenceBuilder sequence;

        private Impl(StepBuilder<?> step, BaseSequenceBuilder sequence) {
            this.step = step;
            this.sequence = sequence;
        }

        @Override
        public StepBuilder<?> step() {
            return this.step;
        }

        @Override
        public BaseSequenceBuilder sequence() {
            return this.sequence;
        }

        @Override
        public ScenarioBuilder scenario() {
            return this.sequence.endSequence();
        }
    }

    public static class Holder {
        private static final ThreadLocal<Stack<Locator>> CURRENT = ThreadLocal.withInitial(Stack::new);
    }
}

