/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.api.config;

import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Scenario;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.function.SerializableSupplier;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.Serializable;
import java.util.Collection;

public abstract class Phase
implements Serializable {
    protected static final Logger log = LoggerFactory.getLogger(Phase.class);
    protected static final boolean trace = log.isTraceEnabled();
    @Visitor.Ignore
    protected final SerializableSupplier<Benchmark> benchmark;
    @Visitor.Ignore
    public final int id;
    public final int iteration;
    @Visitor.Ignore
    public final String name;
    public final Scenario scenario;
    public final long startTime;
    public final Collection<String> startAfter;
    public final Collection<String> startAfterStrict;
    public final Collection<String> terminateAfterStrict;
    public final long duration;
    public final long maxDuration;
    public final String sharedResources;

    public Phase(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources) {
        this.benchmark = benchmark;
        this.id = id;
        this.iteration = iteration;
        this.name = name;
        this.terminateAfterStrict = terminateAfterStrict;
        this.maxDuration = maxDuration;
        this.startAfter = startAfter;
        this.startAfterStrict = startAfterStrict;
        this.scenario = scenario;
        this.startTime = startTime;
        this.duration = duration;
        this.sharedResources = sharedResources;
        if (scenario == null) {
            throw new BenchmarkDefinitionException("Scenario was not set for phase '" + name + "'");
        }
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Scenario scenario() {
        return this.scenario;
    }

    public long startTime() {
        return this.startTime;
    }

    public Collection<String> startAfter() {
        return this.startAfter;
    }

    public Collection<String> startAfterStrict() {
        return this.startAfterStrict;
    }

    public Collection<String> terminateAfterStrict() {
        return this.terminateAfterStrict;
    }

    public long duration() {
        return this.duration;
    }

    public long maxDuration() {
        return this.maxDuration;
    }

    public Benchmark benchmark() {
        return (Benchmark)this.benchmark.get();
    }

    public abstract String description();

    public static class Noop
    extends Phase {
        public Noop(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, Scenario scenario) {
            super(benchmark, id, iteration, name, scenario, -1L, startAfter, startAfterStrict, terminateAfterStrict, 0L, -1L, null);
        }

        @Override
        public String description() {
            return "";
        }
    }

    public static class Sequentially
    extends Phase {
        public final int repeats;

        public Sequentially(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, int repeats) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, sharedResources);
            this.repeats = repeats;
        }

        @Override
        public String description() {
            return this.repeats + " times";
        }
    }

    public static class ConstantRate
    extends OpenModelPhase {
        public final double usersPerSec;

        public ConstantRate(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, double usersPerSec, boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, sharedResources, variance, maxSessions, sessionLimitPolicy);
            this.usersPerSec = usersPerSec;
        }

        @Override
        public String description() {
            return String.format("%.2f users per second", this.usersPerSec);
        }
    }

    public static class RampRate
    extends OpenModelPhase {
        public final double initialUsersPerSec;
        public final double targetUsersPerSec;

        public RampRate(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, double initialUsersPerSec, double targetUsersPerSec, boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, sharedResources, variance, maxSessions, sessionLimitPolicy);
            this.initialUsersPerSec = initialUsersPerSec;
            this.targetUsersPerSec = targetUsersPerSec;
        }

        @Override
        public String description() {
            return String.format("%.2f - %.2f users per second", this.initialUsersPerSec, this.targetUsersPerSec);
        }
    }

    public static abstract class OpenModelPhase
    extends Phase {
        public final boolean variance;
        public final int maxSessions;
        public final SessionLimitPolicy sessionLimitPolicy;

        public OpenModelPhase(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, boolean variance, int maxSessions, SessionLimitPolicy sessionLimitPolicy) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, sharedResources);
            this.variance = variance;
            this.maxSessions = maxSessions;
            this.sessionLimitPolicy = sessionLimitPolicy;
            if (duration < 0L) {
                throw new BenchmarkDefinitionException("Duration was not set for phase '" + name + "'");
            }
        }
    }

    public static enum SessionLimitPolicy {
        FAIL,
        CONTINUE;

    }

    public static class Always
    extends Phase {
        public final int users;

        public Always(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, int users) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, duration, maxDuration, sharedResources);
            if (duration < 0L) {
                throw new BenchmarkDefinitionException("Duration was not set for phase '" + name + "'");
            }
            this.users = users;
        }

        @Override
        public String description() {
            return this.users + " users always";
        }
    }

    public static class AtOnce
    extends Phase {
        public final int users;

        public AtOnce(SerializableSupplier<Benchmark> benchmark, int id, int iteration, String name, Scenario scenario, long startTime, Collection<String> startAfter, Collection<String> startAfterStrict, Collection<String> terminateAfterStrict, long duration, long maxDuration, String sharedResources, int users) {
            super(benchmark, id, iteration, name, scenario, startTime, startAfter, startAfterStrict, terminateAfterStrict, 0L, maxDuration, sharedResources);
            if (duration > 0L) {
                log.warn((Object)"Duration for phase {} is ignored.", new Object[]{duration});
            }
            this.users = users;
        }

        @Override
        public String description() {
            return this.users + " users at once";
        }
    }
}

